#!/bin/sh
#-- opt_portblock --------------------------------------------------------------
# /usr/local/htdocs/portblock_do.cgi - Switching Portgroups in Webinterface
#
# Creation:     25.04.2003  ds
# Last Update:  15.11.2003  ds - v2.0.2b
# opt_portblock by Daniel Sokoll <fli4l@sirsocke.de>
#-------------------------------------------------------------------------------
SEC_REALM='portblock'
SEC_ACTION='action'
. sec-lib.cgi

#set command line parameters...
if [ "$*" != "" ] ; then QUERY_STRING=$* ; fi

#parse variables...
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
  if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
  eval "param_$var"
done

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<html><head><title>Portblocker</title>"
if [ $param_what != 'viewlog' ] && [ $param_what != 'details' ]
then
  echo '<meta HTTP-EQUIV="Refresh" CONTENT="2;url=main_Portblock.cgi">'
fi
echo '<LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">'
echo '<style type="text/css"><!--'
echo 'textarea { font-family: Arial, Helvetica, sans-serif, Veranda; font-size: 12px; width:470}'
echo '// --></style>'
echo "</head><body>"

echo '<center><h2>PortBlocker v2.0.2</h2>'

. /var/run/portblock.conf

if [ $param_what = 'viewlog' ]
then
  #view logfile
  echo '<table border="1" cellspacing="0" cellpadding="3" width="480"><tr>'
  echo '<td bgcolor="silver"><b>PortBlock-Logfile:</b></td>'
  echo "</tr><tr>"
  echo '<td align="center"><textarea name="ausgabe" cols="80" rows="15">'
  if [ -f $PB_LOGFILE ]
  then
    cat $PB_LOGFILE
  else
    echo 'ERROR - '$PB_LOGFILE' nonexistent'
  fi
  echo "</textarea></td>"
  echo '</tr><tr bgcolor="#eeeeee">'
  echo '<td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr>'
  echo '<form action="main_Portblock.cgi" method="get"><td width="20%" align="center">'
  echo '<input type="submit" value=" <-- "></td></form>'
  echo '<td width="60%" align="center">by <a href="mailto:fli4l@sirsocke.de">Daniel Sokoll</a> 2003</td>'
  echo '<form action="portblock_do.cgi" method="get"><td width="20%" align="center">'
  echo '<input type="hidden" name="what" value="dellog">'
  echo '<input type="submit" value="reset"></td></form>'
  echo '</tr></table></td>'
  echo "</tr></table>"
elif [ $param_what = 'dellog' ] && [ $SHOW_DETAILS = 'yes' ]
then
  #reset logfile
  echo "Resetting Logfile..."
  timetmp=`date +%d.%m.%y-%T`
  echo $timetmp' '$REMOTE_USER'/IP:'$REMOTE_ADDR' logfile reset' > $PB_LOGFILE
elif [ $param_what = 'details' ]
then
  #view groupdetails
  if [ $LANGUAGE = "de" ]
  then
    l_protocol="Protokoll"
	 l_direction="Richtung"
  else
    l_protocol="Protocol"
	 l_direction="Direction"
  fi

  eval nametmp='$GROUP_NAME_'$param_groupnum
  eval rulecount='$RULECOUNT_'$param_groupnum

  echo '<table border="1" cellspacing="0" cellpadding="3" width="400">'
  echo '<tr>'
  echo '<td width="400" align="left" bgcolor="silver" colspan="3"><b>'$nametmp'-details:</b></td></tr>'
  echo '<tr><td width="200" valign="middle" align="left" bgcolor="silver">Port(s)</td>'
  echo '<td width="100" valign="middle" align="center" bgcolor="silver">'$l_protocol'</td>'
  echo '<td width="100" valign="middle" align="right" bgcolor="silver">'$l_direction'</td></tr>'

  jdx=1
  while [ $jdx -le $rulecount ]
  do
    eval rules='$RULES_'$param_groupnum'_'$jdx
	 eval portnum='$PORTRULE_'$rules
	 eval protocol='$PROTOCOL_'$rules
    eval direction='$DIRECTIO_'$rules

	 if [ $protocol = "both" ]
	 then
	   protocol="tcp/udp"
	 fi
	 if [ $direction = "both" ]
	 then
	   direction="in/out"
	 fi

    echo '<tr><td width="200" valign="middle" align="left">'$portnum'</td>'
    echo '<td width="100" valign="middle" align="center">'$protocol'</td>'
    echo '<td width="100" valign="middle" align="right">'$direction'</td></tr>'

	 jdx=`/usr/bin/expr $jdx + 1`
  done
  echo '<tr bgcolor="#eeeeee">'
  echo '<form action="main_Portblock.cgi" method="get"><td colspan="3" align="center">'
  echo '<input type="submit" value=" <-- "></td></form>'
  echo "</tr></table>"

else
  #open / close...
  if [ $LANGUAGE = "de" ]
  then
    c1=""
	 c2="sperren"
	 o1=""
	 o2="&ouml;ffnen"
  else
    c1="blocking "
	 c2=""
	 o1="opening "
	 o2=""
  fi

  if [ $FIREWALL_LOG = 'yes' ]
  then
    logging='-l'
  else
    logging=''
  fi
  if [ $param_what = "open" ]
  then
    what='-D'
  else
    what='-A'
  fi

  eval rulecount='$RULECOUNT_'$param_groupnum
  jdx=1
  while [ $jdx -le $rulecount ]
  do
    eval nametmp='$GROUP_NAME_'$param_groupnum

	 #-- logging - begin --
	 if [ $PB_LOGGING = 'yes' ] && [ $jdx = 1 ]
	 then
	   timetmp=`date +%d.%m.%y-%T`
		if [ -f $PB_LOGFILE ]
		then
		  echo $timetmp' '$REMOTE_USER'/IP:'$REMOTE_ADDR' '$param_what' '$nametmp >> $PB_LOGFILE
		else
		  echo $timetmp' '$REMOTE_USER'/IP:'$REMOTE_ADDR' '$param_what' '$nametmp > $PB_LOGFILE
		fi
	 fi
	 #-- logging - end --

	 eval rules='$RULES_'$param_groupnum'_'$jdx
	 eval portnum='$PORTRULE_'$rules
	 eval protocol='$PROTOCOL_'$rules
    eval direction='$DIRECTIO_'$rules

    SOURCE='0.0.0.0/0'
    DESTINATION='0.0.0.0/0'
    if [ $direction = "in" ]
    then
      DESTINATION=$PB_NETWORK
    fi
    if [ $direction = "out" ]
    then
      SOURCE=$PB_NETWORK
    fi

	 if [ $protocol = "both" ]
	 then
	   protocol="tcp"
	 fi
	 if [ $portnum = "ftp" ] || [ $portnum = "amanda" ] || [ $portnum = "snmp" ] || [ $portnum = "kerberos" ]
	 then
	   tmpcall="/sbin/ipchains -L input |grep $portnum |grep -v ftp-data |grep -v amandaidx |grep -v snmp-trap |grep -v kerberos-adm"
	 else
	   tmpcall="/sbin/ipchains -L input |grep ' '$portnum |grep $protocol |grep -v $portnum'[0-9\:]'"
	 fi
	 tmpinf=`eval $tmpcall`
	 if ( [ "$tmpinf" = "" ] && [ $what = "-A" ] ) || ( [ "$tmpinf" != "" ] && [ $what = "-D" ] )
	 then
	   eval protocol='$PROTOCOL_'$rules
		if [ $protocol = "both" ]
		then
		  /sbin/ipchains $what input $logging -p tcp -s $SOURCE -d $DESTINATION $portnum -j $BLOCKTYPE
		  /sbin/ipchains $what input $logging -p udp -s $SOURCE -d $DESTINATION $portnum -j $BLOCKTYPE
		else
		  /sbin/ipchains $what input $logging -p $protocol -s $SOURCE -d $DESTINATION $portnum -j $BLOCKTYPE
		fi
		if [ $jdx = 1 ] && [ $param_what = "close" ]
		then
		  echo $c1'<b>'$nametmp'</b> '$c2'...'
		fi
		if [ $jdx = 1 ] && [ $param_what = "open" ]
		then
		  echo $o1'<b>'$nametmp'</b> '$o2'...'
		fi
	 fi
	 jdx=`/usr/bin/expr $jdx + 1`
  done
fi
echo "</center>"
echo "</body></html>"