#!/bin/sh
#-- opt_portblock --------------------------------------------------------------
# /usr/local/htdocs/main_Portblock.cgi - Show Portstatus in Webinterface
#
# Creation:     25.04.2003  ds
# Last Update:  04.11.2003  ds - v2.0.2
#
# opt_portblock by Daniel Sokoll <fli4l@sirsocke.de>
#-------------------------------------------------------------------------------
SEC_REALM='portblock'
SEC_ACTION='action'
. sec-lib.cgi


echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<html><head><title>PortBlock</title>"
echo '<LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">'
echo '</head><body bgcolor="#ffffff">'

echo '<center><h2>PortBlocker v2.0.2</h2>'

#read variables...
if [ -f /var/run/portblock.conf ]
then
	. /var/run/portblock.conf

#set variables...
  if [ $SHOW_DETAILS = 'yes' ]
  then
    showcols=4
    showwidth=420
  else
    showcols=3
    showwidth=340
  fi

  #set Colors...
  if [ $SWAP_BLOCK_COLORS = 'no' ]
  then
    blockcolor="green"
	 opencolor="red"
  else
    blockcolor="red"
	 opencolor="green"
  fi

  echo '<table border="1" cellspacing="0" cellpadding="'$showcols'" width="'$showwidth'">'

  #translate...
  if [ $LANGUAGE = 'de' ]
  then
    action="Aktion"
	 close="blocken"
	 open="ffnen"
	 statusopen="offen"
	 statusclose="geblockt"
	 reconnect="ndern"
	 viewlog="Logdatei ansehen"
  else
    action="Action"
	 close="block"
	 open="open"
	 statusopen="open"
	 statusclose="blocked"
	 reconnect="change"
	 viewlog="view logfile"
  fi

  #show group-status...
  echo '<tr>'
  echo '<td width="180" align="left" bgcolor="silver"><b>Name</b></td>'
  if [ $SHOW_DETAILS = 'yes' ]
  then
    echo '<td width="80" align="center" bgcolor="silver"><b>Details</b></td>'
  fi
  echo '<td width="80" align="center" bgcolor="silver"><b>Status</b></td>'
  echo '<td width="80" align="right" bgcolor="silver"><b>'$action'</b></td>'
  echo '</tr>'

  echo "#-- portblock.status --" > /var/run/portblock.status
  allblocked='yes'

  idx=1
  while [ $idx -le $GROUPCOUNT_N ]
  do
    eval nametmp='$GROUP_NAME_'$idx
    eval tmp='$RULES_'$idx'_1'
	 eval portnum='$PORTRULE_'$tmp
	 eval protocol='$PROTOCOL_'$tmp
	 if [ $protocol = "both" ]
	 then
	   protocol="tcp"
	 fi
	 if [ $portnum = "ftp" ] || [ $portnum = "amanda" ] || [ $portnum = "snmp" ] || [ $portnum = "kerberos" ]
	 then
	   tmpcall="/sbin/ipchains -L input |grep $portnum |grep -v ftp-data |grep -v amandaidx |grep -v snmp-trap |grep -v kerberos-adm"
	 else
	   tmpcall="/sbin/ipchains -L input |grep ' '$portnum |grep $protocol |grep -v $portnum'[0-9\:]'"
	 fi
	 tmpinf=`eval $tmpcall`

    eval username='$GROUP_USER_'$idx
	 if [ $REMOTE_USER = $username ] || [ $username = 'all' ]
	 then
      echo "<tr>"
		echo '<td valign="middle" align="left"><b>'$nametmp'</b></td>'
      if [ $SHOW_DETAILS = 'yes' ]
      then
 		  echo '<form action="portblock_do.cgi" method="get"><td valign="middle" align="center">'
 		  echo '<input type="submit" value="'Details'">'
		  echo '<input type="hidden" name="what" value="details">'
		  echo '<input type="hidden" name="groupnum" value="'$idx'"></td></form>'
      fi

		if [ "$tmpinf" = "" ]
		then
		  allblocked="no"
		  blocking="open"
		  echo '<td valign="middle" align="center" bgcolor="'$opencolor'"><font color="white"><b>'$statusopen'</b></font></td>'
		  echo '<form action="portblock_do.cgi" method="get"><td valign="middle" align="right">'
		  echo '<input type="submit" value="'$close'">'
		  echo '<input type="hidden" name="what" value="close">'
		else
		  blocking="close"
		  echo '<td valign="middle" align="center" bgcolor="'$blockcolor'"><font color="white"><b>'$statusclose'</b></font></td>'
		  echo '<form action="portblock_do.cgi" method="get"><td valign="middle" align="right">'
		  echo '<input type="submit" value="'$open'">'
		  echo '<input type="hidden" name="what" value="open">'
		fi
		echo '<input type="hidden" name="groupnum" value="'$idx'"></td></form>'
		echo "</tr>"
    else
		if [ "$tmpinf" = "" ]
		then
		  allblocked="no"
		  blocking="open"
		else
		  blocking="close"
		fi
	 fi
    eval nametmp='GROUP_'$idx
    echo "$nametmp='$blocking'" >> /var/run/portblock.status
	 idx=`expr $idx + 1`
  done

  if [ $PB_LOGGING = 'yes' ] && ( [ $REMOTE_USER = $PB_LOGUSER ] || [ $PB_LOGUSER = 'all' ] )
  then
    #show 'view logfile'-option
	 echo '<tr bgcolor="#eeeeee"><form action="portblock_do.cgi" method="get"><td align="center" colspan="'$showcols'">'
	 echo '<input type="submit" value="'$viewlog'">'
    echo '<input type="hidden" name="what" value="viewlog"></td>'
    echo "</form></tr>"
  fi
  echo "</table>"

else
  echo '<b>/var/run/portblock.conf ERROR</b>'
fi
echo '<br><font face="verdana" size="-2">by <a href="mailto:fli4l@sirsocke.de">Daniel Sokoll</a> 2003'
echo '<br><a href="http://www.sirsocke.de" target="_blank">http://www.sirsocke.de</a></font>'
echo "</center>"
echo "</body></html>"

echo "allblocked='$allblocked'" >> /var/run/portblock.status

# -- Set PortBlockStatus if opt_pbstatus = 'yes' --
if [ -f /var/run/pbstatus.conf ]
then
  . /var/run/pbstatus.conf
  if [ $allblocked = "no" ]
  then
    eval $PBS_OPEN
  else
    eval $PBS_CLOSE
  fi
fi