#!/bin/sh
#----------------------------------------------------------------------------
# portblock.sh - OPT_PortBlock ShellScript for use with opt_easycron
#
# Creation:     04.05.2003  ds
# Last Update:  06.11.2003  ds - v2.0.2a
#
# opt_portblock by Daniel Sokoll <fli4l@sirsocke.de>
#----------------------------------------------------------------------------
if [ "$PORTBLOCK_DO_DEBUG" = yes ]
then
  set -x
fi

if [ $# -le 1 ] || [ $1 = "-h" ] || [ $1 = "--help" ]
then
  echo "PortBlock by Daniel Sokoll 2003"
  echo "usage: portblock.sh [open/close] [Numbers of groups seperated with space]"
else
  if [ -f /var/run/portblock.conf ]
  then
    . /var/run/portblock.conf
  else
    echo "'/var/run/portblock.conf' missing - ERROR?"
	 exit 1
  fi

  if [ $FIREWALL_LOG = 'yes' ]
  then
    logging='-l'
  else
    logging=''
  fi

  if [ $1 = 'open' ]
  then
    what='-D'
  else
    what='-A'
  fi

  idx=2
  while [ $idx -le $# ]
  do
    eval worktmp='$'$idx
	 eval rulecount='$RULECOUNT_'$worktmp
	 eval nametmp='$GROUP_NAME_'$worktmp
	 jdx=1
	 while [ $jdx -le $rulecount ]
	 do
	   eval rules='$RULES_'$worktmp'_'$jdx
		eval portnum='$PORTRULE_'$rules
		eval protocol='$PROTOCOL_'$rules
      eval direction='$DIRECTIO_'$rules

      SOURCE='0.0.0.0/0'
      DESTINATION='0.0.0.0/0'
      if [ $direction = "in" ]
      then
        DESTINATION=$MASQ_NETWORK
      fi
      if [ $direction = "out" ]
      then
        SOURCE=$MASQ_NETWORK
      fi
		if [ $protocol = "both" ]
		then
		  protocol="tcp"
		fi
      if [ $portnum = "ftp" ] || [ $portnum = "amanda" ] || [ $portnum = "snmp" ] || [ $portnum = "kerberos" ]
      then
        tmpcall="/sbin/ipchains -L input |grep $portnum |grep -v ftp-data |grep -v amandaidx |grep -v snmp-trap |grep -v kerberos-adm"
      else
        tmpcall="/sbin/ipchains -L input |grep ' '$portnum |grep $protocol |grep -v $portnum'[0-9\:]'"
      fi
		tmpinf=`eval $tmpcall`
      if ( [ "$tmpinf" = "" ] && [ $what = "-A" ] ) || ( [ "$tmpinf" != "" ] && [ $what = "-D" ] )
      then
        eval protocol='$PROTOCOL_'$rules

        #-- logging - begin --
		  if [ $PB_LOGGING = 'yes' ] && [ $jdx = 1 ]
		  then
		    timetmp=`date +%d.%m.%y-%T`
		    if [ -f $PB_LOGFILE ]
		    then
		      echo $timetmp' EASYCRON/portblock.sh '$1' '$nametmp >> $PB_LOGFILE
		    else
		      echo $timetmp' EASYCRON/portblock.sh '$1' '$nametmp > $PB_LOGFILE
		    fi
		  fi
		  #-- logging - end --

        if [ $protocol = "both" ]
        then
          /sbin/ipchains $what input $logging -p tcp -s $SOURCE -d $DESTINATION $portnum -j $BLOCKTYPE
          /sbin/ipchains $what input $logging -p udp -s $SOURCE -d $DESTINATION $portnum -j $BLOCKTYPE
        else
          /sbin/ipchains $what input $logging -p $protocol -s $SOURCE -d $DESTINATION $portnum -j $BLOCKTYPE
        fi
      fi
		jdx=`/usr/bin/expr $jdx + 1`
	 done
	 idx=`/usr/bin/expr $idx + 1`
  done

# --- get and write actual status to portblock.status ---
  if [ -f /var/run/pbstatus.conf ]
  then
    . /var/run/pbstatus.conf

    echo "#-- portblock.status --" > /var/run/portblock.status

    allblocked='yes'
    idx=1
    while [ $idx -le $GROUPCOUNT_N ]
    do
      eval nametmp='$GROUP_NAME_'$idx
      eval tmp='$RULES_'$idx'_1'
      eval portnum='$PORTRULE_'$tmp
      eval protocol='$PROTOCOL_'$tmp
      if [ $protocol = "both" ]
      then
        protocol="tcp"
      fi
      if [ $portnum = "ftp" ] || [ $portnum = "amanda" ] || [ $portnum = "snmp" ] || [ $portnum = "kerberos" ]
      then
        tmpcall="/sbin/ipchains -L input |grep $portnum |grep -v ftp-data |grep -v amandaidx |grep -v snmp-trap |grep -v kerberos-adm"
      else
        tmpcall="/sbin/ipchains -L input |grep ' '$portnum |grep $protocol |grep -v $portnum'[0-9\:]'"
      fi
      tmpinf=`eval $tmpcall`

      if [ "$tmpinf" = "" ]
      then
        allblocked="no"
        blocking="open"
      else
        blocking="close"
      fi

      eval nametmp='GROUP_'$idx
      echo "$nametmp='$blocking'" >> /var/run/portblock.status
      idx=`expr $idx + 1`
    done

    echo "allblocked='$allblocked'" >> /var/run/portblock.status

    if [ $allblocked = "no" ]
    then
      eval $PBS_OPEN
    else
      eval $PBS_CLOSE
    fi
  else
    echo "'/var/run/pbstatus.conf' missing - ERROR?"
    exit 1
  fi
fi

set +x