#!/bin/sh
##-----------------------------------------------------------------------------
## network.cgi                                                            0.2.1
##
## Creation:     11.05.2002  tc
## Last Update:  15.05.2002  tc
##
## Copyright (c) 2002 Thomas Creutz <thomas.creutz@epost.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------

# Zugangsschutz einrichten

SEC_REALM='info'
SEC_ACTION='net'

#. sec-lib.cgi

# HTML-Header
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">"
echo "<title>opt_info - network</title>"
echo "</head><body bgcolor=\"#FFFFFF\" link=\"#FFFFFF\" vlink=\"#C0C0C0\" alink=\"#FF0000\">"
echo

# Tabelle erstellen
echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\"  width=\"100%\" bgcolor=\"f0f0f0\" bordercolor=\"ffffff\">"
echo "<tr bgcolor="000000">"
echo "<td> <center><b><font face=verdana> <a href=\"network.cgi?status\">Status</a> </font></b></center></td>"
echo "<td> <center><b><font face=verdana> <a href=\"network.cgi?routen\">Routen</a> </font></b></center></td>"
echo "<td> <center><b><font face=verdana> <a href=\"network.cgi?traffic\">Traffic</a> </font></b></center></td>"
echo "<td> <center><b><font face=verdana> <a href=\"network.cgi?details\">Details</a> </font></b></center></td>"
echo "</tr></table>"

if [ "$QUERY_STRING" = "" ]
then
	echo "<center><br><br>Bitte whle eine der oberen Kategorien.<br><br></center>"
fi

if [ "$QUERY_STRING" = "status" ]
then
echo "<pre>"
/bin/netstat
echo "</pre>"
fi

if [ "$QUERY_STRING" = "routen" ]
then

echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"f0f0f0\" bordercolor=\"ffffff\" align=\"center\">"
echo "<tr bgcolor=\"000000\">"
echo "    <td colspan=\"8\">"
echo "        <div align=\"center\"><font color=\"ffffff\" face=\"verdana\"><b>Kernel routing table</b></font><div>"
echo "    </td>"
echo "</tr>"
echo "<tr>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Destination</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Gateway</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Genmask</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Flags</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">MSS</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Window</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Use</font></b></center>"
echo "   </td>"
echo "   <td>"
echo "        <center><b><font face=\"verdana\">Interface</font></b></center>"
echo "   </td>"
echo "</tr>"

/sbin/route -n | grep -v "Kernel" | grep -v "Destination" | while read Destination Gateway Genmask Flags MSS Window Use Iface

do
	echo "<tr>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Destination"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Gateway"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Genmask"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Flags"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$MSS"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Window"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Use"`"
	echo "   </td>"
	echo "   <td>"
	echo "        <p align=\"center\">`echo "$Iface"`"
	echo "   </td>"
	echo "</tr>"
done
echo "</table>"
fi

if [ "$QUERY_STRING" = "traffic" ]
then
	echo "<br>"
	echo '<table border="1" cellpadding="0" cellspacing="0"  width="80%" bgcolor="f0f0f0" bordercolor="ffffff" align="center">'
	echo '<tr bgcolor="000000"><td colspan="9">'
	echo "<div align="center"><font color="ffffff" face="verdana"><b>Netzwerk-Traffic</b></font></div></td></tr>"
	echo "<tr><td rowspan="3">Interface</td><th 					colspan="8">INCOMING</th></tr><tr><td>bytes</td><td>packets</td><td>errs</td><td>drop</td><td>fifo</td><td>frame</td><td>compr.</td><td>multicast</td></tr><tr><th colspan="8">OUTGOING</th></tr>"
	cat /proc/net/dev | sed -e '/^Inter-.*$/d' \
	| sed -e '/^ face.*$/d' \
	| sed 's/^\([[:blank:]]*[[:alnum:]]\+:[[:blank:]]*\([[:alnum:]]\+[[:blank:]]\+\)\{8\}\)/\1<\/td><\/tr><tr><td>/g' \
	| sed 's/[[:blank:]]*<\/td><\/tr><tr><td>/<\/td><\/tr><tr><td>/g' \
	| sed 's/[[:blank:]]*:[[:blank:]]*/<\/td><td>/g' \
	| sed 's/^[[:blank:]]*//g' \
	| sed 's/[[:blank:]]*$/<\/td><\/tr>/g' \
	| sed 's/[[:blank:]]\+/<\/td><td>/g' \
	| sed 's/^/<tr><td rowspan="2">/g'
	echo "</table><br>"
	echo "</br>"
fi

if [ "$QUERY_STRING" = "details" ]
then
echo "<pre>"
/sbin/ifconfig > /tmp/info_ifconfig.tmp
cat /tmp/info_ifconfig.tmp
rm /tmp/info_ifconfig.tmp
echo "</pre>"
fi

# HTML Ende
echo ""
echo "<p align=\"right\">"
echo "    <font face=\"verdana\" size=\"-2\">OPT erstellt von <a href=\"mailto:thomas.creutz@epost.de\">"
echo "    <font color=\"#0000FF\">Thomas Creutz</font></a><br>"
echo "    v0.2.1 <a href=\"http://www.alientxc.de/fli4l\" target=\"_blank\">"
echo "    <font color=\"#0000FF\">http://www.alientxc.de/fli4l</font></a></p>"
echo "</body></html>"

exit 0
