#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <signal.h>
#include <stdlib.h>

#ifdef __FreeBSD__
#define BalanceBSD 1
#endif 

#ifdef bsdi
#define BalanceBSD 1
#endif

#ifdef BSD
#define BalanceBSD 1
#endif

#ifdef BalanceBSD
#include <sys/wait.h>
#else
#include <sys/resource.h>
#endif

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/shm.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#define MAXTXSIZE 	(32*1024)
#define FILENAMELEN 	1024
#define SHMDIR 		"/tmp/"

#define MAXCHANNELS 		16	// max channels in group 
#define MAXGROUPS   		16	// max groups
#define MAXINPUTLINE 		128	// max line in input mode 
#define DEFAULTTIMEOUT  	5	// default-timeout for non reachable hosts
#define DEFAULTSELTIMEOUT  	0 	// default-timeout for select


typedef struct {
  int status;
  int port;
  struct in_addr ipaddr;
  int c;			// current # of connections
  int maxc;			// max # of connections, 0 = no limit
  unsigned int bsent;		// bytes sent
  unsigned int breceived;	// bytes received
} CHANNEL;

#define GROUP_RR	0	// Round Robin
#define GROUP_HASH	1	// Hash on Client Address

typedef struct {
  int nchannels;		// number of channels in group
  int current;			// current channel in group
  int type;			// type, either GROUP_RR or GROUP_HASH
  CHANNEL channels[MAXCHANNELS];
} GROUP;

typedef struct {
  int   release;
  int   subrelease;
  int   pid;
  GROUP groups[MAXGROUPS];
} COMMON;

// Macros to access various elements of struct GROUP and struct CHANNEL 
// within COMMON array
//
// a       pointer to variable of type COMMON
// g       group index
// i       channel index

#define cmn_group(a,g)       	 ((a)->groups[(g)])
#define grp_nchannels(a,g) 	 (cmn_group((a),(g)).nchannels)
#define grp_current(a,g)    	 (cmn_group((a),(g)).current)
#define grp_type(a,g)  	 	 (cmn_group((a),(g)).type)
#define grp_channel(a,g,i)  	 (cmn_group((a),(g)).channels[(i)])
#define chn_status(a,g,i)   	 (grp_channel((a),(g),(i)).status)
#define chn_port(a,g,i)		 (grp_channel((a),(g),(i)).port)
#define chn_ipaddr(a,g,i)	 (grp_channel((a),(g),(i)).ipaddr)
#define chn_c(a,g,i)		 (grp_channel((a),(g),(i)).c)
#define chn_maxc(a,g,i)		 (grp_channel((a),(g),(i)).maxc)
#define chn_bsent(a,g,i)	 (grp_channel((a),(g),(i)).bsent)
#define chn_breceived(a,g,i)	 (grp_channel((a),(g),(i)).breceived)

unsigned int hash_fold(char*, int);

