#!/bin/sh
##-----------------------------------------------------------------------------
## info_os.cgi                                                            0.2.3
##
## Creation:     11.05.2002  tc
## Last Update:  24.02.2003  tc
##
## Copyright (c) 2003 Thomas Creutz <thomas.creutz@epost.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------

# Zugangsschutz einrichten

SEC_REALM='info'
SEC_ACTION='os'

. sec-lib.cgi

# HTML-Header
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE=\"text/css\" HREF=\"main.css\">"
echo "<title>opt_info - os</title>"
echo "</head><body bgcolor=\"#FFFFFF\" link=\"#FFFFFF\" vlink=\"#C0C0C0\" alink=\"#FF0000\">"
echo

# Fli4l Version abfragen und Tabelle erstellen
echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"#f0f0f0\" bordercolor=\"#ffffff\" align=\"center\">"
echo "<tr bgcolor=\"#000000\">"
echo "    <td>"
echo "        <div align=\"center\"><font color=\"#ffffff\" face=\"verdana\"><b>Fli4L Version</b></font><div>"
echo "    </td>"
echo "</tr>"
echo "<tr>"
echo "    <td>"
echo "        <div align=\"center\">`cat /etc/version`<div>"
echo "    </td>"
echo "</tr>"
echo "</table><br>"

# Uptime abfragen und Tabelle erstellen
uptime=`cat /proc/uptime | cut -f1 -d"." `
tage=`expr $uptime / 86400`
stunden=`expr $uptime % 86400 / 3600 `
minuten=`expr $uptime % 3600 / 60`
sekunden=`expr $uptime % 60`

echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"#f0f0f0\" bordercolor=\"ffffff\" align=\"center\">"
echo "<tr bgcolor=\"#000000\">"
echo "    <td colspan=\"4\">"
echo "        <div align=\"center\"><font color=\"#ffffff\" face=\"verdana\"><b>Uptime</b></font><div></td>"
echo "</tr>"
echo "<tr>"
echo "    <td colspan=\"4\">"
echo "        <b>Dein Fli4l luft schon seit:</b>"
echo "    </td>"
echo "</tr>"
echo "<tr>"
echo "    <td>"
echo "        <div align=\"center\">$tage Tagen</div>"
echo "    </td>"
echo "    <td>"
echo "        <div align=\"center\">$stunden Stunden</div>"
echo "    </td>"
echo "    <td>"
echo "        <div align=\"center\">$minuten Minuten<br></div>"
echo "    </td>"
echo "    <td>"
echo "        <div align=\"center\">$sekunden Sekunden</div>"
echo "    </td>"
echo "</tr>"
echo "<tr>"
echo "    <td colspan=\"4\">"
echo "        Uptime gesamt in Sekunden: $uptime"
echo "    </td>"
echo "</tr>"
echo "</table><br>"

# OS-Infos abfragen und Tabelle erstellen
ostype=`cat /proc/sys/kernel/ostype`
osrelease=`cat /proc/sys/kernel/osrelease`
version=`cat /proc/sys/kernel/version`

echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"#f0f0f0\" bordercolor=\"#ffffff\" align=\"center\">"
echo "<tr bgcolor=\"#000000\">"
echo "    <td colspan=\"4\">"
echo "        <div align=\"center\"><font color=\"#ffffff\" face=\"verdana\"><b>Operating System</b>"
echo "    </td>"
echo "</tr>"
echo "<tr>"
echo "    <td>"
echo "        <div align=\"center\">OS:<br>$ostype</div>"
echo "    </td>"
echo "    <td>"
echo "        <div align=\"center\">Kernel:<br>$osrelease</div>"
echo "    </td>"
echo "    <td>"
echo "        <div align=\"center\">Kompilierungsdatum:<br>$version</div>"
echo "    </td>"
echo "</tr>"
echo "</table><br>"

# Verbundene Benutzer abfragen und Tabelle erstellen
echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"#f0f0f0\" bordercolor=\"#ffffff\" align=\"center\">"
echo "<tr bgcolor=\"#000000\">"
echo "    <td colspan=\"8\">"
echo "        <div align=\"center\"><font color=\"#ffffff\" face=\"verdana\"><b>Verbundene Benutzer*</b></font><div>"
echo "    </td>"
echo "</tr>"
echo "<tr>"
echo "    <td>"
echo "        <center><b><font face=\"verdana\">USER</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "        <center><b><font face=\"verdana\">TTY</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "       <center><b><font face=\"verdana\">FROM</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "       <center><b><font face=\"verdana\">LOGIN</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "       <center><b><font face=\"verdana\">IDLE</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "      <center><b><font face=\"verdana\">JCPU</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "      <center><b><font face=\"verdana\">PCPU</font></b></center>"
echo "    </td>"
echo "    <td>"
echo "      <center><b><font face=\"verdana\">WHAT</font></b></center>"
echo "    </td>"
echo "</tr>"

w -h | while read USER TTY FROM LOGIN IDLE JCPU PCPU WHAT

do
	echo "<tr>"
	echo "    <td>"
	echo "        <div align=\"center\">$USER</div>"
	echo "    </td>"
	echo "    <td>"
	echo "        <div align=\"center\">$TTY</div>"
	echo "    </td>"
	echo "    <td>"
	echo "        <div align=\"center\">$FROM</div>"
	echo "    </td>"
	echo "    <td>"
	echo "        <div align=\"center\">$LOGIN</div>"
	echo "    </td>"
	echo "    <td>"
	echo "        <div align=\"center\">$IDLE</div>"
	echo "    </td>"
	echo "    <td>"
	echo "        <div align=\"center\">$JCPU</div>"
	echo "    </td>"
	echo "    <td>"
	echo "       <div align=\"center\">$PCPU</div>"
	echo "    </td>"
	echo "    <td>"
	echo "       <div align=\"center\">$WHAT</div>"
	echo "    </td>"
	echo "</tr>"
done

echo "<tr>"
echo "    <td colspan=\"8\">"
echo "        <div align=\"center\"><font face=\"verdana\" size=\"-2\">* Es werden nur Benutzer die &uuml;ber SSH oder Telnet verbunden sind angezeigt!</font><div>"
echo "    </td>"
echo "</tr>"
echo "</table><br>"

# HTML Ende
echo ""
echo "<p align=\"right\">"
echo "    <font face=\"verdana\" size=\"-2\">OPT erstellt von <a href=\"mailto:thomas.creutz@epost.de\">"
echo "    <font color=\"#0000FF\">Thomas Creutz</font></a><br>"
echo "    v0.2.3 <a href=\"http://projekte.alientxc.de\" target=\"_blank\">"
echo "    <font color=\"#0000FF\">http://projekte.alientxc.de</font></a></p>"
echo "</body></html>"

exit 0
