#! /bin/sh
#------------------------------------------------------------------------------
#
# Creation:     30.05.2002  mas
# Last Update:  11.02.2003  Thomas Unger <tomblom@web.de>
#
#------------------------------------------------------------------------------

. /etc/rc.cfg

DATE=`date -R`                                              # aktuelles Datum ermitteln
CMD=$1                                                      # den uebergebenn befehl ermitteln

#------------------------------------------------------------------------------
# Erstellen der pop.cmd wenn SNDMAIL_POPCHECK='yes'
# und kurzes einloggen auf dem pop3-server
#------------------------------------------------------------------------------

if [ "$SNDMAIL_POPCHECK" = "yes" ]
   then
   echo -e "user $SNDMAIL_USER\npass $SNDMAIL_PASSWORD\r\nquit" > /tmp/pop.cmd
   if [ "$SNDMAIL_WAIT_SERVER_RESP" = "" ]
   	then
   	/usr/local/bin/netcat $SNDMAIL_POP $SNDMAIL_PPORT < /tmp/pop.cmd
   	else
   	/usr/local/bin/netcat -i $SNDMAIL_WAIT_SERVER_RESP $SNDMAIL_POP $SNDMAIL_PPORT < /tmp/pop.cmd
   fi
fi

#------------------------------------------------------------------------------
# wenn befehl = -free, dann mail mit angegebenen parametern
#------------------------------------------------------------------------------

if [ "$CMD" = "-free" ]
   then

#------------------------------------------------------------------------------
# parameter -> variablen
#------------------------------------------------------------------------------
   FM=$2
   TO=$3
   SJ=$4
   TX=$5

#------------------------------------------------------------------------------
# Erstellen der smtp.cmd
#------------------------------------------------------------------------------

   (
   echo -e "helo $SNDMAIL_SMTP\r"
   echo -e "mail from: $FM\r"
   echo -e "rcpt to: $TO\r"
   echo -e "data\r"
   echo -e "date: $DATE\r"
   echo -e "from: $FM\r"
   echo -e "to: $TO\r"
   echo -e "subject: $SJ\r"
   echo -e "\r"
   echo -e "$TX\r"
   ) > /tmp/smtp.cmd

   else

#------------------------------------------------------------------------------
# wenn nicht -free dann -newip oder -call
# also standard-variablen aus der config.txt nutzen
# und in die smtp.cmd ablegen
#------------------------------------------------------------------------------

(
echo -e "helo $SNDMAIL_SMTP\r"
echo -e "mail from: $SNDMAIL_FM\r"

   idx=1
   while [ "$idx" -le "$SNDMAIL_TO_N" ]
   do
   eval TO='$SNDMAIL_TO_'$idx
   echo -e "rcpt to: $TO\r"
   idx=`/usr/bin/expr $idx + 1`
   done
   
echo -e "data\r"
echo -e "date: $DATE\r"
echo -e "from: $SNDMAIL_FM\r"
echo -e "to: $SNDMAIL_FM\r"

   idx=1
   while [ "$idx" -le "$SNDMAIL_TO_N" ]
   do
   eval TO='$SNDMAIL_TO_'$idx
   echo -e "to: $TO\r"
   idx=`/usr/bin/expr $idx + 1`
   done

) > /tmp/smtp.cmd


#------------------------------------------------------------------------------
# wenn befehl = -syslog, dann mail syslog
#------------------------------------------------------------------------------

if [ "$CMD" = "-syslog" ]
   then
     (
   echo -e "subject: System Log vom $DATE\r"
   cat $SNDMAIL_SYSLOGD_PATH
   )  >> /tmp/smtp.cmd

   else

#------------------------------------------------------------------------------
# wenn befehl = -newip, dann mail ip
# aktuelle ip ermitteln
#------------------------------------------------------------------------------


if [ "$CMD" = "-newip" ]
   then
       if [ "$2" = "" ]                                            # wenn nicht von ip-up aufgerufen
          then IP=`ifconfig | grep P-t-P | cut -d : -f 2`          # dann ip durch ifconfig ermitteln
          else IP=$2                                               # ansonsten die ip von ip-up uebernehemen
       fi
   (
        if [ "$SNDMAIL_IP_SUBJECT" = "" ]
           then echo -e "subject: $IP\r"
           else
               echo -e "subject: $SNDMAIL_IP_SUBJECT\r"
               echo -e "\r"
		if [ "$SNDMAIL_IP_TEXT" = "" ]
                  then
                  else echo -e "$SNDMAIL_IP_TEXT\r"
               fi
        echo $IP
        fi
   ) >> /tmp/smtp.cmd

   else

#------------------------------------------------------------------------------
# wenn befehl = -call dann mail call
#------------------------------------------------------------------------------

if [ "$CMD" = "-call" ]
   then
   D=$2   # datum
   T=$3   # zeit
   P=$4   # anruf von
   M=$5   # anruf an

   if [ "$SNDMAIL_CALL_PHONEBOOK" = "yes" ]
      then PB=`grep  $P /etc/phonebook | cut -d = -f 2`
      if [ "$PB" = "" ]
         then
         else P=$PB
      fi
   fi

   (
   if [ "$SNDMAIL_CALL_SUBJECT" = "" ]
      then echo -e "subject: $D $T $P $M\r"

      else
      echo -e "subject: $SNDMAIL_CALL_SUBJECT\r"
      echo -e "\r"
      if [ "$SNDMAIL_CALL_TEXT" = "" ]
         then
         else echo -e "$SNDMAIL_CALL_TEXT\r"
      fi
      echo -e "$D $T $P $M\r"
   fi
   ) >> /tmp/smtp.cmd

#------------------------------------------------------------------------------
# wenn nichts von beiden, dann mach ich auch nix! :-)
#------------------------------------------------------------------------------
   else
   echo "falscher parameter-aufruf!!!"
   exit 0
	
   fi
   fi
   fi
   fi

#------------------------------------------------------------------------------
# smtp.cmd abschliessen
#------------------------------------------------------------------------------

echo -e "\r\n.\r\nquit\r\nquit\r\nquit\r" >> /tmp/smtp.cmd

#------------------------------------------------------------------------------
# email versenden
#------------------------------------------------------------------------------

if [ "$SND_WAIT_SERVER_RESP" = "" ]
  	then
  	/usr/local/bin/netcat $SNDMAIL_SMTP $SNDMAIL_SPORT < /tmp/smtp.cmd
  	else
  	#
  	# netcat -i secs delay interval for lines sent, ports scanned
  	# steht default auf 1 sec. dh. das bertragen einer line dauert 1 sec!!
  	# im test bei einer faxseite 45 min. ;-((
  	# ohne -i gehts bei mir ratz fatz. sollten prob. mit dem versend auftreten
  	# den schalter -i aktivieren.
        # /usr/local/bin/netcat -w 30 -i $FAXMAIL_WAIT_SERVER_RESP $FAXMAIL_SMTP $FAXMAIL_SPORT < $FAXMAIL_CMD_PATH/smtp$TS.cmd
  	/usr/local/bin/netcat -w 30 $SNDMAIL_SMTP $SNDMAIL_SPORT < /tmp/smtp.cmd
  	
fi

#------------------------------------------------------------------------------
# syslogdatei lschen
#------------------------------------------------------------------------------

if [ "$CMD" = "-syslog" ]
   then
   echo "" > $SNDMAIL_SYSLOGD_PATH

fi

#------------------------------------------------------------------------------
# smtp.cmd lschen.
#------------------------------------------------------------------------------

#rm /tmp/smtp.cmd

#------------------------------------------------------------------------------
# ende
#------------------------------------------------------------------------------

#exit 0
