#----------------------------------------------------------------------------
# /usr/local/bin/dyneisfair.sh - fli4l dns registration (and refresh)
#
# Creation:     21.08.2002  fm
# Last Update:  $Id: dyneisfair.sh,v 1.1.2.1 2003/02/09 12:11:44 fm Exp $
#----------------------------------------------------------------------------
interface=$1				    # from /etc/ppp/ip-up.dyneisfair
					    # may be empty
if [ "$interface" = "off" ]
then
    interface=
    cmd=unset
else
    cmd=set
fi

. /var/run/dyneisfair.cfg

server1=dns.eisfair.net
server2=213.133.99.69
port=5005

circuit_valid='false'

if [ "$interface" != "" ]
then
    for j in $dyneisfair_circuits
    do
	file=/var/run/circuit-$j	    # created by etc/rc.d/circuits

	if [ -f $file ]
	then
	    dev=`cat $file`

	    if [ "$dev" = "$interface" ]
	    then			    # created by etc/rc.d/rc.time
		circuit_valid='true'
		break
	    fi
	fi
    done
else
    circuit_valid='true'
fi

if [ "$circuit_valid" = "true" ]
then
    i=1
    while [ $i -le $dyneisfair_domain_n ]
    do
	eval domain='$dyneisfair_domain_'$i
	eval pass='$dyneisfair_password_'$i

	rtc=0

	if [ "$interface" != "" ]
	then
	    sleep 10   # give ens a chance to change forwarders
	fi

	for k in 1 2 3 4 5
	do
	    answer=`echo $cmd $domain $pass | /usr/local/bin/netcat -w 15 $server1 $port`
	    rtc=$?

	    if [ $rtc = 0 ]
	    then
		break
	    fi
	    echo "error occured, retrying in 10 seconds..."
	    sleep 10
	done

	if [ $rtc != 0 ]
	then
	    answer=`echo $cmd $domain $pass | /usr/local/bin/netcat -w 15 $server2 $port`
	    rtc=$?
	fi

	if [ $rtc = 0 ]
	then
	    if [ "$answer" = "" ]
	    then
		answer="got no answer from registration server"
	    fi

	    echo $answer
	else
	    echo "dyneisfair: connect error" >&2
	fi

	i=`expr $i + 1`
    done
fi
