@echo off
rem mkcd_old.bat 
rem bootCD v.0.4 package for fli4l 2.0.4
rem author: Art Pogoda <a.pogoda@web.de>

if "%1" == "-?" goto usage
if "%1" == "/?" goto usage
if "%1" == "-h" goto usage
if "%1" == "/h" goto usage

if "%1" == "-s" goto withsss
if "%1" == "/s" goto withsss
if "%1" == "-l" goto withlarge
if "%1" == "/l" goto withlarge
set confdir=%1
goto continue

:withsss
set sss=1
if "%2" == "-l" goto withssllarge
if "%2" == "/l" goto withssllarge
set confdir=%2
goto continue

:withlarge
set large=1
if "%2" == "-s" goto withlargesss
if "%2" == "/s" goto withlargesss
set confdir=%2

:withssllarge
set large=1
set confdir=%3
goto continue

:withlargesss
set sss=1
set confdir=%3
goto continue

:continue
if "%confdir%" == "" set confdir=config
echo calling mkfli4l %confdir%
windows\mkfli4l %confdir%
if errorlevel 1 goto fli4lerr


cd opt
if exist ..\img\opt.tgz del ..\img\opt.tgz
if exist ..\img\opt.tar del ..\img\opt.tar
..\windows\tar -c -v -T opt.tmp -f ..\img\opt.tar
..\windows\gzip -9 ..\img\opt.tar
move ..\img\opt.tar.gz ..\img\opt.tgz
del opt.tmp

copy etc\rc.cfg ..\img

cd ..
cd img

echo.
echo ---------------------------------------------------------------------------
echo.
echo If an error occured, press CTRL-C to cancel.
echo If all is ok, insert a fresh, formatted 1.44MB floppy and press ENTER.
echo.
echo.
echo.
echo Falls ein Fehler auftrat, bitte STRG-C drcken um abzubrechen.
echo Ansonsten bitte eine formatierte 1,44MB Diskette einlegen und
echo die Eingabetaste drcken.
echo.
@pause
cls

echo writing system files / schreibe Systemdateien...
if     "%sss%" == "1" ..\windows\syslinux -s a:
if not "%sss%" == "1" ..\windows\syslinux    a:
if errorlevel 1 goto diskerr

echo copying / kopiere syslinux.cfg ...
copy /b syslinuxcd.cfg a:\SYSLINUX.CFG
if errorlevel 1 goto diskerr

echo copying / kopiere kernel ...
copy /b kernel a:\KERNEL

echo copying / kopiere rootfs.gz ...
if     "%large%" == "1" copy /b rootfscd32.gz a:\ROOTFS.GZ
if not "%large%" == "1" copy /b rootfscd.gz   a:\ROOTFS.GZ

echo.
echo.
echo creating floppy disk boot image / erstelle Diskettenabbild ...
if not exist cd\. mkdir cd
rem delete boot.img if it exists due to a former run
rem thanks to juergen edner for this
if exist cd\BOOT.IMG attrib -r cd\BOOT.IMG
if exist cd\BOOT.IMG del cd\BOOT.IMG
..\windows\rawread cd\BOOT.IMG A:
if errorlevel 1 goto diskerr

echo copying kernel to cd image / kopiere Kernel ins CD Abbild...
copy /b kernel cd

echo copying rootfs to cd image / kopiere rootfs ins CD Abbild ...
copy /b rootfscd.gz cd\rootfs.gz

echo copying rc.cfg to cd image / kopiere rc.cfg ins CD Abbild ...
copy /b rc.cfg cd

echo copying opt.tgz to cd image / kopiere opt.tgz ins CD Abbild...
copy /b opt.tgz cd

echo creating cd iso image in/ erstelle CD ISO Abbild in  img\fli4l.iso
cd cd
..\..\windows\mkisofs.exe -o ..\fli4l.iso -pad -J -r -b BOOT.IMG -c boot.cat .
if errorlevel 1 goto isoerr
goto noisoerr

:isoerr
cd ..\..
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR creating iso image - maybe harddisk full ?
echo.
echo.
echo.
echo FEHLER beim Erzeugen des CD Abbildes - u.U. Festplatte voll ?
echo.
pause
goto end

:noisoerr
cd ..\..


echo.
echo.
echo ---------------------------------------------------------------------------
echo.
echo CD iso image has been created in img\fli4l.iso
echo You can now use CDRECORD to write this file to a blank CD...
echo.
echo.
echo.
echo CD Abbild erzeugt in img\fli4l.iso.
echo Zum Brennen dieses Abbildes auf CD kann nun im folgenden CDRECORD
echo benutzt werden.
echo.
@pause

cls
echo ---------------------------------------------------------------------------
echo.
windows\cdrecord -scanbus
if errorlevel 1 goto cdrerror
echo.
echo ---------------------------------------------------------------------------
echo.
echo Above you'll see which drives CDRECORD detected in your system.
echo.
echo Please enter the three digit denominatior of your cd recorder,
echo e.g. "0,0,0"
echo.
echo.
echo.
echo Obige Liste zeigt alle gefundenen CD Laufwerke im System.
echo Bitte den dreistelligen Zifferncode des zu verwendenden Brenners
echo eingeben, z.B. "0,0,0" 
echo.

:inputloop
windows\getvar.exe -v CDID -f img\setcdid.bat -l 5 -p "CD-DRIVE: "
if errorlevel 3 goto inperror
if errorlevel 2 goto askend
if errorlevel 1 goto end
call img\setcdid.bat
del  img\setcdid.bat
goto continue

:askend
echo You did not enter anything - do you want to abort ?
echo.
echo.
echo.
echo Es wurde nichts eingegeben - abbrechen ?
echo.
windows\getvar.exe -u -v YJN -f img\setyn.bat -l 1 -p "(Y/J/N): "
if errorlevel 3 goto inperror
if errorlevel 2 goto askend
if errorlevel 1 goto end
call img\setyn.bat
del  img\setyn.bat
if "%YN%"  == "Y" goto end
if "%YN%"  == "J" goto end
if "%YN%"  == "N" goto inputloop


:continue
windows\cdrecord dev=%CDID% -eject
cls
echo Please enter a blank CD medium into your drive ...
echo.
echo The CD image will be written to this drive in single speed.
echo There will be a simulation before real write.
echo.
echo If you don't like this, press Ctrl-C and burn the image yourself.
echo Otherwise press any key to continue...
echo.
echo.
echo.
echo Bitte nun ein leeres-CD Medium in das gewhlte Laufwerk einlegen ...
echo.
echo Die CD wird mit einfacher Geschwindigkeit geschrieben.
echo Vorher wird aus Sicherheitsgrnden eine Brenn-Simulation durchgefhrt.
echo.
echo Zum Abbrechen bitte STRG-C drcken.
echo Andernfalls eine beliebige Taste drcken um die Simulation zu starten...
echo.
@pause

windows\cdrecord dev=%CDID% speed=1 -v -dummy -data img\fli4l.iso
if errorlevel 1 goto fail1


echo.
echo ---------------------------------------------------------------------------
echo Write simulation was successfull, do you now want to write the CD?
echo.
echo WARNING: the CD in drive %CDID% will be now REALLY written ...
echo.
echo.
echo.
echo Die Simulation scheint erfolgreich gewesen zu sein, soll die CD nun
echo wirklich gebrannt werden ?
echo.
echo ACHTUNG: die CD im Laufwerk %CDID% wird nun TATSCHLICH geschrieben ...
echo 
echo.
set YN=
windows\getvar.exe -u -v YJN -f img\setyn.bat -l 1 -p "(Y/J/N): "
if errorlevel 1 goto abort
call img\setyn.bat
del  img\setyn.bat
if "%YN%" == "N" goto abort


windows\cdrecord dev=%CDID% speed=1 -v -eject -data img\fli4l.iso
if errorlevel 1 goto fail2

echo.
echo CD written successfully ...
echo Thanks for using mkcd.bat !
echo.
echo.
echo.
echo CD wurde erfolgreich geschrieben ...
echo Vielen Dank fr die Benutzung von mkcd.bat !
echo.
pause
goto end



:abort
echo.
echo CD writing aborted ...
echo.
echo.
echo.
echo Schreiben der CD wurde abgebrochen ...
echo.
pause
goto end


:fail1
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR simulating CD write - make sure it's empty and you specified
echo the correct CD drive ...
echo.
echo.
echo.
echo FEHLER bei der Simulation - ist die CD wirklich leer und wurde das
echo korrekte Laufwerk gewhlt ?
echo.
pause
goto end


:fail2
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR writing CD - make sure the CD is empty and you specified
echo the correct CD drive r...
echo.
echo.
echo.
echo FEHLER beim Schreiben der CD - ist die CD wirklich leer und wurde das
echo korrekte Laufwerk gewhlt ?
echo.
pause
goto end


:cdrerror
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR accessing CD drives, is your drive supported by CDRECORD ? 
echo aborted ...
echo.
echo.
echo.
echo FEHLER beim Laufwerkszugriff, wird das Laufwerk von CDRECORD untersttzt ?
echo Abbruch ...
echo.
pause
goto end


:inperror
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR processing user input, aborted ..."
echo.
echo.
echo.
echo FEHLER bei der Verarbeitung der Eingabe, Abbruch ...
echo.
pause
goto endwithcd


:diskerr
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR writing or reading the floppy disk.
echo.
echo maybe the disk is full - try to select fewer options in configuration
echo and try again ...
echo.
echo.
echo.
echo FEHLER beim Schreiben oder Lesen der Diskette.
echo.
echo vielleicht ist die Diskette voll - u.U. hilft es, weniger Optionen
echo in den Konfigurationsdateien einzuschalten ...
echo.
pause
goto endwithcd

:fli4lerr
echo.
echo ---------------------------------------------------------------------------
echo.
echo ERROR creating your configuration ...
echo.
echo.
echo.
echo FEHLER bei der Erstellung der Konfiguration ...
echo.
pause
goto end

:usage
echo.
echo usage: mkcd [-h] [-s] [-l] [config-directory]
echo.
echo -h    print out this lot
echo -s    use slow, secure and stupid mode with syslinux
echo -l    use large 32MB root filesystem for large configurations
echo.
echo.
echo Aufruf: mkcd [-h] [-s] [-l] [config-Verzeichnis]
echo.
echo -h    gibt diese Hilfe aus
echo -s    installiere syslinux im dummen, aber sicheren Boot-Modus
echo -l    benutze das grosse 32MB rootfs fr umfangreiche Konfigurationen
echo.
goto end

:endwithcd
cd ..
:end

