#!/bin/sh
#------------------------------------------------------------------------------
# firewall.cgi - shows packet log entries from the syslog-file
#
# Written and Copyright 2002 Reiner Schroeppel
# You may freely use and distribute this code free of charge provided that
# this copyright notice remains.                    reiner@schroeppel.info
#
# Creation:     09.02.2002  (c) by Reiner Schroeppel  
# 
#------------------------------------------------------------------------------

VAR_LOGDIR="/var/log"

myname=`basename $0`

if [ -f firewall.set ]; then
  while read a
  do
    set -- $a
    VAR_ENTRIES=$1
    VAR_REFRESH=$2
    VAR_ORDER=$3
  done < firewall.set
fi

if [ "$VAR_ENTRIES" = "" -o "$VAR_REFRESH" = "" -o "$VAR_ORDER" = "" ]; then
  VAR_ENTRIES=all
  VAR_REFRESH=10
  VAR_ORDER=down
fi


# Find SYSLOG file from syslog.conf
set -f
FORM_target='*.*'
while read a
do
  set -- $a
  if [ "$FORM_target" = "$1" -a -f "$2" ]
  then
     VAR_LOG=$2
  fi
done < /etc/syslog.conf
set +f

if [ ! -f $VAR_LOG ]; then
  echo "Content-Type: text/html; charset=iso-8859-1"
  echo "Cache-control: no-store"
  echo "Pragma: no-cache"
  echo "Expires: `date -Ru`"
  echo
  echo "<html><head>"
  echo "<title>Firewall-Log</title>"
  echo "</head><body bgcolor=\"#FFFFFF\">"
  echo "<p>No Syslog-File found at specified location: $VAR_LOG</p>"
  echo "<p>Please check path- and filename /etc/syslog.conf</p>"
  echo "</body></html>"
  exit 1
fi

if [ ! -d "$VAR_LOGDIR" ]; then
  echo "Content-Type: text/html; charset=iso-8859-1"
  echo "Cache-control: no-store"
  echo "Pragma: no-cache"
  echo "Expires: `date -Ru`"
  echo
  echo "<html><head>"
  echo "<title>Firewall-Log</title>"
  echo "</head><body bgcolor=\"#FFFFFF\">"
  echo "<p><b>Can't find default directory for system messages /var/log!</p>"
  echo "</body></html>"
  exit 1
fi

#Anzahl Zeilen in der SYSLOG-Datei
VAR_OLDLINES=0
VAR_NEWLINES=1
# Falls schon einmal die Anzahl der SYSLOG-Zeilen ermittelt
if [ -f /tmp/LINES ]; then
  VAR_OLDLINES=`cat /tmp/LINES`
  grep -c "" $VAR_LOG > /tmp/LINES
  VAR_AKTLINES=`cat /tmp/LINES`
  VAR_NEWLINES=`expr $VAR_AKTLINES - $VAR_OLDLINES`

  # Nur die neuen Zeilen bearbeiten
  tail -n $VAR_NEWLINES $VAR_LOG > /tmp/deny.mes
  grep "Packet log" /tmp/deny.mes | sed -e 's/  / /g' > /tmp/deny.1
  rm /tmp/deny.mes
else #Falls der erste Aufruf
  grep -c "" $VAR_LOG > /tmp/LINES

  #Alle Verstoesse ermitteln
  grep "Packet log" $VAR_LOG | sed -e 's/  / /g' > /tmp/deny.1
fi

# Falls Eintraege in der SYSLOG-Datei vohanden
# oder dazugekommen sind
if [ $VAR_NEWLINES -gt 0 ]; then
  
  # Anzahl der neu geloggten Verstoesse
  VAR_COUNT=`grep -c "" /tmp/deny.1`

  # Wenn Verstoesse dazu gekommen sind, diese bearbeiten
  if [ $VAR_COUNT -gt 0 ]; then

    while read a
      do
      set -- $a
      VAR_MONTH=$1
      VAR_DAY=$2
      VAR_TIME=$3
      shift 10
      VAR_PROTO=$1
      VAR_SOURCE=`echo $2 | sed -e 's/:/<\/td><td align=center>/'`
      VAR_DEST=`echo $3 | sed -e 's/:/<\/td><td align=center>/'`
      VAR_L=$4
      VAR_S=$5
      VAR_I=$6
      VAR_F=$7
      VAR_T=$8
      VAR_TYPE=$9
      echo "<tr><td align=center>$VAR_DAY. $VAR_MONTH. $VAR_TIME</td><td align=center>\
$VAR_PROTO</td><td align=center>$VAR_SOURCE</td><td align=center>$VAR_DEST</td>\
<td align=center>$VAR_L $VAR_S $VAR_I $VAR_F $VAR_T $VAR_TYPE</td></tr>"
    done < /tmp/deny.1 >> $VAR_LOGDIR/deny.out
  fi
fi

# Anzahl der geloggten Verstoesse
if [ -f $VAR_LOGDIR/deny.out ]; then
  VAR_COUNT=`grep -c "." $VAR_LOGDIR/deny.out`
else
  VAR_COUNT=0
fi

# HTML-Header
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store"
echo "Pragma: no-cache"
echo "Expires: `date -Ru`"
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">"
if [ "$QUERY_STRING" != "Stop" ]; then
  echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$VAR_REFRESH\">"
fi
echo "<title>Firewall-Log</title>"
echo "</head><body bgcolor=\"#FFFFFF\">"
echo "<h1>Firewall-Log</h1>"

# Start/Stop Option
if [ "$QUERY_STRING" = "Stop" ]; then
  echo "<p><a href=\"$myname?Start\">Start</a> refreshing"
else
  echo "<p><a href=\"$myname?Stop\">Stop</a> refreshing"
fi

if [ $VAR_COUNT -gt 0 ]; then
  # Ausgabe der Tabellen-Ueberschrift
  echo "<p>The firewall has logged <b>$VAR_COUNT</b> events:</p>"
  echo "<p></p>"
  echo "<table border>"
  echo "<tr><th>Date</th><th>PROTO</th><th>Source IP</th><th>Source Port</th><th>Destination   IP</th><th>Destination Port</th><th>Details</th></tr>"

  if [ $VAR_ENTRIES != "all" ]; then
    if [ "$VAR_ORDER" = "up" ]; then
      tail -n $VAR_ENTRIES $VAR_LOGDIR/deny.out
    else
      tail -n $VAR_ENTRIES $VAR_LOGDIR/deny.out > /tmp/deny.rev
      rcat /tmp/deny.rev
      rm /tmp/deny.rev
    fi
  else
    if [ "$VAR_ORDER" = "up" ]; then
      cat $VAR_LOGDIR/deny.out
    else
      rcat $VAR_LOGDIR/deny.out
    fi  
  fi

  echo "</table>"
else
  echo "<p>No attacks were logged!</p>"
  echo "<p></p>"
  echo "<p>But don't feel to save, they will find you!</p>"
fi

echo "</body></html>"
if [ -f /tmp/deny.1 ]; then
  rm /tmp/deny.1
fi

exit 0
