#!/bin/sh
#----------------------------------------------------------------------
# /usr/local/htdocs/main_trafficmon.cgi				v0.5X
# Creation:     2002.08.21  bue
# Last Update:  2002.10.16  bue
#----------------------------------------------------------------------

#######################################################################
# parse variables...
#######################################################################
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
 if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
 eval "param_$var"
done

if [ "$param_action" = "reset" ]
then
/usr/local/bin/trafficmon_backup.sh reset
fi

if [ "$param_action" = "backup" ]
then
/usr/local/bin/trafficmon_backup.sh
fi

if [ "$param_action" = "refresh" ]
then
/usr/local/bin/trafficmon.sh
fi

#######################################################################
# other variables (from config-file)
#######################################################################
VERSION='v0.5X'
REFRESH=300
#eventuell in config datei eingeben

SETUP=`basename $0`
#'main_trafficmon.cgi'
#HOST=`dirname $0`

DATAPATH=`cat /etc/rc.cfg | grep "TRAFFICMON_DATAPATH" | sed "s/TRAFFICMON_DATAPATH='//
                                                              s/'//"`
LIMIT=`cat /etc/rc.cfg | grep "TRAFFICMON_LIMIT" | sed "s/TRAFFICMON_LIMIT='//
                                                        s/'//"`
TRAFFICMON_DEVICE=`cat /etc/rc.cfg | grep "TRAFFICMON_DEVICE" | sed "s/TRAFFICMON_DEVICE='//
                                                                     s/'//"`
#only for debug
#LIMIT='10000'

SAVEIN=`cat $DATAPATH | grep "SAVEIN" | sed "s/SAVEIN='//
                                             s/'//"`
SAVEOUT=`cat $DATAPATH | grep "SAVEOUT" | sed "s/SAVEOUT='//
                                               s/'//"`
TRAFFIC=`expr $SAVEIN + $SAVEOUT`

LAST_RESET=`cat $DATAPATH | grep "LAST_RESET" | sed "s/LAST_RESET='//
                                                     s/'//"`
NEXT_RESET=`cat $DATAPATH | grep "NEXT_RESET" | sed "s/NEXT_RESET='//
                                                     s/'//"`
UPTIME=$(cat /proc/uptime | sed 's/ .*//')

#######################################################################
# Print content-information  of the main-page
#######################################################################
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store"
echo "Pragma: no-cache"
echo "Expires: `date -Ru`"
echo ""

#######################################################################
# Print html-header of the main-page and body-open tag
#######################################################################
echo -e "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
  <head>
    <title>OPT_TRAFFICMON_$VERSION Web-Interface</title>
    <meta http-equiv='Refresh' CONTENT=\"$REFRESH;url=./$SETUP\">
    <meta http-equiv='expires' content='0'>
    <meta http-equiv='content-type' content='text/html; charset=ISO-8859-1'>
    <meta name='author' content='Martin B&uuml;rbaum'>
    <meta name='description' content='OPT_TRAFFICMON_$VERSION Web-Interface'>
  </head>
  <body>"

#######################################################################
# Print overview of trafficmon-data
#######################################################################
echo -e "<table cellpadding='2' cellspacing='2' border='1' width='100%'>
    <tr align='center' bgcolor='#DDDD00'>
      <td valign='top' rowspan='1' colspan='2'><b>OPT_TRAFFICMON_$VERSION </b></td>
    </tr>
    <tr align='center'>
      <td valign='top' rowspan='1' colspan='2'><a href='./$SETUP'>[REFRESH SITE]</a><br>
(This is automatically done every <b>$REFRESH</b> seconds.)
      </td>
    </tr>
    <tr>
      <td valign='top' width='170'>NETWORK DEVICE</td>
      <td valign='top'>$TRAFFICMON_DEVICE </td>
    </tr>
    <tr bgcolor='#00CCFF'>
      <td valign='top' width='170'>TRAFFIC UP</td>
      <td valign='top'>$SAVEOUT MB (Traffic since last RESET)</td>
    </tr>
    <tr bgcolor='#00CCFF'>
      <td valign='top' width='170'>TRAFFIC DOWN</td>
      <td valign='top'>$SAVEIN MB (Traffic since last RESET)</td>
    </tr>
    <tr bgcolor='#0099DD'>
      <td valign='top' width='170'><b>TRAFFIC TOTAL</b></td>
      <td valign='top'><b>$TRAFFIC MB</b> (Traffic since last RESET)</td>
    </tr>
    <tr>
      <td valign='top' width='170'>Last Reset</td>
      <td valign='top'>$LAST_RESET </td>
    </tr>
    <tr>
      <td valign='top' width='170'>Next Reset in</td>
      <td valign='top'>$NEXT_RESET </td>
    </tr>
    <tr>
      <td valign='top' width='170'>TRAFFIC since last reboot</td>
      <td valign='top'>$(/sbin/ifconfig $TRAFFICMON_DEVICE | grep 'RX bytes' | sed 's/ *//')</td>
    </tr>
    <tr>
      <td valign='top' width='170'>UPTIME since last reboot</td>
      <td valign='top'>$UPTIME sec ~ $(expr $UPTIME / 60) min ~ <b>$(expr $UPTIME / 60 / 60) hours</b></td>
    </tr>
</table>"

#######################################################################
# Print data of trafficlimit
#######################################################################
echo -e "<br><br>
<table cellpadding='2' cellspacing='2' border='1' width='100%'>
   <tr align='center'>
      <td colspan='2' rowspan='1' valign='top'>
        Trafficlimit is set to <b>$LIMIT MB</b>.
      </td>
    </tr>
    <tr>"

if [ "$LIMIT" != "0" ]
then
  if [ "$TRAFFIC" -ge "$LIMIT" ]
  then
    echo -e "<td valign='top' bgcolor='#ff0000' align='center'>YOU ARE HAVE REACHED/OVERDRAWN YOUR TRAFFICLIMIT($LIMIT MB) WITH $TRAFFIC MB.</td>"
  else
    RED=`expr 100 \* $TRAFFIC / $LIMIT`
    GREEN=`expr 100 - $RED`
    echo -e "<td valign='top' width='$RED %' bgcolor='#ff0000' align='right'>$RED %</td>
             <td valign='top' bgcolor='#00ff00' align='left'>$GREEN %</td>"
  fi
fi
echo -e "</tr></table>"

#######################################################################
# Print backup/reset/refresh buttons
#######################################################################
echo -e "<br><br>
<table width='100%' border='0' cellspacing='2' cellpadding='2'>
    <tr>
      <td width='33%' valign='top'><a href='./$SETUP?action=refresh'>[Update Data]</a><br></td>
      <td valign='top' width='33%' align='center'><a href='./$SETUP?action=backup'>[Backup Log]</a><br></td>
      <td valign='top' width='33%' align='right'><a href='./$SETUP?action=reset'>[Reset Log]</a></td>
    </tr>
</table>
<br>"
#<div align='right'><b>Use the [Reset Log] function with care!</b></div>

#print body and html-close tags
echo "</body> </html>"
