#!/bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/trafficmon_backup.sh					v0.5X
#
# Creation:     2002.08.11  bue
# Last Update:  2002.09.01  bue
#------------------------------------------------------------------------------


### BEGIN get the variables from config-file
TRAFFICMON_DATAPATH=$(grep "TRAFFICMON_DATAPATH" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_BACKUP=$(grep "TRAFFICMON_BACKUP=" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_BACKUPDIR=$(grep "TRAFFICMON_BACKUPDIR" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_RESET=$(grep "TRAFFICMON_RESET" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_DEVICE=$(grep "TRAFFICMON_DEVICE" /etc/rc.cfg | cut -d"'" -f2)
### END

### BEGIN get number of parameters
PARAM=$(echo -e "$#")
### END

### BEGIN get date
DATE=$(date +%Y%m%d)
TIME=$(date +%H%M%S)
### END


### BEGIN get filename of logfile
LOGFILENAME=$(basename $TRAFFICMON_DATAPATH)
### END

### BEGIN save Logfile with date in the filename to the backup-dir
if [ "$PARAM" -ne "" ]
then 
  # reset-Marke mit Uhrzeit anhaengen  
  RESET=$(echo -e "_reset@$TIME")
  # remove the old RESET entries
  echo -e "$(grep -v "RESET" $TRAFFICMON_DATAPATH)" > $TRAFFICMON_DATAPATH
  # insert last reset comment
  echo -e "LAST_RESET='$DATE $TIME'" >> $TRAFFICMON_DATAPATH
  #### BEGIN insert next reset (in days) comment ##################
  MONTH=$(date +%m)
  DAYOFMONTH=$(date +%d)
  # (The following function is also used in trafficmon.sh)
  if [ "$MONTH" = "01" -o "$MONTH" = "03" -o "$MONTH" = "05" -o \
       "$MONTH" = "07" -o "$MONTH" = "08" -o "$MONTH" = "10" -o \
       "$MONTH" = "12" ]
  then
    DAYS_LEFT=$( expr 31 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  if [ "$MONTH" = "04" -o "$MONTH" = "06" -o "$MONTH" = "09" -o "$MONTH" = "11" ]
  then
    DAYS_LEFT=$( expr 30 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  if [ "$MONTH" = "02" ]
  then
    DAYS_LEFT=$( expr 28 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  echo -e "NEXT_RESET='$DAYS_LEFT DAYS'" >> $TRAFFICMON_DATAPATH
  #### END insert next reset (in days) comment ###################
else
  RESET=''
fi

if [ "$TRAFFICMON_BACKUP" = yes ]
then
  BLANK='_'
  cp $TRAFFICMON_DATAPATH $(echo -e "$TRAFFICMON_BACKUPDIR/$LOGFILENAME$BLANK$DATE$RESET")
fi
### END save Logfile ...

### BEGIN reset Logfile
if [ "$PARAM" -ne "" ]
then 
  # write existing traffic to extra file
  ### BEGIN get traffic from device (this function is also used in trafficmon.sh) ######
  TRAFFIC=$(/sbin/ifconfig $TRAFFICMON_DEVICE | grep "RX bytes")

  UNIT_IN=$(echo $TRAFFIC | sed 's/.*RX [^ ]* [^ ]* //' | sed 's/).*//')
  if [ "$UNIT_IN" = "Mb" ]
  then  
    TRAFFICIN=$(echo $TRAFFIC | cut -d"(" -f2 | cut -d" " -f1)
  else
    TRAFFICIN='0'
  fi

  UNIT_OUT=$(echo $TRAFFIC | sed 's/.*TX [^ ]* [^ ]* //' | sed 's/).*//')
  if [ "$UNIT_OUT" = "Mb" ]
  then
    TRAFFICOUT=$(echo $TRAFFIC | cut -d"(" -f3 | cut -d" " -f1)
  else
    TRAFFICOUT='0'
  fi
  ### END ###########################################
  echo -e "SAVEIN='$TRAFFICIN'\nSAVEOUT='$TRAFFICOUT'" > /var/tmp/trafficmon.reset
  # reset logfile
  DATA=$(grep -v "SAVE" $TRAFFICMON_DATAPATH)
  echo -e "SAVEIN='0'\nSAVEOUT='0'" > $TRAFFICMON_DATAPATH
  echo -e "$DATA" >> $TRAFFICMON_DATAPATH
  echo -e "SAVEIN='0'\nSAVEOUT='0'" > /var/tmp/trafficmon.log
fi
### END
