#!/bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/trafficmon.sh						v0.5X
#
# Creation:     2001.02.28  dr
# Last Update:  2002.09.01  bue
#------------------------------------------------------------------------------


### BEGIN get the variables from config-file
TRAFFICMON_DEVICE=$(grep "TRAFFICMON_DEVICE" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_DATAPATH=$(grep "TRAFFICMON_DATAPATH" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_LCD=$(grep "TRAFFICMON_LCD" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_FILE_DOWN=$(grep "TRAFFICMON_FILE_DOWN" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_FILE_UP=$(grep "TRAFFICMON_FILE_UP" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_RESET=$(grep "TRAFFICMON_RESET" /etc/rc.cfg | cut -d"'" -f2)
### END

### BEGIN get the traffic-variables from log-file
SAVEIN='0'
SAVEOUT='0'
if [ -f /var/tmp/trafficmon.log ]
then
  ### Die Log-Datei existiert
  SAVEIN=$(grep "SAVEIN" /var/tmp/trafficmon.log | cut -d"'" -f2)
  SAVEOUT=$(grep "SAVEOUT" /var/tmp/trafficmon.log | cut -d"'" -f2)
fi
### END

### BEGIN get the traffic-variables from reset-file
RESET_IN='0'
RESET_OUT='0'
if [ -f /var/tmp/trafficmon.reset ]
then
  ### Die Reset-Datei existiert => reset gemacht seit letztem reboot
  RESET_IN=$(grep "SAVEIN" /var/tmp/trafficmon.reset | cut -d"'" -f2)
  RESET_OUT=$(grep "SAVEOUT" /var/tmp/trafficmon.reset | cut -d"'" -f2)
fi
### END


### BEGIN get traffic from device (this function is also used in trafficmon_backup.sh)
TRAFFIC=$(/sbin/ifconfig $TRAFFICMON_DEVICE | grep "RX bytes")

UNIT_IN=$(echo $TRAFFIC | sed 's/.*RX [^ ]* [^ ]* //' | sed 's/).*//')
if [ "$UNIT_IN" = "Mb" ]
then  
  TRAFFICIN=$(echo $TRAFFIC | cut -d"(" -f2 | cut -d" " -f1)
else
  TRAFFICIN='0'
fi

UNIT_OUT=$(echo $TRAFFIC | sed 's/.*TX [^ ]* [^ ]* //' | sed 's/).*//')
if [ "$UNIT_OUT" = "Mb" ]
then
  TRAFFICOUT=$(echo $TRAFFIC | cut -d"(" -f3 | cut -d" " -f1)
else
  TRAFFICOUT='0'
fi
### END

### BEGIN calculate new traffic
IN=`expr $SAVEIN + $TRAFFICIN - $RESET_IN`
OUT=`expr $SAVEOUT + $TRAFFICOUT - $RESET_OUT`
### END

### BEGIN get other infos (like reset, ...)
DATA=$(grep -v "SAVE" $TRAFFICMON_DATAPATH)
DATA=$(echo -e "$DATA" | grep -v "NEXT_RESET")
### END

### BEGIN write log-file
echo -e "SAVEIN='$IN'\nSAVEOUT='$OUT'" > $TRAFFICMON_DATAPATH
### END


### BEGIN append other infos
echo -e "$DATA" >> $TRAFFICMON_DATAPATH
# insert next reset (in days) comment
MONTH=$(date +%m)
DAYOFMONTH=$(date +%d)
# (The following function is also used in trafficmon_backup.sh)
  if [ "$MONTH" = "01" -o "$MONTH" = "03" -o "$MONTH" = "05" -o \
       "$MONTH" = "07" -o "$MONTH" = "08" -o "$MONTH" = "10" -o \
       "$MONTH" = "12" ]
  then
    DAYS_LEFT=$( expr 31 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  if [ "$MONTH" = "04" -o "$MONTH" = "06" -o "$MONTH" = "09" -o \
       "$MONTH" = "11" ]
  then
    DAYS_LEFT=$( expr 30 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  if [ "$MONTH" = "02" ]
  then
    DAYS_LEFT=$( expr 28 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  echo -e "NEXT_RESET='$DAYS_LEFT DAYS'" >> $TRAFFICMON_DATAPATH
### END

### BEGIN write LCD-files
if [ "$TRAFFICMON_LCD" = "yes" ]
then
  echo -e "$IN MB" > $TRAFFICMON_FILE_DOWN
  echo -e "$OUT MB" > $TRAFFICMON_FILE_UP
fi
### END