#! /bin/sh
#------------------------------------------------------------------------------
# Creates a new opt.tgz concerning to the configuration in config/
#
# $Id: mktgz.sh,v 1.1.1.1.2.3 2002/10/10 13:04:08 fm Exp $
#------------------------------------------------------------------------------


if [ "$1" != "" ]
then
    echo "using configuration directory $1 ..."
    config_dir=$1
else
    config_dir=config
fi

set -e						# exit on error

cd unix
make mkfli4l
cd ..

unix/mkfli4l $config_dir

echo "creating compressed tar archive..."
cd opt
rm -f ../img/opt.tgz ../img/opt.tar
sort opt.tmp | tar --owner=root --group=root -c -v -T - -f ../img/opt.tar
gzip -9 ../img/opt.tar
mv ../img/opt.tar.gz ../img/opt.tgz
rm -f opt.tmp

cp ./etc/rc.cfg ../img/rc.cfg
