/* ----------------------------------------------------------------------
   cimon - a UNIX command line client for the fli4l imon daemon.            

   Public domain, 2001-2002, Rene Herman <rene.herman@mail.com>         
---------------------------------------------------------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>

#include "cimon.h"

const char *program_name;

void exit_error(const char * const format, ...)
{
    va_list ap;

    fprintf(stderr, "%s: ", program_name);  
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);
    fputc('\n', stderr);
    exit(EXIT_FAILURE);  
}

void exit_errno(const char * const msg)
{
    exit_error("%s: %s", msg, strerror(errno));
}

void exit_usage (const char * const msg)
{
    if (msg)
        fprintf(stderr, "%s: %s\n", program_name, msg);
    fprintf(stderr, "Try `%s -h' for more information.\n", program_name);
    exit(EXIT_FAILURE);
}
