#! /bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/trafficmon.sh						v0.4X
#
# Creation:     2001.02.28  dr
# Last Update:  2002.08.21  bue
#------------------------------------------------------------------------------


### BEGIN get the variables from config-file
TRAFFICMON_DEVICE=$(grep "TRAFFICMON_DEVICE" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_DATAPATH=$(grep "TRAFFICMON_DATAPATH" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_LCD=$(grep "TRAFFICMON_LCD" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_FILE_DOWN=$(grep "TRAFFICMON_FILE_DOWN" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_FILE_UP=$(grep "TRAFFICMON_FILE_UP" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_UNIT=$(grep "TRAFFICMON_UNIT" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_RESET=$(grep "TRAFFICMON_RESET" /etc/rc.cfg | cut -d"'" -f2)
### END

### BEGIN get the traffic-variables from log-file
if [ -f /var/tmp/trafficmon.log ]
then ### Die Log-Datei existiert
  SAVEIN=$(grep "SAVEIN" /var/tmp/trafficmon.log | cut -d"'" -f2)
  SAVEOUT=$(grep "SAVEOUT" /var/tmp/trafficmon.log | cut -d"'" -f2)
else ### Die Log-Datei existiert nicht
  ###Log-Datei erzeugen und Nulldaten einfuegen.
  #echo -e "SAVEIN='0'\nSAVEOUT='0'" > /var/tmp/trafficmon.log
  SAVEIN='0'
  SAVEOUT='0'
fi

### END

### BEGIN get traffic from device
TRAFFIC=$(ifconfig $TRAFFICMON_DEVICE | grep "RX bytes")
TRAFFICIN=$(echo $TRAFFIC | cut -d":" -f2)
TRAFFICIN=$(echo $TRAFFICIN | cut -d" " -f1)
TRAFFICOUT=$(echo $TRAFFIC | cut -d":" -f3)
TRAFFICOUT=$(echo $TRAFFICOUT | cut -d" " -f1)
### END

### BEGIN calculate new traffic
IN=`expr $SAVEIN + $TRAFFICIN`
OUT=`expr $SAVEOUT + $TRAFFICOUT`
### END

### BEGIN get other infos (like reset, ...)
DATA=$(grep -v "SAVE" $TRAFFICMON_DATAPATH)
DATA=$(echo -e "$DATA" | grep -v "IN_")
DATA=$(echo -e "$DATA" | grep -v "OUT_")
DATA=$(echo -e "$DATA" | grep -v "NEXT_RESET")
### END

### BEGIN write log-file
echo -e "SAVEIN='$IN'\nSAVEOUT='$OUT'" > $TRAFFICMON_DATAPATH
### END


### BEGIN transform traffic into MB/KB
if [ "$TRAFFICMON_UNIT" = "MB" ]
then
  IN=`expr $IN / 1024 / 1024`
  OUT=`expr $OUT / 1024 / 1024`
  IN=$(echo -e "$IN$TRAFFICMON_UNIT")
  OUT=$(echo -e "$OUT$TRAFFICMON_UNIT")
  echo -e "IN_MB='$IN'\nOUT_MB='$OUT'" >> $TRAFFICMON_DATAPATH
fi
if [ "$TRAFFICMON_UNIT" = "KB" ]
then
  IN=`expr $IN / 1024`
  OUT=`expr $OUT / 1024`
  IN=$(echo -e "$IN$TRAFFICMON_UNIT")
  OUT=$(echo -e "$OUT$TRAFFICMON_UNIT")
  echo -e "IN_KB='$IN'\nOUT_KB='$OUT'" >> $TRAFFICMON_DATAPATH
fi
### END

### BEGIN append other infos
echo -e "$DATA" >> $TRAFFICMON_DATAPATH
# insert next reset (in days) comment
MONTH=$(date +%m)
  DAYOFMONTH=$(date +%d)
  if [ "$MONTH" = "01" -o "$MONTH" = "03" -o "$MONTH" = "05" -o \
       "$MONTH" = "07" -o "$MONTH" = "08" -o "$MONTH" = "10" -o \
       "$MONTH" = "12" ]
  then
    DAYS_LEFT=$( expr 31 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  if [ "$MONTH" = "04" -o "$MONTH" = "06" -o "$MONTH" = "09" -o "$MONTH" = "11" ]
  then
    DAYS_LEFT=$( expr 30 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  if [ "$MONTH" = "02" ]
  then
    DAYS_LEFT=$( expr 28 - $DAYOFMONTH + $TRAFFICMON_RESET )
  fi
  echo -e "NEXT_RESET='$DAYS_LEFT DAYS'" >> $TRAFFICMON_DATAPATH
### END


### BEGIN write LCD-files
if [ "$TRAFFICMON_LCD" = "yes" ]
then
  echo -e "$IN" > $TRAFFICMON_FILE_DOWN
  echo -e "$OUT" > $TRAFFICMON_FILE_UP
fi
### END