#! /bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/trafficmon_backup.sh					v0.3X
#
# Creation:     2002.08.11  bue
# Last Update:  2002.08.15  bue
#------------------------------------------------------------------------------


### BEGIN get the variables from config-file
TRAFFICMON_DATAPATH=$(grep "TRAFFICMON_DATAPATH" /etc/rc.cfg | cut -d"'" -f2)
TRAFFICMON_BACKUPDIR=$(grep "TRAFFICMON_BACKUPDIR" /etc/rc.cfg | cut -d"'" -f2)
### END

### BEGIN get date
DATE=`date +_%Y_%m_%d`
### END

### BEGIN get filename of logfile
LOGFILENAME=$(basename $TRAFFICMON_DATAPATH)
### END

### BEGIN save Logfile with date in the filename to the backup-dir
if [ $# -ne '' ]
then #wenn ein beliebiger parameter bergeben wurde
  #reset-Marke mit Uhrzeit anhaengen  
  RESET="_reset@$(date +%H%M%S)"
else
  RESET=''
fi
cp $TRAFFICMON_DATAPATH $(echo -e "$TRAFFICMON_BACKUPDIR/$LOGFILENAME$DATE$RESET")
### END
