/*****************************************************************************\
*   opt_cpanel2.3                                                26.07.2002   *
*                                                                             *
*   cpanel - Kontrollprogramm fr die Serielle Fernsteuerung                  *
*   Copyright (C) 2000 bei Mirko Dlle, DG2FER <dg2fer@qsl.net>               *
*     modified by Georg Kainzbauer <fli4l@gkainzbauer.de>                     *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software Foundation,   *
*   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.            *
\*****************************************************************************/

#define VERINFO "opt_cpanel2.3"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/cdrom.h>
#include <signal.h>

FILE *dmaInfile;
char dmaFileInhalt[12];
int dmaStatus;
int LEDStatus;
int fd = 0;

typedef enum
{
  ROT = 0, GRUEN, GELB, GRUENGELB
} Farbe;

/* Signal-Handler: Panel rot setzen dann exit */
void SetRed(int code)
{
  int status = 0;
  ioctl(fd, TIOCMSET, &status);
  exit(0);
}

int SetPanelLED(Farbe LEDs, int fd, int currstat)
{
  if((LEDs & GELB) != 0)
    {
      LEDStatus = 1;
      currstat |= TIOCM_RTS;
    }
  else
    {
      LEDStatus = 0;
      currstat &= ~TIOCM_RTS;
    }
  if((LEDs & GRUEN) != 0)
    {
      LEDStatus += 2;
      currstat |= TIOCM_DTR;
    }
  else
    {
      LEDStatus += 4;
      currstat &= ~TIOCM_DTR;
    }
  ioctl(fd, TIOCMSET, &currstat);

  return currstat;
}

int Blink(int fd, int currstat)
{
  int i;
  int temp;
  temp = LEDStatus;
  
  for (i=0; i<3; i++)
    {
      usleep(300000);
      if((temp==3) || (temp==5))
        SetPanelLED(ROT | GELB, fd, currstat);
      else
    	  SetPanelLED(ROT, fd, currstat);
      usleep(300000);
      if((temp==3) || (temp==5))
        SetPanelLED(GRUEN | GELB, fd, currstat);
      else
        SetPanelLED(GRUEN, fd, currstat);
    }
  LEDStatus = temp;
  return currstat;
}

/* Panel-Ansteuerung */
void PanelControl(int fd, int currstat )
{
  int laststat = currstat;
  int changed = 1;
  int i = 0;
  int dslstatus = 0;

  while(1)
    {
      usleep(75000);                        /* 75ms Delay */
      ioctl(fd, TIOCMGET, &currstat);       /* Schnittstellenstatus lesen */
      currstat &= ~(TIOCM_DTR | TIOCM_RTS); /* LED-Status abschneiden */

      if(dslstatus < 50)
	  {
	    dslstatus++;
	  }
      else
        {
	    dslstatus = 0;
	    system("/opt/files/usr/local/bin/fli4lctrl status pppoe > /status.txt");
	    dmaInfile = fopen("/status.txt","rb+");
          fscanf(dmaInfile, "%s", dmaFileInhalt);
          fclose(dmaInfile);
          if(strcmp("online",dmaFileInhalt)==0) dmaStatus=1;
          if(strcmp("offline",dmaFileInhalt)==0) dmaStatus=2;
          switch (dmaStatus)
       	{
      	  case 1:
	          SetPanelLED(GRUEN | GELB, fd, currstat);
		    break;
              case 2:
		    SetPanelLED(GRUEN, fd, currstat);
		    break;
	        default:
		    printf("FEHLER - Statusfile konnte nicht ausgewertet werden");
        	    SetPanelLED(GRUEN, fd, currstat);
    		    break;
	      }
	  }

      if(currstat != laststat)
	{
	  laststat = currstat ;
	  i = 0;
	  changed = 0;
	}
      else
	{
	  if(i < 3)
	    {
	      i++;
	    }
	  else if(changed == 0)
	    {
	      /* 3 * Delay: Taste ist gedrckt, Aktion auslsen.  */
	      /* DTR und RTS (Anzeige-LED) bleiben hierbei        */
	      /* unbeachtet, werden also hier gelscht.           */
	      changed = 1;
		dslstatus = 30;

	      switch(currstat)
		{
		case TIOCM_RNG:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion1 ");
		  break;
		case TIOCM_CTS:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion2 ");
		  break;
		case (TIOCM_CTS | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion3 ");
		  break;
		case TIOCM_DSR:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion4 ");
		  break;
		case (TIOCM_DSR | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion5 ");
		  break;
		case (TIOCM_DSR | TIOCM_CTS):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion6 ");
		  break;
		case (TIOCM_DSR | TIOCM_CTS | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion7 ");
		  break;
		case TIOCM_CAR:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion8 ");
		  break;
		case (TIOCM_CAR | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion9 ");
		  break;
		case (TIOCM_CAR | TIOCM_CTS):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion10 ");
		  break;
		case (TIOCM_CAR | TIOCM_CTS | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion11 ");
		  break;
		case (TIOCM_CAR | TIOCM_DSR):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion12 ");
		  break;
		case (TIOCM_CAR | TIOCM_DSR | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion13 ");
		  break;
		case (TIOCM_CAR | TIOCM_DSR | TIOCM_CTS):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion14 ");
		  break;
		default:
		  SetPanelLED(GRUEN, fd, currstat);
		}
	    }
	}
    }
}

int main(int argc, char** argv)
{
  /* int oldstat = 0; */
  int currstat = 0;

  /* Parameterprfung: Das zu verwendende Device mu als erster Parameter */
  /* angegeben werden.                                                    */
  if(argc != 2)
    {
      #ifdef VERINFO
      puts(VERINFO);
      #endif
      printf("\ncpanel ermglicht die Abfrage von 4 Tasten am seriellen Port. \n");
      printf("Beim Drcken der Tasten werden die Skripte /usr/local/cpanel/funktion1-14  \n");
      printf("aufgerufen. Diese Skripte knnen nach belieben gendert werden. \n\n");
      printf("Aufruf: ");
      printf("  cpanel <device>\n");
      return 1;
    }

  /* Das Device ffnen */
  if((fd = open(argv[1], O_RDWR | O_NDELAY)) < 0)
    {
      printf("Fehler: Device \"%s\" kann nicht geffnet werden.\n", argv[1]);
      return 2;
    } 

  /* Signale INT und TERM abfangen, erst Panel auf rot setzen dann exit */
  signal (SIGINT, SetRed);
  signal (SIGTERM, SetRed);
  
  /* Panel initialisieren: Grn */
  currstat = TIOCM_DTR;
  ioctl(fd, TIOCMSET, &currstat);
  
  /* Panelsteuerung aufrufen */
  PanelControl(fd, currstat);
  
  return 0;
}
