/*****************************************************************************\
*   cpanel - Kontrollprogramm fr die Serielle Fernsteuerung                  *
*   Copyright (C) 2000 bei Mirko Dlle, DG2FER <dg2fer@qsl.net>               *
*     modified by Johannes Hermen jhermen@gmx.de                              *
*       modified by Georg Kainzbauer <fli4l@gkainzbauer.de>                   *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software Foundation,   *
*   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.            *
\*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/cdrom.h>
#include <signal.h>

int fd = 0;

typedef enum
{
  ROT = 0, GRUEN, GELB, GRUENGELB
} Farbe;

/* Signal-Handler: Panel rot setzen dann exit */
void SetRed(int code)
{
  int status = 0;
  ioctl(fd, TIOCMSET, &status);
  exit(0);
}

int SetPanelLED(Farbe LEDs, int fd, int currstat)
{
  if((LEDs & GELB) != 0)
    currstat |= TIOCM_RTS;
  else
    currstat &= ~TIOCM_RTS;

  if((LEDs & GRUEN) != 0)
    currstat |= TIOCM_DTR;
  else
    currstat &= ~TIOCM_DTR;

  ioctl(fd, TIOCMSET, &currstat);

  return currstat;
}
int Blink(int fd, int currstat)
{
  int i;
  
  for (i=0; i<3; i++)
    {
      usleep(300000);
      SetPanelLED(ROT | GELB, fd, currstat);
      usleep(300000);
      SetPanelLED(ROT, fd, currstat);
    }
  return currstat;
}

/* Panel-Ansteuerung */
void PanelControl(int fd, int currstat )
{
  int laststat = currstat;
  int changed = 1;
  int i = 0;

  while(1)
    {
      usleep(75000);                        /* 75ms Delay */
      ioctl(fd, TIOCMGET, &currstat);       /* Schnittstellenstatus lesen */
      currstat &= ~(TIOCM_DTR | TIOCM_RTS); /* LED-Status abschneiden */

      if(currstat != laststat)
	{
	  laststat = currstat ;
	  i = 0;
	  changed = 0;
	}
      else
	{
	  if(i < 3)
	    {
	      i++;
	    }
	  else if(changed == 0)
	    {
	      /* 3 * Delay: Taste ist gedrckt, Aktion auslsen.  */
	      /* DTR und RTS (Anzeige-LED) bleiben hierbei        */
	      /* unbeachtet, werden also hier gelscht.           */
	      changed = 1;

	      switch(currstat)
		{
		case TIOCM_RNG:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion1 ");
		  break;
		case TIOCM_CTS:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion2 ");
		  break;
		case (TIOCM_CTS | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion3 ");
		  break;
		case TIOCM_DSR:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion4 ");
		  break;
		case (TIOCM_DSR | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion5 ");
		  break;
		case (TIOCM_DSR | TIOCM_CTS):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion6 ");
		  break;
		case (TIOCM_DSR | TIOCM_CTS | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion7 ");
		  break;
		case TIOCM_CAR:
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion8 ");
		  break;
		case (TIOCM_CAR | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion9 ");
		  break;
		case (TIOCM_CAR | TIOCM_CTS):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion10 ");
		  break;
		case (TIOCM_CAR | TIOCM_CTS | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion11 ");
		  break;
		case (TIOCM_CAR | TIOCM_DSR):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion12 ");
		  break;
		case (TIOCM_CAR | TIOCM_DSR | TIOCM_RNG):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion13 ");
		  break;
		case (TIOCM_CAR | TIOCM_DSR | TIOCM_CTS):
		  Blink(fd, currstat);
		  system("/usr/local/cpanel/funktion14 ");
		  break;
		default:
		  SetPanelLED(GRUEN, fd, currstat);
		}
	    }
	}
    }
}

int main(int argc, char** argv)
{
  /* int oldstat = 0; */
  int currstat = 0;

  /* Parameterprfung: Das zu verwendende Device mu als erster Parameter */
  /* angegeben werden.                                                    */
  if(argc != 2)
    {
      printf("cpanel ermglicht die abfrage von 4 Tasten am seriellen Port. \n");
      printf("beim drcken der Tasten werden die skripte /usr/local/cpanel/funktion1-14  \n");
      printf("aufgerufen. diese Skripte knnen nach belieben gendert werden. \n");
      printf("Aufruf:\n");
      printf("  cpanel <device>\n");
      return 1;
    }

  /* Das Device ffnen */
  if((fd = open(argv[1], O_RDWR | O_NDELAY)) < 0)
    {
      printf("Fehler: Device \"%s\" kann nicht geffnet werden.\n", argv[1]);
      return 2;
    } 

  /* Signale INT und TERM abfangen, erst Panel auf rot setzen dann exit */
  signal (SIGINT, SetRed);
  signal (SIGTERM, SetRed);
  
  /* Panel initialisieren: Grn */
  currstat = TIOCM_DTR;
  ioctl(fd, TIOCMSET, &currstat);
  
  /* Panelsteuerung aufrufen */
  PanelControl(fd, currstat);
  
  return 0;
}
