#! /bin/sh
#------------------------------------------------------------------------------
#
# Creation:     30.05.2002  mas
# Last Update:  17.07.2002  mas
#
#------------------------------------------------------------------------------

. /etc/rc.cfg

DATE=`date -R`                                              # aktuelles Datum ermitteln
TS=`date +%M%S`
CMD=$1                                                      # den uebergebenn befehl ermitteln

#------------------------------------------------------------------------------
# Erstellen der pop.cmd wenn FAXMAIL_POPCHECK='yes'
# und kurzes einloggen auf dem pop3-server
#------------------------------------------------------------------------------

if [ "$FAXMAIL_POPCHECK" = "yes" ]
   then
   echo -e "user $FAXMAIL_USER\npass $FAXMAIL_PASSWORD\r\nquit" > $FAXMAIL_CMD_PATH/pop.cmd
   if [ "$FAXMAIL_WAIT_SERVER_RESP" = "" ]
   	then
   	/usr/local/bin/netcat $FAXMAIL_POP $FAXMAIL_PPORT < $FAXMAIL_CMD_PATH/pop.cmd
   	else
   	/usr/local/bin/netcat -i $FAXMAIL_WAIT_SERVER_RESP $FAXMAIL_POP $FAXMAIL_PPORT < $FAXMAIL_CMD_PATH/pop.cmd
   fi
fi

#------------------------------------------------------------------------------
# wenn befehl = -free, dann mail mit angegebenen parametern
#------------------------------------------------------------------------------

if [ "$CMD" = "-free" ]
   then

#------------------------------------------------------------------------------
# parameter -> variablen
#------------------------------------------------------------------------------
   FM=$2
   TO=$3
   SJ=$4
   TX=$5

#------------------------------------------------------------------------------
# Erstellen der smtp.cmd
#------------------------------------------------------------------------------

   (
   echo -e "helo $FAXMAIL_SMTP\r"
   echo -e "mail from: $FM\r"
   echo -e "rcpt to: $TO\r"
   echo -e "data\r"
   echo -e "date: $DATE\r"
   echo -e "from: $FM\r"
   echo -e "to: $TO\r"
   echo -e "subject: $SJ\r"
   echo -e "\r"
   echo -e "$TX\r"
   ) > $FAXMAIL_CMD_PATH/smtp$TS.cmd

   else

#------------------------------------------------------------------------------
# wenn befehl = -faxrcv, dann mail fax
#------------------------------------------------------------------------------

if [ "$CMD" = "-faxrcv" ]
then
fax_user=$2
datei_name=$3
sender=$4
idx=1
while [ "$idx" -le "$FAXMAIL_FAXRCV_N" ]
do
	if [ "$idx" = "$fax_user" ]
		then
		eval TO='$FAXMAIL_RCV_MAIL_'$idx
		if [ "$TO" != "" ]
			then
			(
			echo -e "helo $FAXMAIL_SMTP\r"
			echo -e "mail from: $FAXMAIL_FM\r"
			echo -e "rcpt to: $TO\r"
			echo -e "data\r"
			echo -e "Date: $DATE\r"
			echo -e "From: $FAXMAIL_FM\r"
			echo -e "Reply-To: $FAXMAIL_FM\r"
			echo -e "To: $TO\r"
			echo -e "Subject: fax von $4 vom $DATE\r"
			echo -e "\r"
			if [ "$FAXMAIL_SEND_GZIP" = "yes" ]
				then
				echo -e "Neues Fax, Datei ist mit GZip gepackt filename.sff.gz \r"
			else
				echo -e "Neues Fax im sff Format\r"
			fi
			echo -e "\r"
			cat $FAXMAIL_MAIL_PATH/$3
			)  >> $FAXMAIL_CMD_PATH/smtp$TS.cmd
			rm $FAXMAIL_MAIL_PATH/$3	
  		else
  			if [ "$FAXMAIL_LOG" = "yes" ]
  				then
  				echo $DATE -faxrcv "no email adress exist MSN$idx"  $3 >> /var/log/faxmail.log
  			fi
  			rm $FAXMAIL_MAIL_PATH/$3
  			exit 0
  		fi
   	fi

   	idx=`/usr/bin/expr $idx + 1`
   	done
	  
	
   else

#------------------------------------------------------------------------------
# wenn nicht -free dann -newip oder -call
# also standard-variablen aus der config.txt nutzen
# und in die smtp.cmd ablegen
#------------------------------------------------------------------------------

(
echo -e "helo $FAXMAIL_SMTP\r"
echo -e "mail from: $FAXMAIL_FM\r"

   idx=1
   while [ "$idx" -le "$FAXMAIL_TO_N" ]
   do
   eval TO='$FAXMAIL_TO_'$idx
   echo -e "rcpt to: $TO\r"
   idx=`/usr/bin/expr $idx + 1`
   done
   
echo -e "data\r"
echo -e "Date: $DATE\r"
echo -e "From: $FAXMAIL_FM\r"
echo -e "Reply-To: $FAXMAIL_FM\r"

   idx=1
   while [ "$idx" -le "$FAXMAIL_TO_N" ]
   do
   eval TO='$FAXMAIL_TO_'$idx
   echo -e "To: $TO\r"
   idx=`/usr/bin/expr $idx + 1`
   done

) > $FAXMAIL_CMD_PATH/smtp$TS.cmd


#------------------------------------------------------------------------------
# wenn befehl = -syslog, dann mail syslog
#------------------------------------------------------------------------------

if [ "$CMD" = "-syslog" ]
   then
     (
   echo -e "Subject: System Log vom $DATE\r"
   cat $FAXMAIL_SYSLOGD_PATH
   )  >> $FAXMAIL_CMD_PATH/smtp$TS.cmd

   else

#------------------------------------------------------------------------------
# wenn befehl = -fax, dann mail fax
#------------------------------------------------------------------------------

if [ "$CMD" = "-fax" ]
   then
     (
   echo -e "Subject: fax von $3 vom $DATE\r"
   echo -e "\r"
   if [ "$FAXMAIL_SEND_GZIP" = "yes" ]
      then
      echo -e "Neues Fax Datei ist mit GZip gepackt filename.pbm.gz \r"
   else
      echo -e "Neues Fax im pbm Format\r"
   fi
   echo -e "\r"
   cat $FAXMAIL_MAIL_PATH/$2
   )  >> $FAXMAIL_CMD_PATH/smtp$TS.cmd
   rm $FAXMAIL_MAIL_PATH/$2	
   else

#------------------------------------------------------------------------------
# wenn befehl = -file, dann mail datei
#------------------------------------------------------------------------------

if [ "$CMD" = "-file" ]
   then
   /usr/local/bin/uuencode $2/$3 $3 >> $FAXMAIL_MAIL_PATH/$3".uue"
     (
   echo -e "Subject: FILE $3 vom $DATE\r"
   echo -e "\r"
   echo -e "Automail von fli4l mit opt faxmail \r"
   echo -e "\r"
   cat $FAXMAIL_MAIL_PATH/$3".uue"
   )  >> $FAXMAIL_CMD_PATH/smtp$TS.cmd
   rm $FAXMAIL_MAIL_PATH/$3".uue"	
   else
   
#------------------------------------------------------------------------------
# wenn befehl = -newip, dann mail ip
# aktuelle ip ermitteln
#------------------------------------------------------------------------------


if [ "$CMD" = "-newip" ]
   then
       if [ "$2" = "" ]                                            # wenn nicht von ip-up aufgerufen
          then IP=`ifconfig | grep P-t-P | cut -d : -f 2`          # dann ip durch ifconfig ermitteln
          else IP=$2                                               # ansonsten die ip von ip-up uebernehemen
       fi
   (
        if [ "$FAXMAIL_IP_SUBJECT" = "" ]
           then echo -e "Subject: $IP\r"
           else
               echo -e "Subject: $FAXMAIL_IP_SUBJECT\r"
               echo -e "\r"
		if [ "$FAXMAIL_IP_TEXT" = "" ]
                  then
                  else echo -e "$FAXMAIL_IP_TEXT\r"
               fi
        echo $IP
        fi
   ) >> $FAXMAIL_CMD_PATH/smtp$TS.cmd

   else

#------------------------------------------------------------------------------
# wenn befehl = -call dann mail call
#------------------------------------------------------------------------------

if [ "$CMD" = "-call" ]
   then
   D=$2   # datum
   T=$3   # zeit
   P=$4   # anruf von
   M=$5   # anruf an

   if [ "$FAXMAIL_CALL_PHONEBOOK" = "yes" ]
      then PB=`grep  $P /etc/phonebook | cut -d = -f 2`
      if [ "$PB" = "" ]
         then
         else P=$PB
      fi
   fi

   (
   if [ "$FAXMAIL_CALL_SUBJECT" = "" ]
      then echo -e "Subject: $D $T $P $M\r"

      else
      echo -e "Subject: $FAXMAIL_CALL_SUBJECT\r"
      echo -e "\r"
      if [ "$FAXMAIL_CALL_TEXT" = "" ]
         then
         else echo -e "$FAXMAIL_CALL_TEXT\r"
      fi
      echo -e "$D $T $P $M\r"
   fi
   ) >> $FAXMAIL_CMD_PATH/smtp$TS.cmd

#------------------------------------------------------------------------------
# wenn nichts von beiden, dann mach ich auch nix! :-)
#------------------------------------------------------------------------------
   else
   echo "falscher parameter-aufruf!!!"
   exit 0
	
   fi
   fi
   fi
   fi
   fi
   fi
fi

#------------------------------------------------------------------------------
# smtp.cmd abschliessen
#------------------------------------------------------------------------------

echo -e "\r\n.\r\nquit\r\nquit\r\nquit\r" >> $FAXMAIL_CMD_PATH/smtp$TS.cmd

#------------------------------------------------------------------------------
# email versenden
#------------------------------------------------------------------------------

#########################
# FAXMAIL_DIAL_OUT= YES #
#########################
if [ "$FAXMAIL_DIAL_OUT" = "yes" ]
	then
		# Wenn DSL dann den aktuellen Status feststellen.
		if [ "$FAXMAIL_DSL_OPT" = "yes" ]
		  	then
		  	# Prfe ob eine Internet verbindung besteht.
			if [ -f /var/run/pppoe.up ]
			then
				STATUS="on"
			else
				# Keine aktive Verbindung. Prfe welcher Dialmode eingestellt ist.
				STATUS="off"
				dialmode=`cat /var/run/pppoe.dialmode`
				case "$dialmode"
				in
					off)
						# Roter ist auf OFF gestellt.
						# Wechsel auf MANUELL und stelle eine Verbindung her
						#/usr/local/bin/delete-all-routes ppp0
						echo manual >/var/run/pppoe.dialmode
						/sbin/route del default 2>/dev/null
						/sbin/route add -net default dev ppp0
						;;
					manual)
						# Router ist im MANUELL Modus, baue eine Verbindung auf.
						/sbin/route del default 2>/dev/null
						/sbin/route add -net default dev ppp0
						;;
				esac
			fi
		fi
fi		

if [ "$FAXMAIL_WAIT_SERVER_RESP" = "" ]
  	then
  	/usr/local/bin/netcat $FAXMAIL_POP $FAXMAIL_PPORT < $FAXMAIL_CMD_PATH/smtp$TS.cmd
  	else
  	#
  	# netcat -i secs delay interval for lines sent, ports scanned
  	# steht default auf 1 sec. dh. das bertragen einer line dauert 1 sec!!
  	# im test bei einer faxseite 45 min. ;-((
  	# ohne -i gehts bei mir ratz fatz. sollten prob. mit dem versend auftreten
  	# den schalter -i aktivieren.
  	
  		# /usr/local/bin/netcat -w 30 -i $FAXMAIL_WAIT_SERVER_RESP $FAXMAIL_SMTP $FAXMAIL_SPORT < $FAXMAIL_CMD_PATH/smtp$TS.cmd
  		/usr/local/bin/netcat -w 30 $FAXMAIL_SMTP $FAXMAIL_SPORT < $FAXMAIL_CMD_PATH/smtp$TS.cmd
  	
fi

#------------------------------------------------------------------------------
# syslogdatei lschen
#------------------------------------------------------------------------------

if [ "$CMD" = "-syslog" ]
   then
   echo "" > $FAXMAIL_SYSLOGD_PATH

fi

#------------------------------------------------------------------------------
# smtp.cmd lschen und log schreiben.
#------------------------------------------------------------------------------

rm $FAXMAIL_CMD_PATH/smtp$TS.cmd
if [ "$FAXMAIL_LOG" = "yes" ]
	then
	case "$CMD"
	in
		-fax)
			echo $DATE $CMD $FAXMAIL_TO_1 $2 >> /var/log/faxmail.log
			;;
		-newip)
			echo $DATE $CMD $FAXMAIL_TO_1 >> /var/log/faxmail.log
			;;
		-syslog)
			echo $DATE $CMD $FAXMAIL_TO_1 >> /var/log/faxmail.log
			;;
		-file)
			echo $DATE $CMD $FAXMAIL_TO_1 $3 >> /var/log/faxmail.log
			;;
		-faxrcv)
			echo $DATE $CMD $FAXMAIL_TO_1 $3 >> /var/log/faxmail.log
			;;
	esac
fi
	

#------------------------------------------------------------------------------
# wenn dial out = yes
#------------------------------------------------------------------------------
if [ "$FAXMAIL_DIAL_OUT" = "yes" ]
  	then
  	# Wenn DSL dann den aktuellen Status feststellen.
	if [ "$FAXMAIL_DSL_OPT" = "yes" ]
		then
 		# Wenn keine Verbindung bestanden hat, beende die Verbindung.
  		if [ "$STATUS" = "off" ]
		  	then
		  	if [ -f /var/run/pppoe.up ]
				then
				if [ -f /var/run/pppoe.pid ]
				    then
					exec kill `cat /var/run/pppoe.pid` 2>/dev/null
				else
					# This doesn't work because one of the two pptp processes
					# die if we send a SIGHUP:
					# exec kill -1 `cat /var/run/ppp0.pid` 2>/dev/null
					# Here we kill pppd, etc/rc.d/pptp restarts it with
					# defaultroute, because fli4lctrl cannot set the default
					# route again to ppp0 - not existant :-(
					exec kill `cat /var/run/ppp0.pid` 2>/dev/null
				fi
			fi
			# Stand der Router im Modus off? Wenn ja schalte ihne wieder in den Modus.
		  	if [ "$dialmode" = "off" ]
				then
				/usr/local/bin/delete-all-routes $device
				echo $arg >/var/run/pppoe.dialmode
			fi
		fi
	fi	
fi

#------------------------------------------------------------------------------
# ende
#------------------------------------------------------------------------------

#exit 0