#!/bin/sh
#------------------------------------------------------------------------------
# /opt/files/srv/www/admin/accounting.cgi - show the accounting-data
# see documentation for licence
#
# Creation:     05.06.2002  Michael Knipping <fli4l@knibo.de>
# Last Update:  09.12.2005  Michael Knipping <fli4l@knibo.de>
#------------------------------------------------------------------------------
# get main helper functions
. /srv/www/include/cgi-helper

# Security
check_rights "logs" "view"

show_html_header "Accounting"

#------------------------------------------------------------------------------
# Config Datei einlesen, Abbruch wenn diese nicht existiert
#------------------------------------------------------------------------------
if [ -f "/etc/accounting.conf" ]; then
    . /etc/accounting.conf
else
    echo "/etc/accounting.conf not found"
    exit 1
fi

#------------------------------------------------------------------------------
# Variablen setzen
#------------------------------------------------------------------------------
myname=`basename $0`
colorin="blue"
colorout="green"
tablinecolor1="#DDDDDD"
tablinecolor2="#EEEEEE"
tablinecolor3="#F6F6F6"
month01='Januar'
month02='Februar'
month03='Mrz'
month04='April'
month05='Mai'
month06='Juni'
month07='Juli'
month08='August'
month09='September'
month10='Oktober'
month11='November'
month12='Dezember'
monat=$(date +%m)
tag=$(date +%Y-%m-%d)
jahr=$(date +%Y)

#------------------------------------------------------------------------------
# Anzeigeeinstellungen
#------------------------------------------------------------------------------
if [ -f "$ACCOUNTING_DIR/view.conf" ]; then
    anzeigewert=$(cat $ACCOUNTING_DIR/view.conf | grep 'anzeigwert' | cut -d' ' -f2)
    anzeige=$(cat $ACCOUNTING_DIR/view.conf | grep 'anzeige' | cut -d' ' -f2)
    nachkomma=$(cat $ACCOUNTING_DIR/view.conf | grep 'nachkomma' | cut -d' ' -f2)
    nulldata=$(cat $ACCOUNTING_DIR/view.conf | grep 'nulldata' | cut -d' ' -f2)
else
    anzeigewert="1"
    anzeige="Byte"
    nachkomma="1"
    nulldata="Ja"
fi

#------------------------------------------------------------------------------
# Standartaktion
#------------------------------------------------------------------------------
: ${FORM_action:=top}

#------------------------------------------------------------------------------
# Jahresbersicht
#------------------------------------------------------------------------------
if [ "$FORM_action" = "top" ]; then
    : ${FORM_yy:=$jahr}
    show_tab_header "Jahresbersicht" no
    for yy in $(ls -lA $ACCOUNTING_DIR/ | grep ^d | cut -c57-)
    do
        if [ $yy = $FORM_yy ]
        then echo '<b>'$yy'</b>'
        else echo '<a href="'$myname'?action=top&yy='$yy'">'$yy'</a>'
        fi
    done
    yy=$FORM_yy
    sumi=0
    sumo=0
    for mm in $(cd $ACCOUNTING_DIR/$yy/; ls $yy-??.acc | cut -d"." -f1 | cut -d"-" -f2)
    do
        . $ACCOUNTING_DIR/$idx_y/$yy/$yy-$mm.acc
        eval acci="\$ACCOUNTING_Y"$yy"_M"$mm"_i"
        eval acco="\$ACCOUNTING_Y"$yy"_M"$mm"_o"
        [ $acci ] && sumi=$(echo $sumi + $acci | /usr/bin/bc)
        [ $acco ] && sumo=$(echo $sumo + $acco | /usr/bin/bc)
    done
    summe=$(echo $sumi + $sumo | /usr/bin/bc)
    linecl="1"
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Monat</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    for mm in $(cd $ACCOUNTING_DIR/$yy/; ls $yy-??.acc | cut -d"." -f1 | cut -d"-" -f2)
    do
        eval acci="\$ACCOUNTING_Y"$yy"_M"$mm"_i"
        eval acco="\$ACCOUNTING_Y"$yy"_M"$mm"_o"
        : ${acci:=0}
        : ${acco:=0}
        [ "$sumi" = "0" ] && graphii="0" || graphii=$(echo 100 \* $acci / $sumi | /usr/bin/bc)
        [ "$sumo" = "0" ] && graphoo="0" || graphoo=$(echo 100 \* $acco / $sumo | /usr/bin/bc)
        if [ "$summe" = "0" ]; then
            graphis="0"
            graphos="0"
            graphss="0"
        else
            graphis=$(echo 100 \* $acci / $summe | /usr/bin/bc)
            graphos=$(echo 100 \* $acco / $summe | /usr/bin/bc)
            graphss=$(echo 100 \* $sumi / $summe | /usr/bin/bc)
        fi
        if [ "$linecl" = "1" ]; then
            tablinecolor=$tablinecolor3
            linecl="2"
        else
            tablinecolor=$tablinecolor2
            linecl="1"
        fi
        eval monthname=\$month$mm
        echo '<tr><td bgcolor="'$tablinecolor'"><a href="'$myname'?action=accview&yy='$yy'&mm='$mm'">'$monthname'</a></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphii'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acci / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="'$graphoo'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acco / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphis'%"></td><td bgcolor="'$colorout'" width="'$graphos'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $(echo $acci + $acco | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Summen</b></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumi / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumo / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphss'%">&nbsp;</td><td bgcolor="'$colorout'">&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $summe / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    echo '</table>'
    echo '<br><a href="'$myname'?action=aktualisieren">Aktualisieren</a>'
    show_tab_footer
    echo '<br>'

    show_tab_header "Zeitraum berechnen" no
    echo '<form method="post"><input type="hidden" name="action" value="period">'
    echo 'Angabe im Format: dd.mm.yyyy<br>'
    echo 'von <input type="text" name="von" size="10">'
    echo 'bis <input type="text" name="bis" size="10">'
    echo '<input type="submit" value="  OK  "></form>'
    show_tab_footer
    echo '<br>'

    show_tab_header "Anzeigeeinstellungen" no
    echo '<form method="post"><input type="hidden" name="action" value="conf">'
    echo '<table><tr><td>Anzeige in:</td><td><select name="anzeige" size="1">'
    echo -n '<option'; [ $anzeige = "Byte" ] && echo -n ' selected'; echo '>Byte</option>'
    echo -n '<option'; [ $anzeige = "KiloByte" ] && echo -n ' selected'; echo '>KiloByte</option>'
    echo -n '<option'; [ $anzeige = "MegaByte" ] && echo -n ' selected'; echo '>MegaByte</option>'
    echo -n '<option'; [ $anzeige = "GigaByte" ] && echo -n ' selected'; echo '>GigaByte</option>'
    echo '</select></td></tr><tr><td>'
    echo 'Nachkommastellen:</td><td><select name="nachkomma" size="1">'
    echo -n '<option'; [ $nachkomma = "0" ] && echo -n ' selected'; echo '>0</option>'
    echo -n '<option'; [ $nachkomma = "1" ] && echo -n ' selected'; echo '>1</option>'
    echo -n '<option'; [ $nachkomma = "2" ] && echo -n ' selected'; echo '>2</option>'
    echo -n '<option'; [ $nachkomma = "3" ] && echo -n ' selected'; echo '>3</option>'
    echo '</select></td></tr><tr><td>'
    echo 'Nulldaten anzeigen:</td><td><select name="nulldata" size="1">'
    echo -n '<option'; [ $nulldata = "Ja" ] && echo -n ' selected'; echo '>Ja</option>'
    echo -n '<option'; [ $nulldata = "Nein" ] && echo -n ' selected'; echo '>Nein</option>'
    echo '</select>'
    echo '<input type="submit" value="  OK  "></td></tr></table></form>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# Tagesdaten
#------------------------------------------------------------------------------
if [ "$FORM_action" = "dacc" ]; then
    eval monthname=\$month$FORM_mm
    show_tab_header "$FORM_dd. $monthname $FORM_yy" no
    . $ACCOUNTING_DIR/index.acc
    . $ACCOUNTING_DIR/$FORM_yy/$FORM_yy-$FORM_mm.acc
    sumi=0
    sumo=0
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acci="\$ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_i"
        eval acco="\$ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_o"
        [ $acci ] && sumi=$(echo $sumi + $acci | /usr/bin/bc)
        [ $acco ] && sumo=$(echo $sumo + $acco | /usr/bin/bc)
    done
    summe=$(echo $sumi + $sumo | /usr/bin/bc)
    linecl="1"
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Host</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
        eval acci="\$ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_i"
        eval acco="\$ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_o"
        : ${acci:=0}
        : ${acco:=0}
        [ "$sumi" = "0" ] && graphii="0" || graphii=$(echo 100 \* $acci / $sumi | /usr/bin/bc)
        [ "$sumo" = "0" ] && graphoo="0" || graphoo=$(echo 100 \* $acco / $sumo | /usr/bin/bc)
        if [ "$summe" = "0" ]; then
            graphis="0"
            graphos="0"
            graphss="0"
        else
            graphis=$(echo 100 \* $acci / $summe | /usr/bin/bc)
            graphos=$(echo 100 \* $acco / $summe | /usr/bin/bc)
            graphss=$(echo 100 \* $sumi / $summe | /usr/bin/bc)
        fi
        if [ "$acci" != "0" -o "$acco" != "0" -o "$nulldata" = "Ja" ]; then
            if [ "$linecl" = "1" ]; then
                tablinecolor=$tablinecolor3
                linecl="2"
            else
                tablinecolor=$tablinecolor2
                linecl="1"
            fi
            echo '<tr><td bgcolor="'$tablinecolor'">'$acch'</td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphii'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acci / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="'$graphoo'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acco / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphis'%"></td><td bgcolor="'$colorout'" width="'$graphos'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $(echo $acci + $acco | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
        fi
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Summen</b></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumi / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumo / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphss'%">&nbsp;</td><td bgcolor="'$colorout'">&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $summe / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    echo '</table>'
    echo '<br>'
    allaccint_i="0"
    allaccint_o="0"
    set $ACCOUNTING_INT
    echo '<table border="0" width="100%" cellspacing="2">'
    linecl="2"
    while [ "$1" != "" ]
    do
        ACCOUNTING_INT_NR=$(grep "'$1'" $ACCOUNTING_DIR/index.acc | cut -d'_' -f3)
        eval ACCOUNTING_INT_NAME="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_NAME"
        eval wertin="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_i"
        eval wertout="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_o"
        : ${wertin:=0}
        : ${wertout:=0}
        allaccint_i=$(echo $allaccint_i + $wertin | /usr/bin/bc)
        allaccint_o=$(echo $allaccint_o + $wertout | /usr/bin/bc)
        if [ "$linecl" = "1" ]; then
            tablinecolor=$tablinecolor3
            linecl="2"
        else
            tablinecolor=$tablinecolor2
            linecl="1"
        fi
        echo '<tr><td width="25%" bgcolor="'$tablinecolor'">Interface '$ACCOUNTING_INT_NAME'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $wertin / $anzeigewert | /usr/bin/bc)'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $wertout / $anzeigewert | /usr/bin/bc)'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $(echo $wertin + $wertout | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</td></tr>'
        shift 1
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Differenz</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_i - $sumi | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_o - $sumo | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_i + $allaccint_o - $sumi - $sumo | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr>'
    echo '</table>'
    echo '<br>'
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Interface</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    linecl="1"
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval intn="\$ACCOUNTING_INT_"$idx"_NAME"
        eval inti="\$ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_i"
        eval into="\$ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$FORM_dd"_o"
        : ${inti:=0}
        : ${into:=0}
        if [ "$inti" != "0" -o "$into" != "0" -o "$nulldata" = "Ja" ]; then
            if [ "$linecl" = "1" ]; then
                tablinecolor=$tablinecolor3
                linecl="2"
            else
                tablinecolor=$tablinecolor2
                linecl="1"
            fi
            echo '<tr><td bgcolor="'$tablinecolor'">'$intn'</td><td align="right" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $inti / $anzeigewert | /usr/bin/bc)'</td><td align="right" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $into / $anzeigewert | /usr/bin/bc)'</td><td align="right" bgcolor="'$tablinecolor'"><b>'$(echo scale=$nachkomma\; $(echo $inti + $into | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr>'
        fi
    done
    echo '</table>'
    echo '<br><b><a href="'$myname'?action=accview&yy='$FORM_yy'&mm='$FORM_mm'">'zur Monatsansicht'</a> '
    echo '<a href="'$myname'?action=top&yy='$FORM_yy'">zur&uuml;ck zur &Uuml;bersicht</a></b>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# Monatsdaten
#------------------------------------------------------------------------------
if [ "$FORM_action" = "accview" ]; then
    eval monthname=\$month$FORM_mm
    show_tab_header "$monthname $FORM_yy" no
    . $ACCOUNTING_DIR/index.acc
    . $ACCOUNTING_DIR/$FORM_yy/$FORM_yy-$FORM_mm.acc
    eval sumi="\$ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_i"
    eval sumo="\$ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_o"
    summe=$(echo $sumi + $sumo | /usr/bin/bc)
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Host</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    linecl="1"
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
        eval acci="\$ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_i"
        eval acco="\$ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_o"
        : ${acci:=0}
        : ${acco:=0}
        [ "$sumi" = "0" ] && graphii="0" || graphii=$(echo 100 \* $acci / $sumi | /usr/bin/bc)
        [ "$sumo" = "0" ] && graphoo="0" || graphoo=$(echo 100 \* $acco / $sumo | /usr/bin/bc)
        if [ "$summe" = "0" ]; then
            graphis="0"
            graphos="0"
            graphss="0"
        else
            graphis=$(echo 100 \* $acci / $summe | /usr/bin/bc)
            graphos=$(echo 100 \* $acco / $summe | /usr/bin/bc)
            graphss=$(echo 100 \* $sumi / $summe | /usr/bin/bc)
        fi
        if [ "$acci" != "0" -o "$acco" != "0" -o "$nulldata" = "Ja" ]; then
            if [ "$linecl" = "1" ]; then
                tablinecolor=$tablinecolor3
                linecl="2"
            else
                tablinecolor=$tablinecolor2
                linecl="1"
            fi
            echo '<tr><td bgcolor="'$tablinecolor'"><a href="'$myname'?action=accviewhost&yy='$FORM_yy'&mm='$FORM_mm'&hostn='$idx'">'$acch'</a></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphii'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acci / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="'$graphoo'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acco / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphis'%"></td><td bgcolor="'$colorout'" width="'$graphos'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $(echo $acci + $acco | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
        fi
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Summen</b></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumi / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumo / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphss'%">&nbsp;</td><td bgcolor="'$colorout'">&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $summe / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    echo '</table>'
    echo '<br>'
    allaccint_i="0"
    allaccint_o="0"
    set $ACCOUNTING_INT
    echo '<table border="0" width="100%" cellspacing="2">'
    linecl="2"
    while [ "$1" != "" ]
    do
        ACCOUNTING_INT_NR=$(grep "'$1'" $ACCOUNTING_DIR/index.acc | cut -d'_' -f3)
        eval ACCOUNTING_INT_NAME="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_NAME"
        eval wertin="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$FORM_yy"_M"$FORM_mm"_i"
        eval wertout="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$FORM_yy"_M"$FORM_mm"_o"
        : ${wertin:=0}
        : ${wertout:=0}
        allaccint_i=$(echo $allaccint_i + $wertin | /usr/bin/bc)
        allaccint_o=$(echo $allaccint_o + $wertout | /usr/bin/bc)
        if [ "$linecl" = "1" ]; then
            tablinecolor=$tablinecolor3
            linecl="2"
        else
            tablinecolor=$tablinecolor2
            linecl="1"
        fi
        echo '<tr><td width="25%" bgcolor="'$tablinecolor'">Interface '$ACCOUNTING_INT_NAME'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $wertin / $anzeigewert | /usr/bin/bc)'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $wertout / $anzeigewert | /usr/bin/bc)'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $(echo $wertin + $wertout | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</td></tr>'
        shift 1
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Differenz</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_i - $sumi | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_o - $sumo | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_i + $allaccint_o - $sumi - $sumo | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr>'
    echo '</table>'
    echo '<br>'
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Interface</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    linecl="1"
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval intn="\$ACCOUNTING_INT_"$idx"_NAME"
        eval inti="\$ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_i"
        eval into="\$ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_o"
        : ${inti:=0}
        : ${into:=0}
        if [ "$inti" != "0" -o "$into" != "0" -o "$nulldata" = "Ja" ]; then
            if [ "$linecl" = "1" ]; then
                tablinecolor=$tablinecolor3
                linecl="2"
            else
                tablinecolor=$tablinecolor2
                linecl="1"
            fi
            echo '<tr><td bgcolor="'$tablinecolor'"><a href="'$myname'?action=accviewint&yy='$FORM_yy'&mm='$FORM_mm'&intn='$idx'">'$intn'</a></td><td align="right" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $inti / $anzeigewert | /usr/bin/bc)'</td><td align="right" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $into / $anzeigewert | /usr/bin/bc)'</td><td align="right" bgcolor="'$tablinecolor'"><b>'$(echo scale=$nachkomma\; $(echo $inti + $into | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr>'
        fi
    done
    echo '</table>'
    echo '<br><b><a href="'$myname'?action=top&yy='$FORM_yy'">zur&uuml;ck zur &Uuml;bersicht</a></b>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# Monatsansicht Hosts
#------------------------------------------------------------------------------
if [ "$FORM_action" = "accviewhost" ]; then
    . $ACCOUNTING_DIR/index.acc
    . $ACCOUNTING_DIR/$FORM_yy/$FORM_yy-$FORM_mm.acc
    eval days="\$ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_DAYS"
    eval acch="\$ACCOUNTING_HOST_"$FORM_hostn"_NAME"
    eval sumi="\$ACCOUNTING_HOST_"$FORM_hostn"_Y"$FORM_yy"_M"$FORM_mm"_i"
    eval sumo="\$ACCOUNTING_HOST_"$FORM_hostn"_Y"$FORM_yy"_M"$FORM_mm"_o"
    : ${sumi:=0}
    : ${sumo:=0}
    summe=$(echo $sumi + $sumo | /usr/bin/bc)
    eval monthname=\$month$FORM_mm
    show_tab_header "$acch - $monthname $FORM_yy" no
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Tag</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    linecl="1"
    [ 0$days -eq 0 ] || for idx in `seq 1 $days`
    do
        if [ "$linecl" = "1" ]; then
            tablinecolor=$tablinecolor3
            linecl="2"
        else
            tablinecolor=$tablinecolor2
            linecl="1"
        fi
        [ "$idx" -le "9" ] && dayn="0$idx" || dayn=$idx
        eval acci="\$ACCOUNTING_HOST_"$FORM_hostn"_Y"$FORM_yy"_M"$FORM_mm"_D"$dayn"_i"
        eval acco="\$ACCOUNTING_HOST_"$FORM_hostn"_Y"$FORM_yy"_M"$FORM_mm"_D"$dayn"_o"
        : ${acci:=0}
        : ${acco:=0}
        [ "$sumi" = "0" ] && graphii="0" || graphii=$(echo 100 \* $acci / $sumi | /usr/bin/bc)
        [ "$sumo" = "0" ] && graphoo="0" || graphoo=$(echo 100 \* $acco / $sumo | /usr/bin/bc)
        if [ "$summe" = "0" ]; then
            graphis="0"
            graphos="0"
            graphss="0"
        else
            graphis=$(echo 100 \* $acci / $summe | /usr/bin/bc)
            graphos=$(echo 100 \* $acco / $summe | /usr/bin/bc)
            graphss=$(echo 100 \* $sumi / $summe | /usr/bin/bc)
        fi
        echo '<tr><td bgcolor="'$tablinecolor'"><a href="'$myname'?action=dacc&yy='$FORM_yy'&mm='$FORM_mm'&dd='$dayn'">'$dayn'</a></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphii'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acci / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="'$graphoo'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acco / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphis'%"></td><td bgcolor="'$colorout'" width="'$graphos'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $(echo $acci + $acco | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Summen</b></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumi / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumo / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphss'%">&nbsp;</td><td bgcolor="'$colorout'">&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $summe / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    echo '</table>'
    echo '<br><b><a href="'$myname'?action=accview&yy='$FORM_yy'&mm='$FORM_mm'">zur Monatsansicht</a> '
    echo '<a href="'$myname'?action=top&yy='$FORM_yy'">zur&uuml;ck zur &Uuml;bersicht</a></b>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# Monatsansicht Interfaces
#------------------------------------------------------------------------------
if [ "$FORM_action" = "accviewint" ]; then
    . $ACCOUNTING_DIR/index.acc
    . $ACCOUNTING_DIR/$FORM_yy/$FORM_yy-$FORM_mm.acc
    eval days="\$ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_DAYS"
    eval intn="\$ACCOUNTING_INT_"$FORM_intn"_NAME"
    eval sumi="\$ACCOUNTING_INT_"$FORM_intn"_Y"$FORM_yy"_M"$FORM_mm"_i"
    eval sumo="\$ACCOUNTING_INT_"$FORM_intn"_Y"$FORM_yy"_M"$FORM_mm"_o"
    : ${sumi:=0}
    : ${sumo:=0}
    summe=$(echo $sumi + $sumo | /usr/bin/bc)
    eval monthname=\$month$FORM_mm
    show_tab_header "$intn - $monthname $FORM_yy" no
    echo '<table border="0" width="100%" cellspacing="2">'
    echo '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Tag</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td><td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    linecl="1"
    [ 0$days -eq 0 ] || for idx in `seq 1 $days`
    do
        if [ "$linecl" = "1" ]; then
            tablinecolor=$tablinecolor3
            linecl="2"
        else
            tablinecolor=$tablinecolor2
            linecl="1"
        fi
        [ "$idx" -le "9" ] && dayn="0$idx" || dayn=$idx
        eval inti="\$ACCOUNTING_INT_"$FORM_intn"_Y"$FORM_yy"_M"$FORM_mm"_D"$dayn"_i"
        eval into="\$ACCOUNTING_INT_"$FORM_intn"_Y"$FORM_yy"_M"$FORM_mm"_D"$dayn"_o"
        : ${inti:=0}
        : ${into:=0}
        [ "$sumi" = "0" ] && graphii="0" || graphii=$(echo 100 \* $inti / $sumi | /usr/bin/bc)
        [ "$sumo" = "0" ] && graphoo="0" || graphoo=$(echo 100 \* $into / $sumo | /usr/bin/bc)
        if [ "$summe" = "0" ]; then
            graphis="0"
            graphos="0"
            graphss="0"
        else
            graphis=$(echo 100 \* $inti / $summe | /usr/bin/bc)
            graphos=$(echo 100 \* $into / $summe | /usr/bin/bc)
            graphss=$(echo 100 \* $sumi / $summe | /usr/bin/bc)
        fi
        echo '<tr><td bgcolor="'$tablinecolor'"><a href="'$myname'?action=dacc&yy='$FORM_yy'&mm='$FORM_mm'&dd='$dayn'">'$dayn'</a></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphii'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $inti / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="'$graphoo'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $into / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
        echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphis'%"></td><td bgcolor="'$colorout'" width="'$graphos'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $(echo $inti + $into | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Summen</b></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumi / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumo / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphss'%">&nbsp;</td><td bgcolor="'$colorout'">&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $summe / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    echo '</table>'
    echo '<br><b><a href="'$myname'?action=accview&yy='$FORM_yy'&mm='$FORM_mm'">zur Monatsansicht</a> '
    echo '<a href="'$myname'?action=top&yy='$FORM_yy'">zur&uuml;ck zur &Uuml;bersicht</a></b>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# Zeitraum berechnen
#------------------------------------------------------------------------------
if [ "$FORM_action" = "period" ]; then
    expression="^[0-3][0-9]\.[0-1][0-9]\.[0-9][0-9][0-9][0-9]$"
    if ! echo "$FORM_von" | grep -q "${expression}" || ! echo "$FORM_bis" | grep -q "${expression}"; then
        show_error "Fehler" "<b>Falscher Syntax!<br>Angabe im Format: dd.mm.yyyy<br><br><a href="$myname">zur&uuml;ck zur &Uuml;bersicht</a></b>"
        show_tab_footer
        show_html_footer
        exit
    fi
     . $ACCOUNTING_DIR/index.acc
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
        eval acch$idx=$acch
        eval acci$idx=0
        eval acco$idx=0
    done
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval intn="\$ACCOUNTING_INT_"$idx"_NAME"
        eval intn$idx=$intn
        eval inti$idx=0
        eval into$idx=0
    done
    von_d=`expr $(echo $FORM_von | cut -d'.' -f1) + 1 - 1`
    von_m=`expr $(echo $FORM_von | cut -d'.' -f2) + 1 - 1`
    von_y=$(echo $FORM_von | cut -d'.' -f3)
    bis_d=`expr $(echo $FORM_bis | cut -d'.' -f1) + 1 - 1`
    bis_m=`expr $(echo $FORM_bis | cut -d'.' -f2) + 1 - 1`
    bis_y=$(echo $FORM_bis | cut -d'.' -f3)
    eval von_monthname=\$month$(echo $FORM_von | cut -d'.' -f2)
    eval bis_monthname=\$month$(echo $FORM_bis | cut -d'.' -f2)
    echo -n '<b>'
    for idx_y in `seq $von_y $bis_y`
    do
        [ "$idx_y" = "$von_y" ] && start_m=$von_m || start_m="1"
        [ "$idx_y" = "$bis_y" ] && end_m=$bis_m || end_m="12"
        for idx_m in `seq $start_m $end_m`
        do
            [ "$idx_m" = "$von_m" -a "$idx_y" = "$von_y" ] && start_d=$von_d || start_d="1"
            [ "$idx_m" = "$bis_m" -a "$idx_y" = "$bis_y" ] && end_d=$bis_d || end_d="31"
            [ "$idx_m" -le "9" ] && idx_m="0$idx_m"
            if [ -f "$ACCOUNTING_DIR/$idx_y/$idx_y-$idx_m.acc" ]; then
                . $ACCOUNTING_DIR/$idx_y/$idx_y-$idx_m.acc
                eval lastday="\$ACCOUNTING_Y"$idx_y"_M"$idx_m"_DAYS"
                if [ "$start_d" = "1" -a "$end_d" -ge "$lastday" ]; then
                    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
                    do
                        eval tmpi="\$ACCOUNTING_HOST_"$idx"_Y"$idx_y"_M"$idx_m"_i"
                        eval tmpo="\$ACCOUNTING_HOST_"$idx"_Y"$idx_y"_M"$idx_m"_o"
                        if [ $tmpi ]; then
                            eval acci=\$acci$idx
                            neui=$(echo $tmpi + $acci | /usr/bin/bc)
                            eval acci$idx=$neui
                        fi
                        if [ $tmpo ]; then
                            eval acco=\$acco$idx
                            neuo=$(echo $tmpo + $acco | /usr/bin/bc)
                            eval acco$idx=$neuo
                        fi
                    done
                    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
                    do
                        eval tmpi="\$ACCOUNTING_INT_"$idx"_Y"$idx_y"_M"$idx_m"_i"
                        eval tmpo="\$ACCOUNTING_INT_"$idx"_Y"$idx_y"_M"$idx_m"_o"
                        if [ $tmpi ]; then
                            eval inti=\$inti$idx
                            neui=$(echo $tmpi + $inti | /usr/bin/bc)
                            eval inti$idx=$neui
                        fi
                        if [ $tmpo ]; then
                            eval into=\$into$idx
                            neuo=$(echo $tmpo + $into | /usr/bin/bc)
                            eval into$idx=$neuo
                        fi
                    done
                    echo -n ':'
                else
                    for idx_d in `seq $start_d $end_d`
                    do
                        [ "$idx_d" -le "9" ] && idx_d="0$idx_d"
                        [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
                        do
                            eval tmpi="\$ACCOUNTING_HOST_"$idx"_Y"$idx_y"_M"$idx_m"_D"$idx_d"_i"
                            eval tmpo="\$ACCOUNTING_HOST_"$idx"_Y"$idx_y"_M"$idx_m"_D"$idx_d"_o"
                            if [ $tmpi ]; then
                                eval acci=\$acci$idx
                                neui=$(echo $tmpi + $acci | /usr/bin/bc)
                                eval acci$idx=$neui
                            fi
                            if [ $tmpo ]; then
                                eval acco=\$acco$idx
                                neuo=$(echo $tmpo + $acco | /usr/bin/bc)
                                eval acco$idx=$neuo
                            fi
                        done
                        [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
                        do
                            eval tmpi="\$ACCOUNTING_INT_"$idx"_Y"$idx_y"_M"$idx_m"_D"$idx_d"_i"
                            eval tmpo="\$ACCOUNTING_INT_"$idx"_Y"$idx_y"_M"$idx_m"_D"$idx_d"_o"
                            if [ $tmpi ]; then
                                eval inti=\$inti$idx
                                neui=$(echo $tmpi + $inti | /usr/bin/bc)
                                eval inti$idx=$neui
                            fi
                            if [ $tmpo ]; then
                                eval into=\$into$idx
                                neuo=$(echo $tmpo + $into | /usr/bin/bc)
                                eval into$idx=$neuo
                            fi
                        done
                        echo -n '.'
                    done
                fi
            else
                echo "$ACCOUNTING_DIR/$idx_y/$idx_y-$idx_m.acc existiert nicht<br>"
            fi
        done
    done
    echo '</b>'
    show_tab_header "$von_d. $von_monthname $von_y - $bis_d. $bis_monthname $bis_y" no
    echo '<table border="0" width="100%" cellspacing="2">'
    echo -n '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Host</b></td>'
    echo -n '<td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td>'
    echo -n '<td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td>'
    echo '<td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    sumi=0
    sumo=0
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acci=\$acci$idx
        eval acco=\$acco$idx
        sumi=$(echo $sumi + $acci | /usr/bin/bc)
        sumo=$(echo $sumo + $acco | /usr/bin/bc)
    done
    summe=$(echo $sumi + $sumo | /usr/bin/bc)
    linecl="1"
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch=\$acch$idx
        eval acci=\$acci$idx
        eval acco=\$acco$idx
        [ "$sumi" = "0" ] && graphii="0" || graphii=$(echo 100 \* $acci / $sumi | /usr/bin/bc)
        [ "$sumo" = "0" ] && graphoo="0" || graphoo=$(echo 100 \* $acco / $sumo | /usr/bin/bc)
        if [ "$summe" = "0" ]; then
            graphis="0"
            graphos="0"
            graphss="0"
        else
            graphis=$(echo 100 \* $acci / $summe | /usr/bin/bc)
            graphos=$(echo 100 \* $acco / $summe | /usr/bin/bc)
            graphss=$(echo 100 \* $sumi / $summe | /usr/bin/bc)
        fi
        if [ "$acci" != "0" -o "$acco" != "0" -o "$nulldata" = "Ja" ]; then
            if [ "$linecl" = "1" ]; then
                tablinecolor=$tablinecolor3
                linecl="2"
            else
                tablinecolor=$tablinecolor2
                linecl="1"
            fi
            echo '<tr><td bgcolor="'$tablinecolor'">'$acch'</td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphii'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acci / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="'$graphoo'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%">'$(echo scale=$nachkomma\; $acco / $anzeigewert | /usr/bin/bc)'</td></tr></table></td>'
            echo '<td bgcolor="'$tablinecolor'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphis'%"></td><td bgcolor="'$colorout'" width="'$graphos'%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $(echo $acci + $acco | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
        fi
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Summen</b></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumi / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorout'" width="100%"></td><td>&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $sumo / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td>'
    echo '<td bgcolor="'$tablinecolor1'"><table border="0" width="100%" cellspacing="0"><tr><td width="50%"><table border="0" width="100%" cellspacing="0"><tr><td bgcolor="'$colorin'" width="'$graphss'%">&nbsp;</td><td bgcolor="'$colorout'">&nbsp;</td></tr></table></td><td align="right" width="50%"><b>'$(echo scale=$nachkomma\; $summe / $anzeigewert | /usr/bin/bc)'</b></td></tr></table></td></tr>'
    echo '</table>'
    echo '<br>'
    allaccint_i="0"
    allaccint_o="0"
    set $ACCOUNTING_INT
    echo '<table border="0" width="100%" cellspacing="2">'
    linecl="2"
    while [ "$1" != "" ]
    do
        ACCOUNTING_INT_NR=$(grep "'$1'" $ACCOUNTING_DIR/index.acc | cut -d'_' -f3)
        eval ACCOUNTING_INT_NAME="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_NAME"
        eval wertin=\$inti$ACCOUNTING_INT_NR
        eval wertout=\$into$ACCOUNTING_INT_NR
        : ${wertin:=0}
        : ${wertout:=0}
        allaccint_i=$(echo $allaccint_i + $wertin | /usr/bin/bc)
        allaccint_o=$(echo $allaccint_o + $wertout | /usr/bin/bc)
        if [ "$linecl" = "1" ]; then
            tablinecolor=$tablinecolor3
            linecl="2"
        else
            tablinecolor=$tablinecolor2
            linecl="1"
        fi
        echo '<tr><td width="25%" bgcolor="'$tablinecolor'">Interface '$ACCOUNTING_INT_NAME'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $wertin / $anzeigewert | /usr/bin/bc)'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $wertout / $anzeigewert | /usr/bin/bc)'</td>'
        echo '<td align="right" width="25%" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $(echo $wertin + $wertout | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</td></tr>'
        shift 1
    done
    echo '<tr><td bgcolor="'$tablinecolor1'"><b>Differenz</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_i - $sumi | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_o - $sumo | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td>'
    echo '<td align="right" bgcolor="'$tablinecolor1'"><b>'$(echo scale=$nachkomma\; $(echo $allaccint_i + $allaccint_o - $sumi - $sumo | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr>'
    echo '</table>'
    echo '<br>'
    echo '<table border="0" width="100%" cellspacing="2">'
    echo -n '<tr><td width="25%" bgcolor="'$tablinecolor1'"><b>Interface</b></td>'
    echo -n '<td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>eingehende '$anzeige'</b></td>'
    echo -n '<td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>ausgehende '$anzeige'</b></td>'
    echo '<td align="right" width="25%" bgcolor="'$tablinecolor1'"><b>'$anzeige' Gesamt</b></td></tr>'
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval intn=\$intn$idx
        eval inti=\$inti$idx
        eval into=\$into$idx
        if [ "$inti" != "0" -o "$into" != "0" -o "$nulldata" = "Ja" ]; then
            if [ "$linecl" = "1" ]; then
                tablinecolor=$tablinecolor3
                linecl="2"
            else
                tablinecolor=$tablinecolor2
                linecl="1"
            fi
            echo -n '<tr><td bgcolor="'$tablinecolor'">'$intn'</td>'
            echo -n '<td align="right" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $inti / $anzeigewert | /usr/bin/bc)'</td>'
            echo -n '<td align="right" bgcolor="'$tablinecolor'">'$(echo scale=$nachkomma\; $into / $anzeigewert | /usr/bin/bc)'</td>'
            echo '<td align="right" bgcolor="'$tablinecolor'"><b>'$(echo scale=$nachkomma\; $(echo $inti + $into | /usr/bin/bc) / $anzeigewert | /usr/bin/bc)'</b></td></tr>'
        fi
    done
    echo '</table>'
    echo '<br><a href="'$myname'"><b>zur&uuml;ck zur &Uuml;bersicht</b></a>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# accounting.sh aufrufen
#------------------------------------------------------------------------------
if [ "$FORM_action" = "aktualisieren" ]; then
    show_tab_header "Datenaktualisierung" no
    echo '<b><pre>'
    /usr/local/bin/accounting.sh BROWSER
    echo '</pre></b>'
    echo '<br><a href="'$myname'"><b>zur&uuml;ck zur &Uuml;bersicht</b></a>'
    show_tab_footer
fi

#------------------------------------------------------------------------------
# Anzeigeeinstellungen ndern
#------------------------------------------------------------------------------
if [ "$FORM_action" = "conf" ]; then
    show_tab_header "Anzeigeeinstellungen" no
    [ $FORM_anzeige = "Byte" ] && anzeigewert="1"
    [ $FORM_anzeige = "KiloByte" ] && anzeigewert="1024"
    [ $FORM_anzeige = "MegaByte" ] && anzeigewert="1048576"
    [ $FORM_anzeige = "GigaByte" ] && anzeigewert="1073741824"
    {
    echo 'anzeigwert '$anzeigewert
    echo 'anzeige '$FORM_anzeige
    echo 'nachkomma '$FORM_nachkomma
    echo 'nulldata '$FORM_nulldata
    } > $ACCOUNTING_DIR/view.conf
    echo 'Anzeigeeinstellungen ge&auml;ndert<br>'
    echo '<br><a href="'$myname'"><b>zur&uuml;ck zur &Uuml;bersicht</b></a>'
    show_tab_footer
fi

show_html_footer

