#! /bin/sh
#------------------------------------------------------------------------------
# /opt/files/usr/local/bin/accounting.sh
# see documentation for licence
#
# Creation:     05.06.2002  Michael Knipping <fli4l@knibo.de>
# Last Update:  09.12.2005  Michael Knipping <fli4l@knibo.de>
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Config Datei einlesen, Abbruch wenn diese nicht existiert
#------------------------------------------------------------------------------
if [ -f "/etc/accounting.conf" ]; then
    . /etc/accounting.conf
else
    echo "/etc/accounting.conf not found"
    exit 1
fi

#------------------------------------------------------------------------------
# prfen ob accounting.sh / acccal.sh schon luft
#------------------------------------------------------------------------------
LOCKFILE=$workdir/accounting.pid
myname=`basename $0`
if [ -f "$LOCKFILE" ]; then
    echo -n "`cat $LOCKFILE | cut -d" " -f1` is running and working with your "
    echo "data (PID: `cat $LOCKFILE | cut -d" " -f2`)."
    echo "Please wait and try again."
    exit 1
fi
echo $myname $$ > $LOCKFILE                    # --- LOCK-Datei erzeugen

#------------------------------------------------------------------------------
# Variablen setzen & Monatsdatei einlesen
#------------------------------------------------------------------------------
monat=$(date +%m)
day=$(date +%d)
tag=$(date +%Y-%m-%d)
jahr=$(date +%Y)
eval outfile=\'$ACCOUNTING_DIR/$jahr/$jahr-$monat.acc.tmp\'
eval datafile=\'$ACCOUNTING_DIR/$jahr/$jahr-$monat.acc\'
[ -f "$datafile" ] && . $datafile

#------------------------------------------------------------------------------
# Verzeichnisse erzeugen
#------------------------------------------------------------------------------
mkdir -p $ACCOUNTING_DIR
mkdir -p $ACCOUNTING_DIR/$jahr

#------------------------------------------------------------------------------
# Daten auslesen
#------------------------------------------------------------------------------
/sbin/iptables -L accin -v -x|grep 'RETURN' >$workdir/accin.tmp
/sbin/iptables -Z accin
/sbin/iptables -L accout -v -x|grep 'RETURN' >$workdir/accout.tmp
/sbin/iptables -Z accout

cat /proc/net/dev | grep ':' > $workdir/int.tmp

count=1
while read line
do
    set $line
    if [ $9 != "anywhere" ]; then
        eval "acci$count"=$2
        eval "acch$count"=$9
        count=`expr $count + 1`
    fi
done < $workdir/accin.tmp
count=1
while read line
do
    set $line
    if [ $8 != "anywhere" ]; then
        eval "acco$count"=$2
        count=`expr $count + 1`
    fi
done < $workdir/accout.tmp
count=`expr $count - 1`

#------------------------------------------------------------------------------
# Index anlegen / aktualisieren
#------------------------------------------------------------------------------
echo "aktualisiere Index"
ACCOUNTING_HOST_n=0
ACCOUNTING_INT_n=0
[ -f "$ACCOUNTING_DIR/index.acc" ] && . $ACCOUNTING_DIR/index.acc
indexchange=0
[ 0$count -eq 0 ] || for idx in `seq 1 $count`
do
    eval acch=\$acch$idx
    if [ $(grep "'$acch'" $ACCOUNTING_DIR/index.acc >/dev/null 2>/dev/null; echo $?) != 0 ]; then
        ACCOUNTING_HOST_n=`expr $ACCOUNTING_HOST_n + 1`
        eval "ACCOUNTING_HOST_"$ACCOUNTING_HOST_n"_NAME"=$acch
        indexchange=1
    fi
done
while read line
do
    intn=$(echo $line | cut -d':' -f1)
    if [ $(grep "'$intn'" $ACCOUNTING_DIR/index.acc >/dev/null 2>/dev/null; echo $?) != 0 ]; then
        ACCOUNTING_INT_n=`expr $ACCOUNTING_INT_n + 1`
        eval "ACCOUNTING_INT_"$ACCOUNTING_INT_n"_NAME"=$intn
        indexchange=1
    fi
done < $workdir/int.tmp
if [ $indexchange != 0 ]; then
    echo "ACCOUNTING_HOST_n='"$ACCOUNTING_HOST_n"'" > $ACCOUNTING_DIR/index.acc
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
        echo "ACCOUNTING_HOST_"$idx"_NAME='"$acch"'" >> $ACCOUNTING_DIR/index.acc
    done
    echo "ACCOUNTING_INT_n='"$ACCOUNTING_INT_n"'" >> $ACCOUNTING_DIR/index.acc
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval accint="\$ACCOUNTING_INT_"$idx"_NAME"
        echo "ACCOUNTING_INT_"$idx"_NAME='"$accint"'" >> $ACCOUNTING_DIR/index.acc
    done
fi

#------------------------------------------------------------------------------
# Hostdaten anlegen / aktualisieren
#------------------------------------------------------------------------------
echo "aktualisiere Hostdaten"
eval monthi="\$ACCOUNTING_Y"$jahr"_M"$monat"_i"
eval montho="\$ACCOUNTING_Y"$jahr"_M"$monat"_o"
: ${monthi:=0}
: ${montho:=0}
[ 0$count -eq 0 ] || for idx in `seq 1 $count`
do
    eval acch=\$acch$idx
    eval acci=\$acci$idx
    eval acco=\$acco$idx
    ACCOUNTING_HOST_NR=$(grep "'$acch'" $ACCOUNTING_DIR/index.acc | cut -d'_' -f3)
    eval dayhosti="\$ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_D"$day"_i"
    eval dayhosto="\$ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_D"$day"_o"
    eval monthhosti="\$ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_i"
    eval monthhosto="\$ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_o"
    [ $dayhosti ] && dayhosti=$(echo $dayhosti + $acci | /usr/bin/bc) || dayhosti=$acci
    [ $dayhosto ] && dayhosto=$(echo $dayhosto + $acco | /usr/bin/bc) || dayhosto=$acco
    [ $monthhosti ] && monthhosti=$(echo $monthhosti + $acci | /usr/bin/bc) || monthhosti=$acci
    [ $monthhosto ] && monthhosto=$(echo $monthhosto + $acco | /usr/bin/bc) || monthhosto=$acco
    monthi=$(echo $monthi + $acci | /usr/bin/bc)
    montho=$(echo $montho + $acco | /usr/bin/bc)
    eval "ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_D"$day"_i"=$dayhosti
    eval "ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_D"$day"_o"=$dayhosto
    eval "ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_i"=$monthhosti
    eval "ACCOUNTING_HOST_"$ACCOUNTING_HOST_NR"_Y"$jahr"_M"$monat"_o"=$monthhosto
done
eval "ACCOUNTING_Y"$jahr"_M"$monat"_i"=$monthi
eval "ACCOUNTING_Y"$jahr"_M"$monat"_o"=$montho

#------------------------------------------------------------------------------
# Interfacedaten anlegen / aktualisieren
#------------------------------------------------------------------------------
echo "aktualisiere Interfacedaten"
[ -f "$workdir/last.int" ] && mv $workdir/last.int $workdir/last.int.tmp
while read line
do
    intname=$(echo $line | cut -d':' -f1)
    set $(echo $line | cut -d':' -f2)
    intin=$1
    intout=$9
    if [ -f "$workdir/last.int.tmp" ]; then
        set $(cat $workdir/last.int.tmp | grep "'$intname'")
        lastin=$2
        lastout=$3
    else
        lastin=0
        lastout=0
    fi
    if [ $(echo "$intin < $lastin" | /usr/bin/bc) -eq 1 ]; then
        if [ "$ACCOUNTING_MAXINT" != "" -a "$ACCOUNTING_MAXINT" != "0" ]
        then newinti=$(echo $intin + $ACCOUNTING_MAXINT - $lastin | /usr/bin/bc)
        else newinti=$intin
        fi
    else
        newinti=$(echo $intin - $lastin | /usr/bin/bc)
    fi
    if [ $(echo "$intout < $lastout" | /usr/bin/bc) -eq 1 ]; then
        if [ "$ACCOUNTING_MAXINT" != "" -a "$ACCOUNTING_MAXINT" != "0" ]
        then newinto=$(echo $intout + $ACCOUNTING_MAXINT - $lastout | /usr/bin/bc)
        else newinto=$intout
        fi
    else
        newinto=$(echo $intout - $lastout | /usr/bin/bc)
    fi
    echo "'"$intname"'" $intin $intout >> $workdir/last.int
    ACCOUNTING_INT_NR=$(grep "'$intname'" $ACCOUNTING_DIR/index.acc | cut -d'_' -f3)
    eval dayinti="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_D"$day"_i"
    eval dayinto="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_D"$day"_o"
    eval monthinti="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_i"
    eval monthinto="\$ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_o"
    [ $dayinti ] && dayinti=$(echo $dayinti + $newinti | /usr/bin/bc) || dayinti=$newinti
    [ $dayinto ] && dayinto=$(echo $dayinto + $newinto | /usr/bin/bc) || dayinto=$newinto
    [ $monthinti ] && monthinti=$(echo $monthinti + $newinti | /usr/bin/bc) || monthinti=$newinti
    [ $monthinto ] && monthinto=$(echo $monthinto + $newinto | /usr/bin/bc) || monthinto=$newinto
    eval "ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_D"$day"_i"=$dayinti
    eval "ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_D"$day"_o"=$dayinto
    eval "ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_i"=$monthinti
    eval "ACCOUNTING_INT_"$ACCOUNTING_INT_NR"_Y"$jahr"_M"$monat"_o"=$monthinto
    [ "$ACCOUNTING_DEBUG_INT" = "yes" ] && echo $tag $intname': '$intin $intout'  last: '$lastin $lastout'  new: '$newinti $newinto >>$ACCOUNTING_DIR/int.log
done < $workdir/int.tmp

#------------------------------------------------------------------------------
# Daten in Datei scheiben
#------------------------------------------------------------------------------
echo "schreibe Daten"
{
    echo "#------------------------------------------------------------------------------"
    echo "# Accounting data $jahr $monat"
    echo "# Creation: $tag  OPT_ACCOUNTING_"$ACCOUNTING_VERSION
    echo "#------------------------------------------------------------------------------"
} > $outfile
echo "ACCOUNTING_HOST_Y"$jahr"_M"$monat"_n='"$ACCOUNTING_HOST_n"'" >> $outfile
[ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
do
    eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
    echo "ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_NAME='"$acch"'" >> $outfile
done
[ -f $datafile ] && sed -n -e '/_D'$day'_/d' -e '/_HOST_.*_D[0-3][0-9]_/p' $datafile >> $outfile
[ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
do
    eval dayhosti="\$ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_D"$day"_i"
    eval dayhosto="\$ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_D"$day"_o"
    [ "$dayhosti" != "" -a "$dayhosti" != "0" ] && echo "ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_D"$day"_i='"$dayhosti"'" >> $outfile
    [ "$dayhosto" != "" -a "$dayhosto" != "0" ] && echo "ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_D"$day"_o='"$dayhosto"'" >> $outfile
done
[ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
do
    eval monthhosti="\$ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_i"
    eval monthhosto="\$ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_o"
    [ "$monthhosti" != "" -a "$monthhosti" != "0" ] && echo "ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_i='"$monthhosti"'" >> $outfile
    [ "$monthhosto" != "" -a "$monthhosto" != "0" ] && echo "ACCOUNTING_HOST_"$idx"_Y"$jahr"_M"$monat"_o='"$monthhosto"'" >> $outfile
done
eval monthi="\$ACCOUNTING_Y"$jahr"_M"$monat"_i"
eval montho="\$ACCOUNTING_Y"$jahr"_M"$monat"_o"
echo "ACCOUNTING_Y"$jahr"_M"$monat"_i='"$monthi"'" >> $outfile
echo "ACCOUNTING_Y"$jahr"_M"$monat"_o='"$montho"'" >> $outfile
echo "ACCOUNTING_INT_Y"$jahr"_M"$monat"_n='"$ACCOUNTING_INT_n"'" >> $outfile
[ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
do
    eval intn="\$ACCOUNTING_INT_"$idx"_NAME"
    echo "ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_NAME='"$intn"'" >> $outfile
done
[ -f $datafile ] && sed -n -e '/_D'$day'_/d' -e '/_INT_.*_D[0-3][0-9]_/p' $datafile >> $outfile
[ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
do
    eval dayinti="\$ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_D"$day"_i"
    eval dayinto="\$ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_D"$day"_o"
    [ "$dayinti" != "" -a "$dayinti" != "0" ] && echo "ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_D"$day"_i='"$dayinti"'" >> $outfile
    [ "$dayinto" != "" -a "$dayinto" != "0" ] && echo "ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_D"$day"_o='"$dayinto"'" >> $outfile
done
[ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
do
    eval monthinti="\$ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_i"
    eval monthinto="\$ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_o"
    [ "$monthinti" != "" -a "$monthinti" != "0" ] && echo "ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_i='"$monthinti"'" >> $outfile
    [ "$monthinto" != "" -a "$monthinto" != "0" ] && echo "ACCOUNTING_INT_"$idx"_Y"$jahr"_M"$monat"_o='"$monthinto"'" >> $outfile
done
echo "ACCOUNTING_Y"$jahr"_M"$monat"_DAYS='"$day"'" >> $outfile
mv $outfile $datafile
echo "Fertig"

#------------------------------------------------------------------------------
# Aufrumen
#------------------------------------------------------------------------------
rm -f $workdir/accin.tmp
rm -f $workdir/accout.tmp
rm -f $workdir/int.tmp
rm -f $workdir/$tag.acc
rm -f $workdir/$tag.int
rm -f $workdir/last.int.tmp
rm -f $workdir/last.int.tmp
rm -f $LOCKFILE 2>/dev/null       # --- LOCK-Datei wieder entfernen
