#!/bin/sh
#------------------------------------------------------------------------------
# /opt/files/usr/local/htdocs/acccal.sh - calculate accounting-data
# see documentation for licence
#
# Creation:     13.10.2004  Michael Knipping <fli4l@knibo.de>
# Last Update:  09.12.2005  Michael Knipping <fli4l@knibo.de>
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Config Datei einlesen, Abbruch wenn diese nicht existiert
#------------------------------------------------------------------------------
if [ -f "/etc/accounting.conf" ]; then
    . /etc/accounting.conf
else
    echo "/etc/accounting.conf not found"
    exit 1
fi

#------------------------------------------------------------------------------
# prfen ob accounting.sh / acccal.sh schon luft
#------------------------------------------------------------------------------
LOCKFILE=$workdir/accounting.pid
myname=`basename $0`
if [ -f "$LOCKFILE" ]; then
    echo -n "`cat $LOCKFILE | cut -d" " -f1` is running and working with your "
    echo "data (PID: `cat $LOCKFILE | cut -d" " -f2`)."
    echo "Please wait and try again."
    exit 1
fi
echo $myname $$ > $LOCKFILE                    # --- LOCK-Datei erzeugen

#------------------------------------------------------------------------------
# Syntaxcheck
#------------------------------------------------------------------------------
if ! echo "$1" | grep -q "^[0-9][0-9][0-9][0-9]$" || ! echo "$2" | grep -q "^[0-1][0-9]$"; then
    echo 'usage:'
    echo '  acccal.sh yyyy mm [-r]'
    rm -f $LOCKFILE 2>/dev/null       # --- LOCK-Datei wieder entfernen
    exit 1
fi

#------------------------------------------------------------------------------
# erstellen der Tagesdateien aus der Monatsdatei
#------------------------------------------------------------------------------
if [ "$3" = "-r" ]; then
    jahr=$1
    monat=$2
    if [ -f $ACCOUNTING_DIR/$jahr/$jahr-$monat.acc ]; then
        . $ACCOUNTING_DIR/$jahr/$jahr-$monat.acc
    else
        echo "$ACCOUNTING_DIR/$jahr/$jahr-$monat.acc not found"
        rm -f $LOCKFILE 2>/dev/null       # --- LOCK-Datei wieder entfernen
        exit 1
    fi
    mkdir -p $ACCOUNTING_DIR/$jahr/$monat
    eval day="\$ACCOUNTING_Y"$jahr"_M"$monat"_DAYS"
    for idx in `seq 1 $day`
    do
        [ "$idx" -le "9" ] && idx="0$idx"
        eval outfile="\$ACCOUNTING_DIR/"$jahr"/"$monat"/"$jahr"-"$monat"-"$idx".acc"
        eval acc_host_n="\$ACCOUNTING_HOST_Y"$jahr"_M"$monat"_n"
        [ 0$acc_host_n -eq 0 ] || for idx2 in `seq 1 $acc_host_n`
        do
            eval acch="\$ACCOUNTING_HOST_"$idx2"_Y"$jahr"_M"$monat"_NAME"
            eval dayhosti="\$ACCOUNTING_HOST_"$idx2"_Y"$jahr"_M"$monat"_D"$idx"_i"
            eval dayhosto="\$ACCOUNTING_HOST_"$idx2"_Y"$jahr"_M"$monat"_D"$idx"_o"
            : ${dayhosti:=0}
            : ${dayhosto:=0}
            echo $acch $dayhosti $dayhosto >> $outfile
        done
        echo -n "."
    done
    echo
    for idx in `seq 1 $day`
    do
        [ "$idx" -le "9" ] && idx="0$idx"
        eval outfile="\$ACCOUNTING_DIR/"$jahr"/"$monat"/"$jahr"-"$monat"-"$idx".int"
        eval acc_int_n="\$ACCOUNTING_INT_Y"$jahr"_M"$monat"_n"
        [ 0$acc_int_n -eq 0 ] || for idx2 in `seq 1 $acc_int_n`
        do
            eval intn="\$ACCOUNTING_INT_"$idx2"_Y"$jahr"_M"$monat"_NAME"
            eval dayinti="\$ACCOUNTING_INT_"$idx2"_Y"$jahr"_M"$monat"_D"$idx"_i"
            eval dayinto="\$ACCOUNTING_INT_"$idx2"_Y"$jahr"_M"$monat"_D"$idx"_o"
            : ${dayinti:=0}
            : ${dayinto:=0}
            echo $intn $dayinti $dayinto >> $outfile
        done
        echo -n "."
    done
    echo
    rm -f $LOCKFILE 2>/dev/null       # --- LOCK-Datei wieder entfernen
    exit
fi

#------------------------------------------------------------------------------
# Beenden wenn keine Tagesdateien vorhanden
#------------------------------------------------------------------------------
monthdir="$ACCOUNTING_DIR/$1/$2"
if [ "x$(ls "$monthdir"/*.acc 2>/dev/null)" = "x" ]; then
    echo "$monthdir no exist or no acc-files there!"
    rm -f $LOCKFILE 2>/dev/null       # --- LOCK-Datei wieder entfernen
    exit 1
fi

#------------------------------------------------------------------------------
# Backup einer vorhandenen Monatsdatei
#------------------------------------------------------------------------------
eval outfile=\'$ACCOUNTING_DIR/$1/$1-$2.acc\'
if [ -f $outfile ]; then
    echo "$outfile exist, move to"
    echo "$outfile.bak"
    mv $outfile $outfile.bak
fi

#------------------------------------------------------------------------------
# erstellen der Monatsdatei aus den Tagesdateien
#------------------------------------------------------------------------------
{
    echo "#------------------------------------------------------------------------------"
    echo "# Accounting data "$1 $2
    echo "# Creation: $(date +%Y-%m-%d)  OPT_ACCOUNTING_"$ACCOUNTING_VERSION
    echo "#------------------------------------------------------------------------------"
} > $outfile
FORM_yy=$1
FORM_mm=$2

#------------------------------------------------------------------------------
# Hostdatei anlegen
#------------------------------------------------------------------------------
if [ ! -f "$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts" ]; then
    echo -n "erstelle Hostdatei      "
    for dd in $(ls $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm-*.acc)
    do
        count=1
        while read line
        do
            set $line
            acch=$1
            if [ $(grep $acch $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts >/dev/null 2>/dev/null; echo $?) != 0 ]; then
                echo $acch >> $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts
            else
                set $(grep $acch $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts)
                hostexist="0"
                while [ "$1" != "" ]
                do
                    [ "$1" = "$acch" ] && hostexist="1"; break
                    shift 1
                done
                [ "$hostexist" = "0" ] && echo $acch >> $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts
            fi
            count=`expr $count + 1`
        done < $dd
    echo -n "."
    done
    echo " "
fi

#------------------------------------------------------------------------------
# Interfacedatei anlegen
#------------------------------------------------------------------------------
if [ ! -f "$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int" ]; then
    if [ $(ls $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm-*.int >/dev/null 2>/dev/null; echo $?) = 0 ]; then
        echo -n "erstelle Interfacedatei "
        for dd in $(ls $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm-*.int)
        do
            count=1
            while read line
            do
                set $line
                intn=$1
                if [ $(grep $intn $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int >/dev/null 2>/dev/null; echo $?) != 0 ]; then
                    echo $intn >> $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int
                else
                    set $(grep $intn $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int)
                    intexist="0"
                    while [ "$1" != "" ]
                    do
                        [ "$1" = "$intn" ] && intexist="1"; break
                        shift 1
                    done
                    [ "$intexist" = "0" ] && echo $intn >> $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int
                fi
                count=`expr $count + 1`
            done < $dd
        echo -n "."
        done
        echo " "
    fi
fi

#------------------------------------------------------------------------------
# Index erstellen / aktualisieren
#------------------------------------------------------------------------------
if [ -f "$ACCOUNTING_DIR/index.acc" ]; then
    echo -n "aktualisiere Index      "
    . $ACCOUNTING_DIR/index.acc
    indexchange=0
    allhosts=`cat $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts`
    set $allhosts
    count=1
    while [ "$1" != "" ]
    do
        if [ $(grep "'$1'" $ACCOUNTING_DIR/index.acc >/dev/null 2>/dev/null; echo $?) != 0 ]; then
            ACCOUNTING_HOST_n=`expr $ACCOUNTING_HOST_n + 1`
            eval "ACCOUNTING_HOST_"$ACCOUNTING_HOST_n"_NAME"=$1
            indexchange=1
            echo -n "."
        fi
        shift 1
    done
    if [ -f "$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int" ]; then
        : ${ACCOUNTING_INT_n:=0}
        allint=`cat $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int`
        set $allint
        count=1
        while [ "$1" != "" ]
        do
            if [ $(grep "'$1'" $ACCOUNTING_DIR/index.acc >/dev/null 2>/dev/null; echo $?) != 0 ]; then
                ACCOUNTING_INT_n=`expr $ACCOUNTING_INT_n + 1`
                eval "ACCOUNTING_INT_"$ACCOUNTING_INT_n"_NAME"=$1
                indexchange=1
                echo -n "."
            fi
            shift 1
        done
    fi
    if [ $indexchange != 0 ]; then
        echo "ACCOUNTING_HOST_n='"$ACCOUNTING_HOST_n"'" > $ACCOUNTING_DIR/index.acc
        [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
        do
            eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
            echo "ACCOUNTING_HOST_"$idx"_NAME='"$acch"'" >> $ACCOUNTING_DIR/index.acc
        done
        echo "ACCOUNTING_INT_n='"$ACCOUNTING_INT_n"'" >> $ACCOUNTING_DIR/index.acc
        [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
        do
            eval accint="\$ACCOUNTING_INT_"$idx"_NAME"
            echo "ACCOUNTING_INT_"$idx"_NAME='"$accint"'" >> $ACCOUNTING_DIR/index.acc
        done
    fi
else
    echo -n "erstelle Index          "
    allhosts=`cat $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.hosts`
    set $allhosts
    count=1
    while [ "$1" != "" ]
    do
        eval "ACCOUNTING_HOST_"$count"_NAME"=$1
        count=`expr $count + 1`
        shift 1
    done
    ACCOUNTING_HOST_n=`expr $count - 1`
    echo "ACCOUNTING_HOST_n='"$ACCOUNTING_HOST_n"'" > $ACCOUNTING_DIR/index.acc
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
        echo "ACCOUNTING_HOST_"$idx"_NAME='"$acch"'" >> $ACCOUNTING_DIR/index.acc
        echo -n "."
    done
    if [ -f "$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int" ]; then
        allint=`cat $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int`
        set $allint
        count=1
        while [ "$1" != "" ]
        do
            eval "ACCOUNTING_INT_"$count"_NAME"=$1
            count=`expr $count + 1`
            shift 1
        done
        ACCOUNTING_INT_n=`expr $count - 1`
        echo "ACCOUNTING_INT_n='"$ACCOUNTING_INT_n"'" >> $ACCOUNTING_DIR/index.acc
        [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
        do
            eval accint="\$ACCOUNTING_INT_"$idx"_NAME"
            echo "ACCOUNTING_INT_"$idx"_NAME='"$accint"'" >> $ACCOUNTING_DIR/index.acc
            echo -n "."
        done
    fi
fi
echo " "

#------------------------------------------------------------------------------
# Hostdaten berechnen / schreiben
#------------------------------------------------------------------------------
echo -n "schreibe Monatsdaten    "
echo "ACCOUNTING_HOST_Y"$FORM_yy"_M"$FORM_mm"_n='"$ACCOUNTING_HOST_n"'" >> $outfile
[ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
do
    eval acch="\$ACCOUNTING_HOST_"$idx"_NAME"
    eval acch$idx=$acch
    eval acci$idx=0
    eval acco$idx=0
    echo "ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_NAME='"$acch"'" >> $outfile
done
for D in $(cd $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/; ls $FORM_yy-$FORM_mm-??.acc | cut -d"." -f1 | cut -d"-" -f3)
do
    dd="$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm-$D.acc"
    [ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
    do
        eval acch=\$acch$idx
        if [ $(grep $acch $dd >/dev/null 2>/dev/null; echo $?) = 0 ]; then
            set $(grep $acch $dd)
            while [ "$1" != "" ]
            do
                [ "$1" = "$acch" ] && break
                shift 1
            done
            if [ "$2" != "" -a "$2" != "0" ]; then
                eval acci=\$acci$idx
                neui=$(echo $2 + $acci | /usr/bin/bc)
                eval acci$idx=$neui
                echo "ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$D"_i='"$2"'" >> $outfile
            fi
            if [ "$3" != "" -a "$3" != "0" ]; then
                eval acco=\$acco$idx
                neuo=$(echo $3 + $acco | /usr/bin/bc)
                eval acco$idx=$neuo
                echo "ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$D"_o='"$3"'" >> $outfile
            fi
        fi
    done
    echo -n "."
done
echo " "
sumi=0
sumo=0
[ 0$ACCOUNTING_HOST_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_HOST_n`
do
    eval acci=\$acci$idx
    eval acco=\$acco$idx
    [ "$acci" != "0" ] && echo "ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_i='"$acci"'" >> $outfile
    [ "$acco" != "0" ] && echo "ACCOUNTING_HOST_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_o='"$acco"'" >> $outfile
    sumi=$(echo $sumi + $acci | /usr/bin/bc)
    sumo=$(echo $sumo + $acco | /usr/bin/bc)
done
echo "ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_i='"$sumi"'" >> $outfile
echo "ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_o='"$sumo"'" >> $outfile

#------------------------------------------------------------------------------
# Interfacedaten berechnen / schreiben
#------------------------------------------------------------------------------
if [ -f "$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm.int" ]; then
    echo -n "schreibe Interfacedaten "
    echo "ACCOUNTING_INT_Y"$FORM_yy"_M"$FORM_mm"_n='"$ACCOUNTING_INT_n"'" >> $outfile
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval accint="\$ACCOUNTING_INT_"$idx"_NAME"
        eval intn$idx=$accint
        eval inti$idx=0
        eval into$idx=0
        echo "ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_NAME='"$accint"'" >> $outfile
    done
    for D in $(cd $ACCOUNTING_DIR/$FORM_yy/$FORM_mm/; ls $FORM_yy-$FORM_mm-??.int | cut -d"." -f1 | cut -d"-" -f3)
    do
        dd="$ACCOUNTING_DIR/$FORM_yy/$FORM_mm/$FORM_yy-$FORM_mm-$D.int"
        [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
        do
            eval intn=\$intn$idx
            if [ $(grep $intn $dd >/dev/null 2>/dev/null; echo $?) = 0 ]; then
                set $(grep $intn $dd)
                while [ "$1" != "" ]
                do
                    [ "$1" = "$intn" ] && break
                    shift 1
                done
                if [ "$2" != "" -a "$2" != "0" ]; then
                    eval inti=\$inti$idx
                    neui=$(echo $2 + $inti | /usr/bin/bc)
                    eval inti$idx=$neui
                    echo "ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$D"_i='"$2"'" >> $outfile
                fi
                if [ "$3" != "" -a "$3" != "0" ]; then
                    eval into=\$into$idx
                    neuo=$(echo $3 + $into | /usr/bin/bc)
                    eval into$idx=$neuo
                    echo "ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_D"$D"_o='"$3"'" >> $outfile
                fi
            fi
        done
        echo -n "."
    done
    echo " "
    sumi=0
    sumo=0
    [ 0$ACCOUNTING_INT_n -eq 0 ] || for idx in `seq 1 $ACCOUNTING_INT_n`
    do
        eval inti=\$inti$idx
        eval into=\$into$idx
        [ "$inti" != "0" ] && echo "ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_i='"$inti"'" >> $outfile
        [ "$into" != "0" ] && echo "ACCOUNTING_INT_"$idx"_Y"$FORM_yy"_M"$FORM_mm"_o='"$into"'" >> $outfile
    done
fi
echo "ACCOUNTING_Y"$FORM_yy"_M"$FORM_mm"_DAYS='"$D"'" >> $outfile

rm -f $LOCKFILE 2>/dev/null       # --- LOCK-Datei wieder entfernen
