#!/bin/sh
#------------------------------------------------------------------------------
# main_lmsensors.cgi - show hardware sensor information                v 2.1.12
#                                                                         v 0.6
# Creation:     03.03.2005  gero
# Last Update:  27.11.2005  BGehl
#
#------------------------------------------------------------------------------

# Vaiables
FORM_action="view"
RTIME=60

# get main helper functions
. /srv/www/include/cgi-helper

# Security
check_rights "info" "$FORM_action"

# Check if imond is running
if [ ! -d /proc/sys/dev/sensors -o ! -f /usr/bin/sensors ]
then
    show_html_header "lm_sensors"
    show_error "lm_sensors - Error" "lm_sensors not running or /usr/bin/sensors missing."
    show_html_footer
    exit 1
fi

# HTML-Body

show_html_header "lm_sensors" "refresh=$RTIME;url=$myname;showmenu=yes"

show_tab_header "Hardware Sensor Status" "no"
echo "<p align=\"right\"> Last update: `date -R`</p>"
echo "<p><font size=3><pre>"

/usr/bin/sensors | sed 's/[°]/\&deg;/g'
  #| sed 's/.$/<br>/g'   CR ersetzen

echo "</pre></font></p>"
echo "<p align=\"center\"><br><small>Diese Seite erneuert sich automatisch alle $RTIME Sekunden.</small></p>"
show_tab_footer

show_html_footer