#!/bin/sh
#------------------------------------------------------------------------------
# cgiconfig
# Last Update:  28.11.2005  hh <hh at fli4l dot de>
#------------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper
. /var/run/cgiconfig2.conf

read_hosts ()
{ # write hosts in file: /tmp/cgiconfig2.hosts
    #read local hosts, ips and hostname from /boot/rc.cfg to tempfile
    > /tmp/cgiconfig2.hosts
    while read line
    do
        # don't show hostnamess for every interface
        case $line in 
            "# hostnames"*) break ;;
        esac
        # skip commentary
        case $line in 
            "#"*|*localhost*) continue ;;
        esac
        set -- $line
        echo "$1 $2" >> /tmp/cgiconfig2.hosts
    done < /etc/hosts
    
    case $leasefile in
        "") ;;
        *)
            set -f
            while read line
            do
                set -- $line
                # only add new hosts
                grep -q "^$3 " /tmp/cgiconfig2.hosts || echo $3 $4 >> /tmp/cgiconfig2.hosts
            done < $leasefile
            set +f
    ;;
    esac
    # sort hosts by IP
    sed -e "s/\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)/00\1.00\2.00\3.00\4~\1.\2.\3.\4/" \
        -e "s/0\{0,2\}\([0-9]\{3\}\.\)0\{0,2\}\([0-9]\{3\}\.\)0\{0,2\}\([0-9]\{3\}\.\)0\{0,2\}\([0-9]\{3\}\)/\1\2\3\4/" \
        /tmp/cgiconfig2.hosts | sort -n | cut  -d~ -f2- > /tmp/cgiconfig2.hosts
}

# Security
: ${FORM_action:="hosts"}
case $FORM_action in
    hosts|inp|fwrd) sec_action="view" ;;
    *) sec_action="set" ;;
esac
check_rights "cgiconfig2" "$sec_action"

read wanip < /var/run/cgiconfig2_ip
refr=300
version=v1.0c

_hosts="hosts"
_inp="input"
_fwrd="portforwarding"
_readme="Hilfe"
_inp_new="Erstellen"
_ping_all="alle anpingen"
_add_comment="Kommentar hinzufgen"
_del_comment="Kommentar entfernen"
_add_rule="hinzufgen"

case $FORM_action in
    hosts|inp|fwrd)
        show_html_header "OPT_CGICONFIG2 $version" "refresh=$refr;url=$myname?action=$FORM_action&app=$FORM_app"
        show_tab_header "$_hosts" "$myname?action=hosts" "$_inp" "$myname?action=inp" \
                        "$_fwrd" "$myname?action=fwrd" "$_readme" cgiconfig2.html
    html=yes
    ;;
esac

###############################
#          HOSTS            #
###############################
# show Hosts
case $FORM_action in
    hosts)
        read_hosts
        echo "<table class=\"normtable\">
        <tr>
        <th>ip</th>
        <th>host</th>
        <th>online state</th>
        <th>blocking state</th>
        </tr>"
        
        while read ip name
        do
            case $ip$name in
            "") ;;
            *)
                set -f
                set -- `grep "$ip " /proc/net/arp`
                set +f
                adress="$1" ; hwtype="$2" ; hwadress="$4" ; flag="$3" ; iface="$6"
                echo "<tr><td title=\"$hwadress\">$ip</td><td>$name</td>"
                # online state
                case $name in
                    $HOSTNAME)
                        echo "<td><center><img src=../img/cgiconfig2_ongreen.gif border=0 title=\"Router\"></center></td>"
                    ;;
                    *)
                        if [ "$hwadress" = "00:00:00:00:00:00" ] || [ "$hwadress" = "" ] || [ "$flag" != "0x2" ]
                        then
                            echo "<td><center><a href=\"$myname?action=ping&amp;host=$ip\"><img src=../img/cgiconfig2_onred.gif border=0 title=\"ping $ip\"></a></center></td>"
                        else
                            echo "<td><center><a href=\"$myname?action=ping&amp;host=$ip\"><img src=../img/cgiconfig2_ongreen.gif border=0 title=\"ping $ip\"></a></center></td>"
                        fi
                    ;;
                esac
                # blocking state
                case $name in
                    $HOSTNAME)
                        echo "<td><center><img src=../img/cgiconfig2_ongreen.gif border=0 title=\"Router\"></center></td>"
                    ;;
                    *)
                        state_host=`iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "fw-drp-log"`
                        state_est=`iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "state RELATED,ESTABLISHED"`
                        
                        if [ "$state_host" = "" -a "$state_est" = "" ]
                        then
                            echo "<td><center><img src=../img/cgiconfig2_ongreen.gif border=0>
                            <a href=\"$myname?action=block&host=$ip\"><img src=../img/cgiconfig2_offred.gif border=0 title=\"block $ip\"></a>
                            </center></td>"
                        else
                            echo "<td><center><a href=\"$myname?action=unblock&host=$ip\">
                            <img src=../img/cgiconfig2_offgreen.gif border=0 title=\"remove blocking for $ip\"></a>
                            <img src=../img/cgiconfig2_onred.gif border=0></center></td>"
                        fi
                    ;;
                esac
                echo "</tr>"
            ;;
            esac
        done < /tmp/cgiconfig2.hosts
        cat <<EOF
<tr><td></td><td></td><td style="text-align: center">
<form name="ping" action="$myname" method="get">
<input type="hidden" name="host" value="all">
<input type="submit" name="action" value="$_ping_all">
</form></td><td></td></table>
EOF
;;
"$_ping_all")
    #echo "<pre>"
    while read ip
    do
        ping -c 1 $ip > /dev/null 2>&1 & 
    done < /tmp/cgiconfig2.hosts
    #echo "</pre>"
    sleep 10
    echo "Location: $myname"
    echo
;;
ping)
    ping -c 1 $FORM_host > /dev/null 2>&1
    echo "Location: $myname"
    echo
;;
block)
    state_host=`iptables -L FORWARD -n --line-numbers | grep "$FORM_host " | grep "fw-drp-log"`
    state_est=`iptables -L FORWARD -n --line-numbers | grep "$FORM_host " | grep "state RELATED,ESTABLISHED"`
    case $state_host$state_est in
    "")
        iptables -I FORWARD 1 -p all -s $FORM_host -m state --state ESTABLISHED,RELATED -j fw-drp-log
        iptables -I FORWARD 1 -p all -s $FORM_host -j fw-drp-log
    ;;
    esac
    echo "Location: $myname"
    echo
;;
unblock)
    state_host=`iptables -L FORWARD -n --line-numbers | grep "$FORM_host " | grep "fw-drp-log"`
    state_est=`iptables -L FORWARD -n --line-numbers | grep "$FORM_host " | grep "state RELATED,ESTABLISHED"`
    case $state_host$state_est in
    "") ;;
    *)
        num_fw=`iptables -L FORWARD -n --line-numbers | grep "$FORM_host " | grep -v "state RELATED,ESTABLISHED" | grep "fw-drp-log" | sed "s/[fw-].*//"`
        iptables -D FORWARD $num_fw
    
        num_est=`iptables -L FORWARD -n --line-numbers | grep "$FORM_host " | grep "state RELATED,ESTABLISHED" | sed "s/[fw-].*//"`
        iptables -D FORWARD $num_est
    ;;
    esac
    echo "Location: $myname"
    echo
;;

###############################
#          INPUT            #
###############################
#firewall input
inp)
    echo "<table class=\"normtable\">
     <tr>
      <th>protocol</th>
      <th>source port</th>
      <th>destination port</th>
      <th>action</th>
     </tr>"
    
        # Lese Anzahl der Eintrge in INPUT
    
        set -f
        num=""
        iptables -nL INPUT --line-numbers |
        while read line
        do
            set -- $line
            num=$1; target=$2; prot=$3; source=$5; dest=$6; sport=""; dport=""
            case $8 in 
                spt:*) sport=`echo $8|cut -d: -f2` ;;
                dpt:*) dport=`echo $8|cut -d: -f2` ;;
            esac
            case $9 in 
                spt:*) sport=`echo $9|cut -d: -f2` ;;
                dpt:*) dport=`echo $9|cut -d: -f2` ;;
            esac
            
            case $prot in
                all|icmp) ;;
                *)
                    case $target$source$dest in
                        "ACCEPT0.0.0.0/00.0.0.0/0")
                        cat <<EOF
<tr>
  <td>$prot</td>
  <td>$sport</td>
  <td>$dport</td>
  <td style="text-align: center"><a href="$myname?action=inp_rem&amp;idx=$num"><img src="../img/cgiconfig2_del.gif" border="0" title="delete rule $num"></a></td>
</tr>
EOF
                        echo "$num" > /tmp/count.$$
                        ;;
                    esac
                ;;
            esac
        done
        set +f
        num=`cat /tmp/count.$$`
        idxn=`expr $num + 1`
        rm /tmp/count.$$
        cat <<EOF
<tr>
  <td>
  <form name="create_inp" action="$myname" method="get">
  <select name="protocol">
    <option value="tcp">tcp</option>
    <option value="udp">udp</option>
  </select>
  </td>
  <td></td>
  <td><input type="text" name="port" size="8">
  <input type="hidden" name="idx" value=$idxn>
  </td>
  <td><input type="submit" name="action" value="$_inp_new"></td>
  </form>
</tr>
</table>
EOF
    ;;
"$_inp_new")
    iptables -I INPUT $FORM_idx -p $FORM_protocol --dport $FORM_port -m comment --comment "cgiconfig Rule $FORM_idx" -j ACCEPT
    echo "Location: $myname?action=inp"
    echo
;;

"inp_rem")
    iptables -D INPUT $FORM_idx
    echo "Location: $myname?action=inp"
    echo
;;
###############################
#         PORT  FORWARD            #
###############################

#forward-chain
fwrd)
cat <<EOF
<table class="normtable">
<tr>
<th>interface</th>
<th>target&nbsp;port<br>(or&nbsp;portrange)</th>
<th>new&nbsp;target&nbsp;ip</th>
<th>new&nbsp;target&nbsp;port<br>(or&nbsp;portrange)</th>
<th>protocol</th>
<th>rule&nbsp;action</th>
<th>comment</th>
<th>add/del&nbsp;comment</th>
</tr>
EOF

[ -f /etc/portfw.conf ] || > /etc/portfw.conf

while read line
do
    fw_iface="`echo $line | cut -d" " -f1`"
    fw_sourcep="`echo $line | cut -d" " -f2`"
    fw_ip="`echo $line | cut -d" " -f3`"
    fw_destp="`echo $line | cut -d" " -f4`"
    fw_proto="`echo $line | cut -d" " -f5`"

    cat <<EOF
<tr><td>$fw_iface</td>
<td>$fw_sourcep</td>
  <td>$fw_ip</td>
  <td>$fw_destp</td>
  <td>$fw_proto</td>
  <td><center>
  <a href="$myname?action=del_fwrd&sport=$fw_sourcep&ip=$fw_ip&dport=$fw_destp&proto=$fw_proto">
  <img src=../img/cgiconfig2_del.gif border=0 title="DELETE Rule"></a></td>
EOF
      if [ -f $CGICONFIG2_SAVE_PATH/com$fw_sourcep$fw_proto ]
      then
        comment="`cat $CGICONFIG2_SAVE_PATH/com$fw_sourcep$fw_proto`"
        echo "<td>$comment</td>
        <td><a href=\"$switch?action=delcomment&amp;sport=$fw_sourcep&amp;proto=$fw_proto\">$_del_comment</a></td></tr>"
      else
        echo "<td><form action=$myname method=get><input type=text name=commt size=20></td>
        <td><input type=\"hidden\" name=\"sport\" value=$fw_sourcep><input type=\"hidden\" name=\"proto\" value=$fw_proto>
        <input type=submit name=action value=\"$_add_comment\"></form></td></tr>"
      fi

done < /etc/portfw.conf
cat <<EOF
<tr><td><form name="create_fwrd" action="$myname" method="get"></td>
<td><input type="text" name="sport" size="10"></td>
<td><input type="text" name="ip" size="15"></td>
<td><input type="text" name="dport" size="10"></td>
<td><select name="protocol">
<option value="tcp">tcp</option>
<option value="udp">udp</option>
</select></td>
<td style="text-align: center"><input type="submit" name="action" value="$_add_rule"></td>
</form><td></td><td></td></tr></table>
EOF

;;
# create forward rule
"$_add_rule")
    echo "default $FORM_sport $FORM_ip $FORM_dport $FORM_protocol" >> /etc/portfw.conf
    setup-portfw.sh
    echo "Location: $myname?action=fwrd"
    echo
;;
# delete forward rule
del_fwrd)
    grep -v "default $FORM_sport $FORM_ip $FORM_dport $FORM_protocol" /etc/portfw.conf > /tmp/portfw.conf
    cp /tmp/portfw.conf /etc/portfw.conf
    rm /tmp/portfw.conf
    setup-portfw.sh
    echo "Location: $myname?action=fwrd"
    echo
;;

#add comment
"$_add_comment")
    echo $FORM_commt > $CGICONFIG2_SAVE_PATH/com$FORM_sport$FORM_proto
    echo "Location: $myname?action=fwrd"
    echo
;;
#add comment
"delcomment")
    if [ -f $CGICONFIG2_SAVE_PATH/com$FORM_sport$FORM_proto ] 
    then 
        rm $CGICONFIG2_SAVE_PATH/com$FORM_sport$FORM_proto 
    fi
    echo "Location: $myname?action=fwrd"
    echo
;;
esac

case $html in
yes)
    show_tab_footer
    show_html_footer
;;
esac
