#!/bin/sh

## -----------------------------------------------------------------------------
## main_bluez.cgi - web interface for bluez-connections fli4l 2.1.11 version 0.1
##
## Erstell:              22.08.2005     chb
## Letzte Aenderung:     25.08.2005     chb
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------

SEC_REALM='bluez'
SEC_ACTION='view'
. ./sec-lib.cgi

RTIME=10

# HTML-Header
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE=\"text/css\" HREF=\"main.css\">"
echo "<title>opt_bluez - Bluetooth Verbindungen</title>"
echo "</head><body bgcolor=\"#FFFFFF\" link=\"#FFFFFF\" vlink=\"#C0C0C0\" alink=\"#FF0000\">"
echo

# Tabelle erstellen
echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\"  width=\"100%\" bgcolor=\"#f0f0f0\" bordercolor=\"#ffffff\">"
echo "<tr bgcolor=\"#000000\">"
echo "<td> <center><b><font face=verdana> <a href=\"main_Bluez.cgi?con_clients\">Verbundene Clients</a> </font></b></center></td>"
echo "<td> <center><b><font face=verdana> <a href=\"main_Bluez.cgi?linkkeys\">bekannte Verbindungssch&uuml;ssel</a> </font></b></center></td>"
echo "<td> <center><b><font face=verdana> <a href=\"main_Bluez.cgi?device_scan\">Umgebung scannen</a> </font></b></center></td>"
echo "</tr></table>"

if [ "$QUERY_STRING" = "" ]
then
   QUERY_STRING=con_clients
fi

if [ "$QUERY_STRING" = "con_clients" ]
then
   if [ -f /tmp/bluez_clients.list ]
   then
      rm /tmp/bluez_clients.list
   fi

   for mac_bluez_con in `hcitool con | grep "ACL" | cut -f 3 -d ' '`
   do
      ip_bluez_con=`cat /boot/dnsmasq.leases | grep -i $mac_bluez_con | cut -f 3 -d ' '`
      name_bluez_con=`cat /boot/dnsmasq.leases | grep -i $mac_bluez_con | cut -f 4 -d ' '`
      lq_bluez_con=`hcitool lq $mac_bluez_con | cut -f 3 -d ' '`
      if [ "$ip_bluez_con" = "" ]
      then
         ip_bluez_con="noch_nicht_vergeben"
      fi
      if [ "$name_bluez_con" = "" ]
      then
         name_bluez_con="noch_nicht_ermittelt"
      fi
      echo "$mac_bluez_con $ip_bluez_con $name_bluez_con $lq_bluez_con" >> /tmp/bluez_clients.list
   done
    
   echo "<br>"
   echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"#f0f0f0\" bordercolor=\"#ffffff\" align=\"center\">"
   echo "<tr bgcolor=\"#000000\">"
   echo "    <td colspan=\"8\">"
   echo "        <div align=\"center\"><font color=\"#ffffff\" face=\"verdana\"><b>Aktive Bluetooth Verbindungen</b></font><div>"
   echo "    </td>"
   echo "</tr>"
   echo "<tr>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">MAC Adresse</font></b></center>"
   echo "   </td>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">IP Adresse</font></b></center>"
   echo "   </td>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">Client Name</font></b></center>"
   echo "   </td>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">Verb. Qualit&auml;t</font></b></center>"
   echo "   </td>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">Verbindung</font></b></center>"
   echo "   </td>"
   echo "</tr>"

   drop="<a href=\"./bluez_connection-drop.cgi"

   if [ -f /tmp/bluez_clients.list ]
   then
      cat /tmp/bluez_clients.list | while read macbluezcon ipbluezcon namebluezcon lqbluezcon
      do
         echo "<tr>"
         echo "   <td>"
         echo "        <p align=\"center\">$macbluezcon"
         echo "   </td>"
         echo "   <td>"
         echo "        <p align=\"center\">$ipbluezcon"
         echo "   </td>"
         echo "   <td>"
         echo "        <p align=\"center\">$namebluezcon"
         echo "   </td>"
         echo "   <td>"
         echo "        <p align=\"center\">$lqbluezcon (von 255)"
         echo "   </td>"
         echo "   <td>"
         echo "        <p align=\"center\">$drop?macbluezcon=$macbluezcon\">trennen</a>"
         echo "   </td>"
         echo "</tr>"
      done
      echo "</table>"   
    else
      echo "<pre>"
      echo "<br>"
      echo "<center><b><font color=\"#FF6666\" face=\"verdana\">Es sind keine aktiven Bluetooth Verbindungen vorhanden!</font></b></center>"
      echo "<br>"
      echo "</pre>"
    fi
fi

if [ "$QUERY_STRING" = "linkkeys" ]
then
   if [ -f /tmp/bluez_linkkeys.list ]
   then
      rm /tmp/bluez_linkkeys.list
   fi

   for mac_bluez_link in `hcitool dev | grep -v "Devices:" | cut -c 7-`
   do
      if [ -f /var/lib/bluetooth/$mac_bluez_link/linkkeys ]
      then
         linkkeys_bluez=`cat /var/lib/bluetooth/$mac_bluez_link/linkkeys | cut -f 1 -d ' '`
         echo "$mac_bluez_link $linkkeys_bluez" >> /tmp/bluez_linkkeys.list
      fi
   done

   echo "<br>"
   echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\" bgcolor=\"#f0f0f0\" bordercolor=\"#ffffff\" align=\"center\">"
   echo "<tr bgcolor=\"#000000\">"
   echo "    <td colspan=\"8\">"
   echo "        <div align=\"center\"><font color=\"#ffffff\" face=\"verdana\"><b>f&uuml;r folgende MAC Adressen sind Bluetooth Schl&uuml;ssel (LinkKeys) vorhanden:</b></font><div>"
   echo "    </td>"
   echo "</tr>"
   echo "<tr>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">MAC des lokalen Bluetooth Ger&auml;tes</font></b></center>"
   echo "   </td>"
   echo "   <td>"
   echo "        <center><b><font face=\"verdana\">MAC des entfernten Bluetooth Ger&auml;tes</font></b></center>"
   echo "   </td>"
   echo "</tr>"

   if [ -f /tmp/bluez_linkkeys.list ]
   then
      cat /tmp/bluez_linkkeys.list | while read macbluezlink linkkeysbluez
      do
         echo "<tr>"
         echo "   <td>"
         echo "        <p align=\"center\">$macbluezlink"
         echo "   </td>"
         echo "   <td>"
         echo "        <p align=\"center\">$linkkeysbluez"
         echo "   </td>"
         echo "</tr>"
      done
      echo "</table>"   
   else
      echo "<pre>"
      echo "<br>"
      echo "<center><b><font color=\"#FF6666\" face=\"verdana\">Es sind keine Bluetooth Verbindungsschl&uuml;ssel gespeichert!</font></b></center>"
      echo "<br>"
      echo "</pre>"
   fi
fi

if [ "$QUERY_STRING" = "device_scan" ]
then
   if [ -f /tmp/bluez_scanning.list ]
   then
      rm /tmp/bluez_scanning.list
   fi

   echo "<pre>"
   echo "<center><b><font face=\"verdana\">die Umgebung wird nach aktiven und sichtbaren Bluetooth Ger&auml;ten durchsucht ... (bitte einen Moment warten)</font></b></center>"
   echo "<center><b><font face=\"verdana\">(die Reichweite ist abh&auml;ngig von der verwendeten Klasse (Class1 bis 3 (5-10, 50, 100 Meter) des lokalen Ger&auml;tes)</font></b></center>"
   echo "<center><b><font face=\"verdana\">---------------------------------------------------------------------------------------------------------------------</font></b></center>"
   echo "<br>"

   # das 'sed' ist noetig, da die Bluetooth Features in "<>" zurueckgeliefert werden, das kann als HTML-Tag fehlinterpretiert werden
   hcitool scan --info --class | grep -v "Scanning ..." | sed s/"<"/\(/g | sed s/">"/\)/g >> /tmp/bluez_scanning.list

   # eigentlich ein bloeder Hack, aber da die Busybox cat, grep und die sonstigen Tools nur rudimentaer implementiert hat, muss man sich hat so behelfen ;-))
   if cat /tmp/bluez_scanning.list | grep -n " " > /dev/null
   then
      cat /tmp/bluez_scanning.list | while read text
      do
         echo "<option>$text</option>"
      done
   else        
      echo "</pre>"
      echo "<pre>"
      echo "<br>"
      echo "<center><b><font color=\"#FF6666\" face=\"verdana\">Es sind keine erkennbare Bluetooth Ger&auml;te in der Umgebung!</font></b></center>"
      echo "<br>"
      echo "</pre>"
   fi
fi

echo "</body></html>"
