#!/bin/sh
PATH=/usr/sbin:/bin:/usr/bin/:/usr/local/bin

. /etc/cipe/cfg

restart_cipe ()
{
  name=$1
  cipe_pid=`ps | grep "/etc/cipe/$name.conf" | sed -e 's/^ *//' -e 's/ .*//'`
  if [ "$cipe_pid" != "" ]
  then
    colecho "killing CIPE tunnel $name"
    kill -TERM $cipe_pid
    sleep 5
  fi
  colecho "restarting CIPE tunnel $name."
  ciped-cb -o /etc/cipe/$name.conf
}

while [ true ];
do
   date

   colecho "checking $CIPE_N tunnel..."
   for idx in `seq 1 $CIPE_N`
   do
      eval cipe_name='$CIPE_'$idx'_NAME'
      eval cipe_check='$CIPE_'$idx'_CHECK'
      eval cipe_check_ip='$CIPE_'$idx'_CHECK_IP'
      eval cipe_remote_host='$CIPE_'$idx'_REMOTE_HOST'
      eval cipe_local_vpn_ip='$CIPE_'$idx'_LOCAL_VPN_IP'
      eval cipe_remote_vpn_ip='$CIPE_'$idx'_REMOTE_VPN_IP'
      
      if [ "$cipe_check" = "" -o "$cipe_check" = "yes" ]; then
        if ping -c 2 -q $cipe_local_vpn_ip 2>\&1>/dev/null;
        then
          # Ist der Gegenueber (=andere PTP Adresse) erreichbar?
          cipe_test_ip="$cipe_remote_vpn_ip"
          [ "$cipe_check_ip" ] && cipe_test_ip="$cipe_check_ip"
          colecho "checking $cipe_name ($cipe_test_ip)"
          if ping -c 2 -q $cipe_test_ip 2>\&1>/dev/null;
          then
            # Ok, der Tunnel steht, nix weiter machen
            colecho "$cipe_name ($cipe_remote_vpn_ip) tunnel is ready to use" gn
            else
              colecho "$cipe_name ($cipe_test_ip) not pingable, checking online status $cipe_remote_host."
              # Ist der Gegenueber ueberhaupt online?
              if ping -c 2 -q $cipe_remote_host 2>\&1>/dev/null;
              then
                # Der Gegenueber ist online, also versuchen den Tunnel neu zu starten
                colecho "$cipe_name ($cipe_remote_host) is online, restarting CIPE tunnel"
                restart_cipe $cipe_name
              else
                # Der Gegenueber ist offline, nix weiter machen
                colecho "$cipe_name ($cipe_remote_host) is offline, tunnel not available" rd
              fi
            fi
          else
            colecho "local vpn endpoint $cipe_local_vpn_ip Addresse not yet ready, starting CIPE" rd
            restart_cipe $cipe_name
        fi
      else
        colecho "ignoring $cipe_name" rd
      fi      
   done

   # Jetzt 30-90 Sekunden warten und Tunnel erneut pruefen
   # Damit es zu keiner Race Condition kommt wenn zwei Partner
   # eventuell versuchen einen Tunnel neu aufzubauen wird keine
   # Konstante Zeit gewartet sondern eben immer zwischen 30-90
   # Sekunden.
   MYRAND=`dd if=/dev/urandom bs=1 count=2 2>/dev/null | tr \
'\\000\\001\\002\\003\\004\\005\\006\\007\\010\\011\\012\\013\\014\\015\
\\016\\017\\020\\021\\022\\023\\024\\025\\026\\027\\030\\031\\032\\033\
\\034\\035\\036\\037\\040\\041\\042\\043\\044\\045\\046\\047\\050\\051\
\\052\\053\\054\\055\\056\\057\\060\\061\\062\\063\\064\\065\\066\\067\
\\070\\071\\072\\073\\074\\075\\076\\077\\100\\101\\102\\103\\104\\105\
\\106\\107\\110\\111\\112\\113\\114\\115\\116\\117\\120\\121\\122\\123\
\\124\\125\\126\\127\\130\\131\\132\\133\\134\\135\\136\\137\\140\\141\
\\142\\143\\144\\145\\146\\147\\150\\151\\152\\153\\154\\155\\156\\157\
\\160\\161\\162\\163\\164\\165\\166\\167\\170\\171\\172\\173\\174\\175\
\\176\\177\\200\\201\\202\\203\\204\\205\\206\\207\\210\\211\\212\\213\
\\214\\215\\216\\217\\220\\221\\222\\223\\224\\225\\226\\227\\230\\231\
\\232\\233\\234\\235\\236\\237\\240\\241\\242\\243\\244\\245\\246\\247\
\\250\\251\\252\\253\\254\\255\\256\\257\\260\\261\\262\\263\\264\\265\
\\266\\267\\270\\271\\272\\273\\274\\275\\276\\277\\300\\301\\302\\303\
\\304\\305\\306\\307\\310\\311\\312\\313\\314\\315\\316\\317\\320\\321\
\\322\\323\\324\\325\\326\\327\\330\\331\\332\\333\\334\\335\\336\\337\
\\340\\341\\342\\343\\344\\345\\346\\347\\350\\351\\352\\353\\354\\355\
\\356\\357\\360\\361\\362\\363\\364\\365\\366\\367\\370\\371\\372\\373\
\\374\\375\\376\\377' \
01234567890123456789012345678901234567890123456789\
01234567890123456789012345678901234567890123456789\
01234567890123456789012345678901234567890123456789\
01234567890123456789012345678901234567890123456789\
01234567890123456789012345678901234567890123456789\
01234567890`
   MYRAND=`expr 30 + $MYRAND % 60`
   colecho "next check will run in $MYRAND seconds"
   sleep $MYRAND

# Schleife staendig wiederholen
done


