#!/bin/sh

SEC_REALM='ipconntrack_list'
SEC_ACTION='view'
. ./sec-lib.cgi

echo "Content-Type: text/html; charset=iso-8859-15"
echo "Cache-control: no-store"
echo "Pragma: no-cache"
echo "Expires: `date -Ru`"
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE=\"text/css\" HREF=\"ipconntrack_list.css\">"
echo "<title>opt_ipconntrack_list</title>"
echo "</head><body>"

case "$QUERY_STRING" in
  prot)
    OUT_PREFIX=""
    ;;
  src)
    OUT_PREFIX="\4 \5"
    ;;
  sport)
    OUT_PREFIX="\5 \8"
    ;;
  dst)
    OUT_PREFIX="\7 \8"
    ;;
  dport)
    OUT_PREFIX="\8 \5"
    ;;
  stat)
    OUT_PREFIX="\3 \2"
    ;;
  flg)
    OUT_PREFIX="\6\9 \3"
    ;;
  *)
    OUT_PREFIX="\2 \3"
    ;;
esac

echo "<table width=\"100%\" align=\"center\"><tr><th><a href=\"?prot\">Protocol</a></th><th><a href=\"?src\">Sourcehost</a></th><th><a href=\"?sport\">Sourceport</a></th><th><a href=\"?dst\">Destinationhost</a></th><th><a href=\"?dport\">Destinationport</a></th><th><a href=\"?stat\">Status</a></th><th><a href=\"?tout\">Time-Out</a></th><th><a href=\"?flg\">Flags</a></th></tr>"
sed "s/^\([^[:space:]]*\)[[:space:]]*[[:space:]][^[:space:]]*[[:space:]]*[[:space:]]\([^[:space:]]*\)[[:space:]]*\([^[:space:]]*\)[[:space:]]*[[:space:]]src=\([^[:space:]]*\)[[:space:]]*[[:space:]]dst=[^[:space:]]*[[:space:]]*[[:space:]]sport=\([^[:space:]]*\)[[:space:]]*[[:space:]]dport=[^[:space:]]*[[:space:]]*\([^[:space:]]*\)[[:space:]]*[[:space:]]src=\([^[:space:]]*\)[[:space:]]*[[:space:]]dst=[^[:space:]]*[[:space:]]*[[:space:]]sport=\([^[:space:]]*\)[[:space:]]*[[:space:]]dport=[^[:space:]]*[[:space:]]*\([^[:space:]]*\)[[:space:]]*[[:space:]]use=.*\$/$OUT_PREFIX	\1	\4	\5	\7	\8	\3	\2	\6\9/g;" /proc/net/ip_conntrack | sort -n | sed 's/^[^	]*	/<tr><td>/g;s/	/<\/td><td>/g;s/$/<\/td><\/tr>/g'
echo "</table>"
echo "</body></html>"

exit 0
