#!/bin/sh
#-----------------------------------------------------------------------------
#                                                                 2.1.11
# /usr/local/htdocs/main_ISDNFaxe.cgi - display received faxes from OPT_FAXRCV
#
# Creation:     28.09.2003  felix
# Last Update:  $Id: main_ISDNFaxe.cgi 9410 2005-07-20 21:29:03Z hh $
#-----------------------------------------------------------------------------

eval "`proccgi $*`"
# access values using $FORM_name

# This script can be called with the following parameters
# ----------------------------------------------------------------------------
# Parameter    | Value                    | Meaning
# ----------------------------------------------------------------------------
# action       | showtab                  | Show the tab "item"
#              | deletefax                | Delete the fax in "item"
#              | viewfax                  | Display fax in "item" in browser
#              | downloadfax              | Download fax in "item"
#              | start, stop              | Start or stop the capifaxrcvd
# item         | depening on action       | The item "action" should process
# page         | number                   | Used in conjunction with viewfax
#              |                          | Returns given page as JPG

## sanity-check the input
FORM_action=`echo "$FORM_action" | sed "s/[^a-zA-Z]//g"`
FORM_item=`echo "$FORM_item" | sed "s/[^-_+.a-zA-Z0-9]//g"`
FORM_page=`echo "$FORM_page" | sed "s/[^0-9]//g"`
#FORM_number=`echo "$FORM_number" | sed "s/[^0-9]//g"`

## seclib-abfrage
SEC_REALM='isdnfax'
case $FORM_action in
    delete) SEC_ACTION='delete' ;;
    start|stop) SEC_ACTION='startstop' ;;
    *) SEC_ACTION='view' ;;
esac
. ./sec-lib.cgi

## interne variablen
. /var/run/fax.conf
THISFILE="$0"
MENU_ITEMS="Faxe An-Aus"

if [ "$FAXRCV_IMONC_LIST" = "0" ]
then
  ACTIVE_NUMBER="$FAXRCV_HTTPGUI_USER"
else
  ACTIVE_NUMBER="$FAXRCV_IMONC_LIST"
fi

eval FAXDIR='$FAXRCV_'$ACTIVE_NUMBER'_DIRECTORY'
MFAX_LOG="$FAXDIR""/mfax.log"
CONVERTDIR="$FAXDIR/converttemp"
CONVERTNAME="fax"

## fallback
if [ "x$FORM_action" = "x" ]
then
  FORM_action="showtab"
fi

if [ "x$FORM_action" = "xshowtab" ]
then
  if [ "x$FORM_item" = "x" ]
  then
    MENU_SELECTED="Faxe"
  else
    MENU_SELECTED="$FORM_item"
  fi

  echo "Content-Type: text/html; charset=iso-8859-1"
  echo "Cache-control: no-cache"   # HTTP/1.1
  echo "Pragma: no-cache"          # HTTP/1.0
  echo
  echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">
<html><head>
<!--
######
# Created by $Id: main_ISDNFaxe.cgi 9410 2005-07-20 21:29:03Z hh $
# Part of OPT_FAXRCV, (c) Felix Eckhofer <felix@tribut.de>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License (GPL) as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
######
-->
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">
<title>faxrcv :: http-gui (2.1.11)</title>
<link rel=\"stylesheet\" type=\"text/css\" href=\"faxrcv.css\">
</head>

<body>
<!-- HEADER  -->
<table class=\"headertable\"><tr><td><form name=\"num_select\">Faxnummer:
<select name=\"number\" class=\"inputs\">
<option>default</option>
</select></form></td><td align=\"right\">
faxrcv-Weboberfl&auml;che (2.1.11)
</td></tr></table>
<!-- MENU -->
<table class=\"menutable\"><tr>"

  for MENU_ITEM in $MENU_ITEMS
  do
    if [ "x$MENU_ITEM" = "x$MENU_SELECTED" ]
    then
      echo "<td class=\"menuitemselected\">"
      echo "<span class=\"menulink\">$MENU_ITEM</span>"
    else
      echo "<td class=\"menuitem\">"
      echo "<a class=\"menulink\"
href=\"$THISFILE?action=showtab&item=$MENU_ITEM\">$MENU_ITEM</a>"
    fi
  done

  echo "</td></tr></table>
<!-- CONTENT -->
<table class=\"contenttable\">"

  case $MENU_SELECTED in
    Faxe)
      if [ -f "$MFAX_LOG" ] ; then
        echo "<tr class="listheader">
<td>
  Datum/Zeit
</td><td>
  Fax-ID
</td><td>
  Seiten
</td><td>
  Datei
</td><td>
  Aktionen
</td></tr>"

        sed '1!G;h;$!d' "$MFAX_LOG" | while read d z i p f
        do
	  # + is not allowed in QUERY_STRING but in filenames
	  qf=`echo "$f" | sed "s/\+/%2B/g"`
	  # "_" is a replacement for " "
	  # i=`echo "$i" | sed "s/_/\&nbsp;/g"`
          echo "<tr class=\"listitem$ITERATE\">
<td align=\"center\">$d/$z</td>
<td><b>$i</b></td>
<td align=\"center\">$p</td>
<td>$f</td>
<td align=\"center\">"
          if [ "$FAXRCV_HTTPGUI_CONVERT" = "yes" ]
	  then
	    echo "  <a href=\"$THISFILE?action=viewfax&item=$qf\"><img
      src=\"fax_view.gif\" border=0 width=21 height=16
      alt=\"Ansehen\" title=\"Ansehen\"></a>"
          fi
	  echo "  <a href=\"$THISFILE?action=downloadfax&item=$qf\"><img
      src=\"fax_download.gif\" border=0 width=21 height=16
      alt=\"Download\" title=\"Download\"></a>
  <a href=\"$THISFILE?action=deletefax&item=$qf\"
      onclick=\"return confirm('Wirklich l&ouml;schen?');\"><img
      src=\"fax_delete.gif\" border=0 width=21 height=16
      alt=\"L&ouml;schen\" title=\"L&ouml;schen\"></a>
</td>
</tr>"

          if [ "$ITERATE" = "" ]
          then
            ITERATE="2"
          else
            ITERATE=""
          fi
        done
      else
        echo "<tr><td>Keine Faxe</td></tr>"
      fi
      ;;
    An-Aus)
      echo "<tr><td>&nbsp;</td></tr>"
      echo "<tr class=\"listheader\"><td>Faxempfang ist"
      if ps -ax|grep capifaxrcvd|grep -v grep >/dev/null
      then
        echo "<span class=\"faxrcvon\">AN</span>"
      else
        echo "<span class=\"faxrcvoff\">AUS</span>"
      fi
      echo "</td></tr><tr><td align=\"center\">
[<a href=\"$THISFILE?action=start\">einschalten</a>]&nbsp;
[<a href=\"$THISFILE?action=stop\">ausschalten</a>]
</td></tr>"
      ;;
    *)
      echo "<tr><td>What the?</td></tr>"
      ;;
  esac

  echo "</table></body></html>"

elif [ "x$FORM_action" = "xdeletefax" ]
then
  VALID_FILE="0"
  while read d z i p f
  do
    if [ "$f" = "$FORM_item" ]
    then
      VALID_FILE="1"
      break
    fi
  done < "$MFAX_LOG"

  if [ "$VALID_FILE" = "1" ]
  then
    rm -f "$FAXDIR"/"$FORM_item".gz
    if [ "$?" = 0 -o ! -f "$FAXDIR"/"$FORM_item".gz ]
    then
      # escape "." (see sanity-check above)
      FORM_item=`echo $FORM_item | sed 's/\./\\\./g'`
      # remove the line corresponding with the deleted file
      sed "/ $FORM_item\$/d" "$MFAX_LOG" > $FAXDIR/mfax.tmp
      # replace mfax.log
      mv "$FAXDIR/mfax.tmp" "$MFAX_LOG"
    fi
  fi

  echo "Location: $THISFILE"
  echo

elif [ "x$FORM_action" = "xviewfax" ]
then
  if [ "x$FORM_page" = "x" ]
  then
    # convert the fax and
    # show the page where all the images are included
    mkdir -p $CONVERTDIR
    rm -f "$CONVERTDIR/$CONVERTNAME"*

    if [ -f "$FAXDIR"/"$FORM_item".gz ]
    then
      gzip -cd "$FAXDIR"/"$FORM_item".gz > $CONVERTDIR/$CONVERTNAME.sff 2>/dev/console
      # creates $CONVERTDIR/$CONVERTNAME.001.jpg $CONVERTNAME.002.jpg etc.
      sff2misc -j "$CONVERTDIR/$CONVERTNAME.sff" "$CONVERTDIR/$CONVERTNAME" >/dev/console 2>&1

      echo "Content-Type: text/html; charset=iso-8859-1"
      echo "Cache-control: no-cache"   # HTTP/1.1
      echo "Pragma: no-cache"          # HTTP/1.0
      echo
      echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">
<html><head>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">
<title>faxrcv :: http-gui (2.1.11)</title>
<link rel=\"stylesheet\" type=\"text/css\" href=\"faxrcv.css\">
</head><body>"

      INFOLINE=`grep "$FORM_item" $MFAX_LOG`
      if [ "x$INFOLINE" = "x" ]
      then
        echo "<h1>Not found</h1>
The file $FORM_item was not found in $MFAX_LOG"
      else
	echo "<h1 class=\"faxpagehead\">$FORM_item</h1>"
        # d z i p f
        set -- $INFOLINE
	NUM_PAGES="$4"
        idx="1"
	while [ "$idx" -le "$NUM_PAGES" ]
	do
	  echo "<div class=\"faxpagenum\">Seite $idx</div><br>"
	  echo "<div class=\"faxpage\"><a
href=\"$THISFILE?action=viewfax&item=&page=$idx\"
target=\"_blank\"><img align=\"center\"
src=\"$THISFILE?action=viewfax&item=&page=$idx\"
alt=\"Seite $idx\" width=\"500\"
border=\"0\"></a></div>"
          idx=`expr $idx + 1`
	done
      fi

      echo "</body></html>"
    else
      # we dont have that file...
      echo "Location: $THISFILE"
      echo
    fi
  else
    # return a specific page as JPG
    PADDED_PAGE=`echo "000$FORM_page" | sed "s/.*\([0-9]\{3\}\)/\1/"`
    echo "Content-Type: image/jpeg"
    echo
    cat "$CONVERTDIR/$CONVERTNAME.$PADDED_PAGE.jpg"
  fi

elif [ "x$FORM_action" = "xdownloadfax" ]
then
  if [ -f "$FAXDIR/$FORM_item.gz" ]
  then
    echo "Content-Type: application/download"
    echo "Content-Disposition: attachment; filename=$FORM_item"
    echo
    gzip -cd "$FAXDIR/$FORM_item.gz"
  else
    echo "Location: $THISFILE"
    echo
  fi

elif [ "x$FORM_action" = "xstart" ]
then
  faxrcv.sh start > /dev/console 2>&1
  echo "Location: $THISFILE?action=showtab&item=An-Aus"
  echo
elif [ "x$FORM_action" = "xstop" ]
then
  faxrcv.sh stop > /dev/console 2>&1
  echo "Location: $THISFILE?action=showtab&item=An-Aus"
  echo
else
  echo "Location: $THISFILE"
  echo
fi
