#----------------------------------------------------------------------------
# /usr/local/bin/newfax.sh - process received faxes              2.1.11
#
# Creation:     28.09.2003  felix
# Last Update:  $Id: newfax.sh 9231 2005-06-20 23:07:49Z hh $
#----------------------------------------------------------------------------

gzip < "$1" > "$1.sff.gz"

if [ "$?" = 0 ]
then
    rm "$1"
else
    # remove the damaged file just to be sure
    rm -f "$1.sff.gz"
    # rename the file to make it recognizeable
    mv "$1" "$1.sff"
    # and output a warning
    facility="newfax.sh"
    message="ERROR gzipping the file $1! Probably not enough memory?"
    if [ -f /usr/bin/logger -o -L /usr/bin/logger ]
    then
        logger -t "$facility" "$message"
    else
        colecho "$facility: $message" br x br > /dev/console 2>&1
    fi
        
fi

if [ "$FAXRCV_DIRECTORY" != "" ]
then
        SENDER=`echo $1 | cut -c 14-`
        PAGES=`echo $1 | cut -c 3-5 | sed 's/^[0]*//'`
        if [ "$SENDER" = "" ] ; then
            SENDER="?"
        fi
        LANGDATUM=`/bin/date +%d.%m.%y`
        LANGZEIT=`/bin/date +%H:%M:%S`
        echo "$LANGDATUM $LANGZEIT $SENDER $PAGES $1.sff" >> $FAXRCV_DIRECTORY/mfax.log
fi

idx=1
while [ "$idx" -le "$FAXRCV_NTFYCMD_N" ]
do
        eval ntfycmd='$FAXRCV_NTFYCMD'_$idx
	$ntfycmd "$FAXRCV_DIRECTORY/$1.sff.gz"
	idx=`/usr/bin/expr $idx + 1`
done

