#!/bin/sh
#-----------------------------------------------------------------------------
# /usr/local/bin/faxrcv.sh - start or stop capifaxrcvd            2.1.10
#
# Creation:     15.04.2004  felix
# Last Update:  $Id: faxrcv.sh 5271 2004-04-17 18:09:34Z felix $
#-----------------------------------------------------------------------------

CONFIGFILE="/var/run/fax.conf"

if [ "$#" -ne 1 ]
then
  echo "$0: missing argument"
  echo "use me like this: \"$0 [start|stop]\""
  exit 1
fi

. $CONFIGFILE

if ps -ax | grep 'capifaxrcvd' | grep -v grep >/dev/null
then
  ISRUNNING="1"
fi

if [ "x$1" = "xstart" ]
then

  if [ "$ISRUNNING" = "1" ]
  then
    /usr/local/bin/colecho "capifaxrcvd already running, wont start it twice..." br x br
    exit 1
  fi

  idx=1
  while [ "$idx" -le "$FAXRCV_N" ]
  do
    eval number='$FAXRCV_'$idx'_NUMBER'
    eval csid='$FAXRCV_'$idx'_CSID'
    eval directory='$FAXRCV_'$idx'_DIRECTORY'
    eval ntfycmd='$FAXRCV_'$idx'_NTFYCMD'
    eval newfax="/usr/local/bin/newfax"$idx".sh"

    /usr/local/bin/colecho "starting capifaxrcvd... (entry $idx, MSN $number)" gn

    if [ "$directory" = "" ]
    then
      /usr/local/bin/colecho "++ faxrcv FATAL ERROR: no faxdir supplied! ++" br x br
      break
    fi

    if [ -d "$directory" ]
    then
     echo -n ;
    else
     echo "creating faxdir ($directory)..."
     mkdir -p $directory
    fi

    if [ "$csid" != "" ]
    then
     entrycsid="-i '$csid'"
    fi

    if [ "$number" != "" ]
    then
     entrynumber="-l $number"
    fi

    echo "+ capifaxrcvd $entrycsid $entrynumber -n $newfax $directory"
    capifaxrcvd $entrycsid $entrynumber -n $newfax $directory

    idx=`/usr/bin/expr $idx + 1`
  done

elif [ "x$1" = "xstop" ]
then

  if [ "$ISRUNNING" = 1 ]
  then
    killall capifaxrcvd
    sleep 2
    if ps -ax | grep 'capifaxrcvd' | grep -v grep
    then
      echo "could not kill capifaxrcvd (you may want to retry by calling this script again)"
    else
      echo "successfully killed capifaxrcvd"
    fi
  else
    echo "capifaxrcvd is not running."
  fi

else
  echo "$0: wrong argument"
  exit 1
fi

