#------------------------------------------------------------------------------
# Creation:     19.03.2005  Christian Raatz fli4l@schinkensaft.de
# Last Update:  16.06.2005
# Thx to:       mas, Thomas Unger, Thomas Klingler, Peter Schiefer
# Online-Check:	Manfred Schliesing
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# Das Ganze erst mal vorbereiten
#------------------------------------------------------------------------------

DATE=`date -R`                                  
TIME=`date +%y%m%d%H%M`

#------------------------------------------------------------------------------
# Ein paar Checks etc.
#------------------------------------------------------------------------------

if [ "$customredate" = "yes" ]
   then
   REDATE=`date -R`
   else
   REDATE=``
fi

#------------------------------------------------------------------------------
# Abfrage ob Router Online/Offline und Merken
#------------------------------------------------------------------------------
status_dsl=`fli4lctrl status pppoe` > /dev/null
statusisdn=`fli4lctrl status all`   > /dev/null
status_alt="offline"
colecho > /dev/console
if [ "$status_dsl" = "online" ] # DSL Online?
    then
      status_alt="online"
      colecho "OPT_FAXSEND (Router war online (DSL)...." rd 0 br > /dev/console
    fi
if [ "$statusisdn" = "online" ] # ISDN Online ?
    then
      status_alt="online"
      colecho "OPT_FAXSEND (Router war online (ISDN)..." rd 0 br > /dev/console
    fi

#------------------------------------------------------------------------------
# Start Router Online und testschleife ob es geklappt hat, erst dann weiter !
# (bei faxprint hakelt der imonc)
#------------------------------------------------------------------------------
status_neu="offline"
if [ "$status_alt" = "offline" ] #gehe nun Online !!!!
    then
      colecho "OPT_FAXSEND Router war offline, Start online" rd 0 br > /dev/console
        while [ "$status_neu" = "offline" ]
          do
            imonc dial
            # Test ob online
            status_dsl=`fli4lctrl status pppoe` > /dev/null
            statusisdn=`fli4lctrl status all`   > /dev/null
            if [ "$status_dsl" = "online" ] 
            then
             status_neu="online"
            fi
            if [ "$statusisdn" = "online" ] 
            then
              status_neu="online"
            fi
            sleep 10 # schleife alle 10 sekunden wiederholen
            colecho "OPT_FAXSEND Router meldet noch offline ...." rd 0 br > /dev/console
         done	  
       colecho "OPT_FAXSEND Router online !" gn > /dev/console
    fi

#------------------------------------------------------------------------------
# Erstellen der pop.cmd wenn FAXSEND_x_POPCHECK='yes'
# und kurzes einloggen auf dem pop3-server
#------------------------------------------------------------------------------

if [ "$popcheck" = "yes" ]
  then
    echo -e "user $mailuser\npass $mailpwd\r\nquit"  > /tmp/pop.cmd
    colecho "OPT_FAXSEND $popsvr:$popport $mailuser (POPCHECK)" cy > /dev/console
    netcat -i $waitsvr $popsvr $popport < /tmp/pop.cmd
    colecho "OPT_FAXSEND popcheck fertig" gn > /dev/console
fi

#------------------------------------------------------------------------------
# smtp.cmd vorbereiten 
#------------------------------------------------------------------------------
if [ "$notifyonly" = "no" ]
	then
	{
			echo -e "helo $smtpsvr\r"
			echo -e "mail from: $from\r"
			echo -e "rcpt to: $to\r"
			echo -e "data\r"
			echo -e "Date: $DATE\r"
			echo -e "From: $from\r"
			echo -e "Reply-To: $to\r"
			echo -e "To: $to\r"
			echo -e "Subject: $customre $REDATE\r"
			echo -e "\r"
			echo -e "Fax wurde empfangen fuer $csid\r"
	}  >> /tmp/smtp$TIME.cmd
	else
	{
			echo -e "helo $smtpsvr\r"
			echo -e "mail from: $from\r"
			echo -e "rcpt to: $notifyaddr\r"
			echo -e "data\r"
			echo -e "Date: $DATE\r"
			echo -e "From: $from\r"
			echo -e "Reply-To: $notifyaddr\r"
			echo -e "To: $notifyaddr\r"
			echo -e "Subject: $customre $REDATE\r"
			echo -e "\r"
			echo -e "Fax wurde empfangen fuer $csid\r"
	  } >> /tmp/smtp$TIME.cmd
	nach=`$notifyaddr`
fi

#------------------------------------------------------------------------------
# Fax versandfertig machen
# -----------------------------------------------------------------------------

nach="?"
if [ "$notifyonly" = "no" ]
	then
        	nach="$to"
		if [ "$gzip" = "yes" ]
		then
			uuencode $1 $TIME.sff.gz >> /tmp/smtp$TIME.cmd
	else
		nach="$notifyaddr"
		zcat $1 > /tmp/faxtmp.sff
		uuencode /tmp/faxtmp.sff $TIME.sff >> /tmp/smtp$TIME.cmd
	fi
fi

#------------------------------------------------------------------------------
# smtp.cmd abschliessen
#------------------------------------------------------------------------------

echo -e "\r\n.\r\nquit\r\nquit\r\nquit\r" >> /tmp/smtp$TIME.cmd

#------------------------------------------------------------------------------
# Fax mit netcat verschicken
# -----------------------------------------------------------------------------

colecho "OPT_FAXSEND $smtpsvr:$smtpport SEND $1" cy > /dev/console
colecho "OPT_FAXSEND from $from to $nach"        cy > /dev/console
netcat -w $waitsvr $smtpsvr $smtpport < /tmp/smtp$TIME.cmd       
colecho "OPT_FAXSEND Fax gesendet !" gn       > /dev/console

#------------------------------------------------------------------------------
# Temporaere Dateien loeschen
# -----------------------------------------------------------------------------

colecho "OPT_FAXSEND Temporaere Dateien loeschen ....." cy > /dev/console
rm /tmp/smtp$TIME.cmd

if [ "$gzip" = "no" ]
	then
		rm /tmp/faxtmp.sff
fi
colecho "OPT_FAXSEND Temporaere Dateien geloescht !" gn  > /dev/console

#------------------------------------------------------------------------------
# gehe offline, wenn vor dem Faxversand offline war
# -----------------------------------------------------------------------------

if [ "$status_alt" = "offline" ]
    then
      colecho "OPT_FAXSEND Router wieder offline nehmen" rd 0 br > /dev/console
        while [ "$status_neu" = "online" ]
          do
            imonc hangup
            # Test ob online
            status_dsl=`fli4lctrl status pppoe` > /dev/null
            statusisdn=`fli4lctrl status all`   > /dev/null
            if [ "$status_dsl" != "online" ] 
               then
                  if [ "$statusisdn" != "online" ] 
                     then
                        status_neu="offline"
                  fi   
            fi
            sleep 20 # schleife alle 20 sekunden wiederholen
            colecho "OPT_FAXSEND Router meldet noch online ...." rd 0 br > /dev/console
         done	  
       colecho "OPT_FAXSEND Router offline !" gn > /dev/console
    else
       colecho "OPT_FAXSEND Router bleibt online !" rd 0 br > /dev/console
    fi
