#!/bin/sh
# -----------------------------------------------------------------------------
# opt/files/usr/local/bin/onco_blockip.sh for fli4l-2.1.9
#
# Version:		1.0.9
# Creation:		26.06.2002  mm
# Last Update:	19.04.2005  jml
#
# onco is Copyright (c) 2002 - 2004 Michael Mattes <sirprize@sodge.org>
# Changes for fli4l-2.1.9 made by Jrgen Mackiol <fli4l@juemac.de>
# -----------------------------------------------------------------------------

# elegantere Version --> ersetze / in ip-Bereich durch _ fr Filenamen etc...
ipname=`echo $ip | sed "s/\//_/"`

if [ -f /var/run/onco/$ipname.blocked ]
  then
	rm -f /var/run/onco/$ipname.time
  else
	if  [ ! -f /var/run/onco/$ipname.neverblock ]
	  then
		hostname=`cat /var/run/onco/hn`
		httpdport=`cat /var/run/onco/httpdport`

		/sbin/iptables -I INPUT 1 -p tcp -s $ip -d $hostname --dport $httpdport -j ACCEPT
		/sbin/iptables -I INPUT 2 -p tcp -s $ip -d $hostname -j DROP
		/sbin/iptables -I FORWARD 1 -p tcp -s $ip -j DROP

		if [ -f /var/run/onco/blockudp ]
		  then
				/sbin/iptables -I INPUT 1 -p udp -s $ip -d $hostname --dport $httpdport -j ACCEPT
				/sbin/iptables -I INPUT 2 -p udp -s $ip -d $hostname -j DROP
				/sbin/iptables -I FORWARD 1 -p udp -s $ip -j DROP
		fi
		if [ -f /var/run/onco/blockicmp ]
		  then
				/sbin/iptables -I INPUT 1 -p icmp -s $ip -d $hostname -j DROP
				/sbin/iptables -I FORWARD 1 -p icmp -s $ip -j DROP
		fi
		echo "" > /var/run/onco/$ipname.blocked
		rm -f /var/run/onco/$ipname.time
	fi
fi