#!/bin/sh
#------------------------------------------------------------------------------
# /opt/files/usr/local/bin/ssmpt_send.sh                                   v0.1 
#
# Versendet das uebergebene File, prueft den Versandstatus und informiert
# darueber das aufrufende Programm
#
# Exitcodes : 0 = ok
#             1 = Fehler bei Authentifizierung
#             2 = Fehler beim Versenden
#             3 = unbekannter Fehler (Fehler beim Versenden oder Authentifizierung)
#
# Creation:     2003-05-04  t_klingl
# Last Update:  2003-05-20  t_klingl
#------------------------------------------------------------------------------

#---------------------------------------
# Variablen belegen & inkludieren
#---------------------------------------
. /etc/ssmtp/ssmtp_skripte.conf
FILE=$1
BASENAME=`basename ${FILE}`
if [ "${SSMTP_USE_TLS}" != "yes" ]; then
	SSMTPCOMMAND="/usr/local/bin/ssmtp-ssl"
else
	SSMTPCOMMAND="/usr/local/bin/ssmtp"
fi

#---------------------------------------
# SMTP_AUTH ???
#---------------------------------------
if [ "${SSMTP_SMTP_AUTH}" != "no" ];
then
	#---------------------------------------
	# POP3-before-smtp
	#---------------------------------------
	if [ "${SSMTP_SMTP_AUTH}" = "pop" ]; then
		
		echo -e "user ${SSMTP_POP3_USERNAME}\r\npass ${SSMTP_POP3_PASSWORD}\r\nquit\r" | netcat -i 1 ${SSMTP_POP3_SERVER} ${SSMTP_POP3_PORT} | grep -q ^ERR
		
		if [ "$?" != "0" ]; then
			# keine Fehler, SMTP ist fuer eine gewisse Zeitspanne freigeschaltet
			${SSMTPCOMMAND} -t < ${FILE}
			
			if [ $? != "0" ]; then
			    # Fehler beim Versenden
			    exit 2
			else
				# Versenden erfolgreich
				exit 0
			fi
		else
		    # Fehler bei der Authentifizierung
		    exit 1
		fi
	else
	#---------------------------------------
	# "richtiges" SMTP_AUTH
	#---------------------------------------
		if [ "${SSMTP_SMTP_AUTH}" = "login" -o "${SSMTP_SMTP_AUTH}" = "cram-md5" ];
		then
			${SSMTPCOMMAND} -t -au "${SSMTP_SMTP_USERNAME}" -ap "${SSMTP_SMTP_PASSWORD}" -am "${SSMTP_SMTP_AUTH}"< ${FILE}
		else
			${SSMTPCOMMAND} -t < ${FILE}
		fi
	fi
else
#---------------------------------------
# keine Authentifizierung
#---------------------------------------
    ${SSMTPCOMMAND} -t < ${FILE}
fi

#---------------------------------------
# Fehler beim Versenden feststellen
#---------------------------------------
if [ "$?" != "0" ];
then
	# Fehler beim Versenden
	exit 3
else
	# Versenden erfolgreich
	exit 0
fi
