#!/bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/ssmtp_retry.sh                                            v0.1
#
# Mails mit Status "retry" versenden
#
# Creation:     2003-05-05  t_klingl
# Last Update:  2004-01-22  t_klingl
#------------------------------------------------------------------------------

#----------------------------------------------------
# Variablen inkludieren
#----------------------------------------------------

. /etc/ssmtp/ssmtp_skripte.conf
DATE=`date`

#---------------------------------------
# log (string)
#---------------------------------------
log ()
{
	TEXT=$1

	if [ "${SSMTP_LOGFILE}" != "" ]; then
		case "${SSMTP_LOGFILE}"
		in
			syslog) logger "ssmtp: ${TEXT}";;
			*)      echo "${DATE} ssmtp: ${TEXT}" >> ${SSMTP_LOGFILE};;
		esac
	fi
    
	return 1	
}

#----------------------------------------------------
# Welche Dateien liegen vor ?
#----------------------------------------------------
for FILES in `ls ${SSMTP_SPOOL_DIR} | grep '^.*retry[0-9]\+$'`
do
	/usr/local/bin/ssmtp_send.sh "${SSMTP_SPOOL_DIR}/${FILES}"
	
	if [ "$?" = "0" ];
	then
	    # alles ok, file kann geloescht werden
		log "mail ${FILES} sent successfully"
	    rm "${SSMTP_SPOOL_DIR}/${FILES}"
	else
	    # Versand gescheitert, ins Logfile eintragen
	    # Anzahl der Wiederholungsversuche & neuen Namen ermitteln
	    TRY=`echo "${FILES}" | sed 's/^\(.*\.retry\)\(.*\)$/\2/g' | sed 's/[^0-9]//g'`
	    BASE=`echo "${FILES}" | sed 's/^\(.*\.retry\)\(.*\)$/\1/g'`
	    NEXTTRY=`expr ${TRY} + 1`
	    
	    log "error sending mail ${FILES} ($?), attempt ${TRY}"
	    mv "${SSMTP_SPOOL_DIR}/${FILES}" "${SSMTP_SPOOL_DIR}/${BASE}${NEXTTRY}"
	fi
done

exit 0

