#!/bin/sh
#------------------------------------------------------------------------------
# Creation:     19.03.2005  Christian Raatz fli4l@schinkensaft.de
# Last Update:  02.04.2005
# Thx to:       mas, Thomas Unger, Thomas Klingler, Peter Schiefer
#------------------------------------------------------------------------------

. /var/run/faxsend.conf
. /var/run/fax.conf


DATE=`date -R`                                         # aktuelles Datum ermitteln
TIME=`date +%y%m%d%H%M`					# Zeit uebergeben                                           

#------------------------------------------------------------------------------
# Ein paar Checks etc.
#------------------------------------------------------------------------------

if [ "$FAXSEND_CUSTOMREDATE" = "yes" ]
   then
   REDATE=`date -R`
   else
   REDATE=``
fi

eval csid='$FAXRCV_'$FAXRCV_N'_CSID'
 
#------------------------------------------------------------------------------
# Erstellen der pop.cmd wenn FAXSEND_POPCHECK='yes'
# und kurzes einloggen auf dem pop3-server
#------------------------------------------------------------------------------

if [ "$FAXSEND_POPCHECK" = "yes" ]
	then
		echo -e "user $FAXSEND_MAILUSER\npass $FAXSEND_MAILPWD\r\nquit" > /tmp/pop.cmd
		netcat -i $FAXSEND_WAITSVR $FAXSEND_POPSVR $FAXSEND_POPPORT < /tmp/pop.cmd
fi

#------------------------------------------------------------------------------
# smtp.cmd vorbereiten 
#------------------------------------------------------------------------------
if [ "$FAXSEND_NOTIFYONLY" = "no" ]
	then
	{
			echo -e "helo $FAXSEND_SMTPSVR\r"
			echo -e "mail from: $FAXSEND_FROM\r"
			echo -e "rcpt to: $FAXSEND_TO\r"
			echo -e "data\r"
			echo -e "Date: $DATE\r"
			echo -e "From: $FAXSEND_FROM\r"
			echo -e "Reply-To: $FAXSEND_TO\r"
			echo -e "To: $FAXSEND_TO\r"
			echo -e "Subject: $FAXSEND_CUSTOMRE $REDATE\r"
			echo -e "\r"
			echo -e "Fax wurde empfangen fuer $csid\r"
	}  >> /tmp/smtp$TIME.cmd
	else
	{
			echo -e "helo $FAXSEND_SMTPSVR\r"
			echo -e "mail from: $FAXSEND_FROM\r"
			echo -e "rcpt to: $FAXSEND_NOTIFYADDR\r"
			echo -e "data\r"
			echo -e "Date: $DATE\r"
			echo -e "From: $FAXSEND_FROM\r"
			echo -e "Reply-To: $FAXSEND_NOTIFYADDR\r"
			echo -e "To: $FAXSEND_NOTIFYADDR\r"
			echo -e "Subject: $FAXSEND_CUSTOMRE $REDATE\r"
			echo -e "\r"
			echo -e "Fax wurde empfangen fuer $csid\r"
	  } >> /tmp/smtp$TIME.cmd
fi

#------------------------------------------------------------------------------
# Fax versandfertig machen
# -----------------------------------------------------------------------------

if [ "$FAXSEND_NOTIFYONLY" = "no" ]
	then
	if [ "$FAXSEND_GZIP" = "yes" ]
	then
		uuencode $1 $TIME.sff.gz >> /tmp/smtp$TIME.cmd
	else
		zcat $1 > /tmp/faxtmp.sff
		uuencode /tmp/faxtmp.sff $TIME.sff >> /tmp/smtp$TIME.cmd
	fi
fi

#------------------------------------------------------------------------------
# smtp.cmd abschliessen
#------------------------------------------------------------------------------

echo -e "\r\n.\r\nquit\r\nquit\r\nquit\r" >> /tmp/smtp$TIME.cmd

#------------------------------------------------------------------------------
# Fax mit netcat verschicken
# -----------------------------------------------------------------------------

netcat -w 30 $FAXSEND_SMTPSVR 25 < /tmp/smtp$TIME.cmd

#------------------------------------------------------------------------------
# Temporaere Dateien loeschen
# -----------------------------------------------------------------------------

rm /tmp/smtp$TIME.cmd

if [ "$FAXSEND_GZIP" = "no" ]
	then
		rm /tmp/faxtmp.sff
fi

