#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/htdocs/konto/index.cgi - main cgi-script for clients
#
# Package:      OnKonto - Version: 0.11
#
# Creation:     07/03/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
# Last Update:  07/27/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#----------------------------------------------------------------------------
# Changelog:
#
# 07/03/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - initial release
#
# 07/22/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - user based controlling
#
# 07/27/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - some code new sorted
#----------------------------------------------------------------------------

# Parse variables...
eval "`proccgi $*`"

workdir=`cat /etc/onkonto.workdir`
iplist=`cat $workdir/onkonto_iplist`
datum=`date +"%d.%m.%Y - %H:%M:%S"`

header1()
{
    echo "Content-Type: text/html; charset=iso-8859-1"
    echo "Cache-control: no-store"
    echo "Pragma: no-cache"
    echo "Expires: `date -Ru`"
    echo
}

header2()
{
    echo "<html><head><title>Linux-Router - Internetfreigabe</title></head><body><center>Linux-Router - Internetfreigabe<br><br>"
}

refresh()
{
    echo "<html><head><meta http-equiv="refresh" content="0; URL=index.cgi"><title>Linux-Router - Internetfreigabe</title>"
    echo "</head><body><center>Linux-Router - Internetfreigabe<br><br>"
    echo "PC wird online geschalten ...<BR>automatische Weiterleitung ...<BR><BR>"
    echo "Falls die automatische Weiterleitung nicht funktioniert, bitte <BR><BR>"
    echo "<a href=\"index.cgi\">hier klicken, um weiter zu kommen.</a>"
}


footer()
{
echo "</body>"
echo "</html>"
}

for ip in $iplist
do
    if [ "$ip" = "$REMOTE_ADDR" ]
    then
        ip_valid="1"
    fi
done

if [ "$ip_valid" = "1" ]
then

    case $FORM_action in

    online)

    /usr/local/bin/onkonto.sh online ${REMOTE_ADDR} ${FORM_user} ${FORM_pass} "Online by Webinterface"
      
    header1
    refresh
    footer
    ;;

    offline)

    /usr/local/bin/onkonto.sh offline ${REMOTE_ADDR} ${FORM_user} ${FORM_pass} "Offline by Webinterface"
      
    header1
    refresh
    footer

    ;;

    login)

    /usr/local/bin/onkonto.sh login ${REMOTE_ADDR} ${FORM_user} ${FORM_pass} "Login by Webinterface"
      
    header1
    refresh
    footer
    ;;


    logout)

    /usr/local/bin/onkonto.sh logout ${REMOTE_ADDR} ${FORM_user} ${FORM_pass} "Login by Webinterface"
      
    header1
    refresh
    footer

    ;;

    *)

        header1
        header2
        user=`cat $workdir/onkonto_${REMOTE_ADDR}`
        if [ $user = 0 ]
        then
            echo "<form action=\"index.cgi\" method=\"post\">"
            echo "<table width=300><tr><td>Datum</td><td>$datum</td></tr><tr><td>User:</td><td>"
            echo "<select name=\"user\" size=\"1\">"
            presel=`cat $workdir/onkonto_preselect_${REMOTE_ADDR}`
            idx=1
            while [ -e $workdir/onkonto_user_${idx}_name ]
            do
                getname=`cat $workdir/onkonto_user_${idx}_name`
                if [ "$idx" = "$presel" ]
                then
                    echo "<option selected value=\"${idx}\">$getname</option>"
                else
                    echo "<option value=\"${idx}\">$getname</option>"
                fi
                idx=`/usr/bin/expr $idx "+" 1`
            done
            echo "</td></tr>"
            echo "<tr><td>Passwort:</td><td><input name="pass" type="password" size="12" maxlength="12"></td></tr>"
            echo "<tr><td>IP:</td><td>${REMOTE_ADDR}</td></tr><tr><td>Status</td><td><font color="#C00000">abgemeldet</font>"
            echo "</td></tr><tr><td>Restguthaben</td><td>unbekannt</td></tr></table>"
            echo "</center><br><br><br>"
            echo "<center><table width=300><tr><td>"
            echo "<input type=\"hidden\" name=\"action\" value=\"login\">"
            echo "<input type=\"submit\" value=\"Anmelden\"></td></tr></table></center>"
        else

            remaining=`/usr/local/bin/onkonto.sh remain ${user}`
            pass=`cat $workdir/onkonto_user_${user}_pwd`
            STUNDEN=`expr $remaining "/" 3600`
            STDDIFF=`expr $remaining "%" 3600`
            MINUTEN=`expr $STDDIFF "/" 60`
            SEKUNDEN=`expr $STDDIFF "%" 60`
  
            if [ $STUNDEN -lt 10 ]; then
                STUNDEN=0$STUNDEN
            fi
            if [ $MINUTEN -lt 10 ]; then
                MINUTEN=0$MINUTEN
            fi
            if [ $SEKUNDEN -lt 10 ]; then
                SEKUNDEN=0$SEKUNDEN
            fi


            if [ -e "$workdir/onkonto_user_${user}_online" ]
            then
                #
                # Online
                #
                STATUS=online
                COLOR=00C000
                dis_on="disabled"
                dis_of=""
            else
                #
                # offline
                #
                STATUS=offline
                COLOR=C0C000
                if [ $remaining -gt 0 ]
                then
                    dis_on=""
                else
                    dis_on="disabled"
                fi
                dis_of="disabled"
            fi

            username=`cat $workdir/onkonto_user_${user}_name`
            echo "<table width=300><tr><td>Datum</td><td>$datum</td></tr><tr><td>User:</td><td>$username</td></tr>"
            echo "<tr><td>IP:</td><td>$ip</td></tr><tr><td>Status</td><td><font color="#$COLOR">$STATUS</font>"
            echo "</td></tr><tr><td>Restguthaben</td><td>$STUNDEN:$MINUTEN:$SEKUNDEN</td></tr></table>"
            echo "</center><br><br><br>"
            echo "<center><table width=300><tr><td align=left>"
            echo "<form action=\"index.cgi\" method=\"post\">"
            echo "<input type=\"hidden\" name=\"action\" value=\"online\">"
            echo "<input type=\"hidden\" name=\"user\" value=\"$user\">"
            echo "<input type=\"hidden\" name=\"pass\" value=\"$pass\">"
            echo "<input type=\"submit\" $dis_on value=\"Online gehen\"></form></td><td>&nbsp;</td><td>"
            echo "<form action=\"index.cgi\" method=\"post\">"
            echo "<input type=\"hidden\" name=\"action\" value=\"offline\">"
            echo "<input type=\"hidden\" name=\"user\" value=\"$user\">"
            echo "<input type=\"hidden\" name=\"pass\" value=\"$pass\">"
            echo "<input type=\"submit\" $dis_of value=\"Offline gehen\"></form></td><td>&nbsp;</td><td align=right>"
            echo "<form action=\"index.cgi\" method=\"post\">"
            echo "<input type=\"hidden\" name=\"action\" value=\"logout\">"
            echo "<input type=\"hidden\" name=\"user\" value=\"$user\">"
            echo "<input type=\"hidden\" name=\"pass\" value=\"$pass\">"
            echo "<input type=\"submit\" value=\"Abmelden\"></form></td></tr></table></center>"


        fi

    ;;

    esac

else

#
# This IP is not locked by OnKonto
#
header1
header2
  echo "Dieser PC mit der IP-Adresse $REMOTE_ADDR wird nicht &uuml;berwacht."
  echo "</center>"
fi
footer

