#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/htdocs/konto/index.cgi - control cgi-script for windows-program
#
# Package:      OnKonto - Version: 0.11
#
# Creation:     07/04/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
# Last Update:  07/22/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#----------------------------------------------------------------------------
# Changelog:
#
# 07/04/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - initial release
#
# 07/22/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - adapted to user-based controlling
#----------------------------------------------------------------------------

#
# control sends a string with the following format to the windows program:
#
# !OK![ip-address]![status]![remaining time]!OK!
#
# ip-address: ip-address from calling client, for verification
# status:     C = Connected to the router, but Offline (Logged in)
#             N = Not connected to the router (Logged Out)
#             O = Connected and online (Online)
#             X = Status unknown, calling client is not in OnKonto-ip-table
# rem. time:  remaining online time for this day
#
# commands for GET/POST-FORM:
#
# ac=of&us=<num>&ps=<pass>   =   Go Offline
# ac=on&us=<num>&ps=<pass>   =   Go Online
# ac=li&us=<num>&ps=<pass>   =   Log In
# ac=lo&us=<num>&ps=<pass>   =   Log Out


# Parse variables...
eval "`proccgi $*`"

workdir=`cat /etc/onkonto.workdir`
iplist=`cat $workdir/onkonto_iplist`

for ip in $iplist
do
    if [ "$ip" = "$REMOTE_ADDR" ]
    then
        ip_valid="1"
    fi
done

if [ "$ip_valid" = "1" ]
then

    retval="!OK!${REMOTE_ADDR}!X!${remaining}!OK!"
    remaining=`/usr/local/bin/onkonto.sh remain ${REMOTE_ADDR}`
    eval user='$FORM_us'
    eval pass='$FORM_ps'

    case $FORM_ac in

    li)

        if [ `cat $workdir/onkonto_${REMOTE_ADDR}` = 0 ]
        then
            if [ ! -e "$workdir/onkonto_user_${user}_ip" ]
            then
                if [ ! -e "$workdir/onkonto_user_${user}_online" ]
                then
                    if [ `cat $workdir/onkonto_user_${user}_pwd` = $pass ]
                    then
                        /usr/local/bin/onkonto.sh login ${REMOTE_ADDR} $user $pass "Login by ControlProgram"
                        retval="!OK!${REMOTE_ADDR}!C!${remaining}!OK!"
                    fi
                fi
            fi
        fi
    ;;

    on)

        if [ `cat $workdir/onkonto_${REMOTE_ADDR}` = $user ]
        then
          # if [ -e "$workdir/onkonto_user_${user}_ip" ]
          # then
                if [ ! -e "$workdir/onkonto_user_${user}_online" ]
                then
                    if [ `cat $workdir/onkonto_user_${user}_pwd` = $pass ]
                    then
                        if [ $remaining -gt 0 ]
                        then
                            /usr/local/bin/onkonto.sh online ${REMOTE_ADDR} $user $pass "Online by ControlProgram"
                            retval="!OK!${REMOTE_ADDR}!O!${remaining}!OK!"
                        fi
                    fi
                fi
          # fi
        fi
    ;;


    of)

        if [ `cat $workdir/onkonto_${REMOTE_ADDR}` = $user ]
        then
            if [ -e "$workdir/onkonto_user_${user}_ip" ]
            then
                if [ -e "$workdir/onkonto_user_${user}_online" ]
                then
                    if [ `cat $workdir/onkonto_user_${user}_pwd` = $pass ]
                    then
                        /usr/local/bin/onkonto.sh offline ${REMOTE_ADDR} $user $pass "Offline by ControlProgram"
                        retval="!OK!${REMOTE_ADDR}!C!${remaining}!OK!"
                    fi
                fi
            fi
        fi
    ;;


    lo)

        if [ `cat $workdir/onkonto_${REMOTE_ADDR}` = $user ]
        then
            if [ -e "$workdir/onkonto_user_${user}_ip" ]
            then
              # if [ ! -e "$workdir/onkonto_user_${user}_online" ]
              # then
                    if [ `cat $workdir/onkonto_user_${user}_pwd` = $pass ]
                    then
                        /usr/local/bin/onkonto.sh logout ${REMOTE_ADDR} $user $pass "Logout by ControlProgram"
                        retval="!OK!${REMOTE_ADDR}!N!${remaining}!OK!"
                    fi
              # fi
            fi
        fi
    ;;


    *)

        if [ -e "$workdir/onkonto_user_${user}_ip" ]
        then
            if [ -e "$workdir/onkonto_user_${user}_online" ]
            then
                retval="!OK!${REMOTE_ADDR}!O!${remaining}!OK!"
            else
                retval="!OK!${REMOTE_ADDR}!C!${remaining}!OK!"
            fi
        else
            retval="!OK!${REMOTE_ADDR}!N!${remaining}!OK!"
        fi
    ;;

    esac

    echo $retval
else
    echo "!OK!${REMOTE_ADDR}!X!0!OK!"
fi
