#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/htdocs/main_onkonto.sh - main cgi-script for administration
#
# Package:      OnKonto - Version: 0.11
#
# Creation:     07/03/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
# Last Update:  07/22/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#----------------------------------------------------------------------------
# Changelog:
#
# 07/03/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - initial release
#
# 07/03/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - edited the output
#
# 07/22/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - now onkonto is user-based
#----------------------------------------------------------------------------

SEC_REALM='onkonto'
SEC_ACTION='edit'
#. ./sec-lib.cgi
eval "`proccgi $*`"

proxyport=8118

workdir=`cat /etc/onkonto.workdir`
iplist=`cat $workdir/onkonto_iplist`
datum=`date +"%d.%m.%Y - %H:%M:%S"`

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo '<html><head>'
echo '<title>Linux-Router - Internetfreigabe-Verwaltung</title>'
echo '</head><body bgcolor="#FFFFFF" text="#000000"><center>'

echo "<table width=300><tr><td>Datum</td><td>$datum</td></tr></table><br><br>"

case $FORM_action in

ippreselect)

echo "${FORM_user}" > $workdir/onkonto_preselect_${FORM_ipaddress}
;;

save)

echo "${FORM_user}" > $workdir/onkonto_user_${FORM_userindex}_name

IFSORIG="$IFS"
IFS=:
set x $FORM_amount
stunde=`expr $2 "*" 3600`
minute=`expr $3 "*" 60`
amount=`expr $4 "+" $minute`
amount=`expr $amount "+" $stunde`

set x $FORM_maxamount
stunde=`expr $2 "*" 3600`
minute=`expr $3 "*" 60`
maxamount=`expr $4 "+" $minute`
maxamount=`expr $maxamount "+" $stunde`

set x $FORM_accum
stunde=`expr $2 "*" 3600`
minute=`expr $3 "*" 60`
accum=`expr $4 "+" $minute`
accum=`expr $accum "+" $stunde`
IFS="$IFSORIG"

echo "${maxamount}" > $workdir/onkonto_user_${FORM_userindex}_max
echo "${accum}" > $workdir/onkonto_user_${FORM_userindex}_accum
echo "${amount}" > $workdir/onkonto_user_${FORM_userindex}_amount

if [ -e "$workdir/onkonto_user_${FORM_userindex}_online" ]
then
  ok_date=`/bin/date +%s`
  echo ${ok_date} > $workdir/onkonto_user_${FORM_userindex}_online
fi


   if [ ${FORM_proxy} ]; then
      echo "" > $workdir/onkonto_user_${FORM_userindex}_proxy
   else
      if [ -e "$workdir/onkonto_user_${FORM_userindex}_proxy" ]
      then
        rm $workdir/onkonto_user_${FORM_userindex}_proxy
        if [ -e "$workdir/onkonto_user_${FORM_userindex}_ip" ]
        then
            ipnum=`cat $workdir/onkonto_user_${FORM_userindex}_ip`
            ok_netmask=`cat /etc/onkonto.netmask`
            /sbin/iptables -D INPUT -p tcp -s $ipnum --dport $proxyport -j REJECT
        fi
      fi
   fi

;;

esac

echo "<table><tr><td>User-ID</td><td>Aktiv</td><td>User</td><td>Passwort</td><td>Status</td>"
echo "<td>Guthaben</td><td>Max. G.H.</td><td><b>+</b>-Zeit</td><td>Proxy</td><td>Sichern</td></tr>"

idx=1
while [ -e "$workdir/onkonto_user_${idx}_amount" ]
do

    username=`cat $workdir/onkonto_user_${idx}_name`
    remaining=`/usr/local/bin/onkonto.sh remain ${idx}`

    STUNDEN=`expr $remaining "/" 3600`
    STDDIFF=`expr $remaining "%" 3600`
    MINUTEN=`expr $STDDIFF "/" 60`
    SEKUNDEN=`expr $STDDIFF "%" 60`

    if [ $STUNDEN -lt 10 ]; then
        STUNDEN=0$STUNDEN
    fi
    if [ $MINUTEN -lt 10 ]; then
        MINUTEN=0$MINUTEN
    fi
    if [ $SEKUNDEN -lt 10 ]; then
        SEKUNDEN=0$SEKUNDEN
    fi

    maxamount=`cat $workdir/onkonto_user_${idx}_max`

    MAXSTUNDEN=`expr $maxamount "/" 3600`
    MAXSTDDIFF=`expr $maxamount "%" 3600`
    MAXMINUTEN=`expr $MAXSTDDIFF "/" 60`
    MAXSEKUNDEN=`expr $MAXSTDDIFF "%" 60`

    if [ $MAXSTUNDEN -lt 10 ]; then
        MAXSTUNDEN=0$MAXSTUNDEN
    fi
    if [ $MAXMINUTEN -lt 10 ]; then
        MAXMINUTEN=0$MAXMINUTEN
    fi
    if [ $MAXSEKUNDEN -lt 10 ]; then
        MAXSEKUNDEN=0$MAXSEKUNDEN
    fi

    accamount=`cat $workdir/onkonto_user_${idx}_accum`

    ACCSTUNDEN=`expr $accamount "/" 3600`
    ACCSTDDIFF=`expr $accamount "%" 3600`
    ACCMINUTEN=`expr $ACCSTDDIFF "/" 60`
    ACCSEKUNDEN=`expr $ACCSTDDIFF "%" 60`

    if [ $ACCSTUNDEN -lt 10 ]; then
        ACCSTUNDEN=0$ACCSTUNDEN
    fi
    if [ $ACCMINUTEN -lt 10 ]; then
        ACCMINUTEN=0$ACCMINUTEN
    fi
    if [ $ACCSEKUNDEN -lt 10 ]; then
        ACCSEKUNDEN=0$ACCSEKUNDEN
    fi

    if [ -e "$workdir/onkonto_user_${idx}_proxy" ]
    then
       PROXY='checked="checked"'
    else
       PROXY=''
    fi

    if [ -e "$workdir/onkonto_user_${idx}_ip" ]
    then
        ip=`cat $workdir/onkonto_user_${idx}_ip`
        if [ -e "$workdir/onkonto_user_${idx}_online" ]
        then
            #
            # Online
            #
            STATUS=online
            STATUSPIC=online
            COLOR=00C000
        else
            #
            # Logged in, but offline
            #
            STATUS=offline
            STATUSPIC=login
            COLOR=C0C000
        fi
    else
        ip="<center>-</center>"
        #
        # Logged Out
        #
        STATUS="logged out"
        STATUSPIC=logout
        COLOR=C00000
    fi

    echo "<tr>"
    echo "<form action=\"main_onkonto.cgi\" method=\"post\">"
    echo "<input type=\"hidden\" name=\"action\" value=\"save\">"
    echo "<input type=\"hidden\" name=\"userindex\" value=\"$idx\">"
    echo "<td><center>$idx</center></td>"
    echo "<td><center><input type=\"checkbox\" name=\"active\" value=\"yes\" checked=\"checked\"></center></td>"
    echo "<td><input name=\"user\" type=\"text\" size=\"12\" maxlength=\"16\" value=\"$username\"></td>"
    echo "<td><input type=\"button\" name=\"changepwd\" value=\"&auml;ndern\" onClick=\"changepw($idx)\"></td>"
    echo "<td><center><img src=\"onkonto/${STATUSPIC}.gif\"></center></td>"
    echo "<td><input name=\"amount\" type=\"text\" size=\"8\" maxlength=\"8\" value=\"$STUNDEN:$MINUTEN:$SEKUNDEN\"></td>"
    echo "<td><input name=\"maxamount\" type=\"text\" size=\"8\" maxlength=\"8\" value=\"$MAXSTUNDEN:$MAXMINUTEN:$MAXSEKUNDEN\"></td>"
    echo "<td><input name=\"accum\" type=\"text\" size=\"8\" maxlength=\"8\" value=\"$ACCSTUNDEN:$ACCMINUTEN:$ACCSEKUNDEN\"></td>"
    echo "<td><center><input type=\"checkbox\" name=\"proxy\" value=\"yes\" $PROXY></center></td>"
    echo "<td><center><input type=\"submit\" value=\"OK\"></center></td>"
    echo "</form></tr>"


    idx=`/usr/bin/expr $idx + 1`
done
echo "</table>Legende: <img src=\"onkonto\logout.gif\"> = ausgeloggt - <img src=\"onkonto\login.gif\"> = eingeloggt - <img src=\"onkonto\online.gif\"> = online<br><br>"

echo "<table><tr><td><center>IP-Adresse</center></td><td>Bevorzugter User</td><td>Aktueller User</td><td><center>Speichern</center></td></tr>"

for ip in $iplist
do
echo "<tr>"
    echo "<form action=\"main_onkonto.cgi\" method=\"post\">"
    echo "<input type=\"hidden\" name=\"action\" value=\"ippreselect\">"
    echo "<input type=\"hidden\" name=\"ipaddress\" value=\"$ip\">"
    echo "<td>$ip</td><td>"
echo "<center><select name=\"user\" size=\"1\">"
            presel=`cat $workdir/onkonto_preselect_${ip}`
                if [ "$presel" = "0" ]
                then
                    echo "<option selected value=\"0\">- keiner -</option>"
                else
                    echo "<option value=\"0\">- keiner -</option>"
                fi
            idx=1
            while [ -e $workdir/onkonto_user_${idx}_name ]
            do
                getname=`cat $workdir/onkonto_user_${idx}_name`
                if [ "$idx" = "$presel" ]
                then
                    echo "<option selected value=\"${idx}\">$getname</option>"
                else
                    echo "<option value=\"${idx}\">$getname</option>"
                fi
                idx=`/usr/bin/expr $idx "+" 1`
            done
echo "</center></td><td><center>"
aktuser=`cat $workdir/onkonto_$ip`
if [ "$aktuser" = "0" ]; then
   echo "- keiner -"
else
   aktusername=`cat $workdir/onkonto_user_${aktuser}_name`
   echo "${aktusername}"
fi
echo "</center></td><td><input type=\"submit\" value=\"Speichern\"></td></form>"


echo "</tr>"
done
echo "</table>"
echo "</center></body></html>"



exit 0
