#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/bin/onkonto.sh - main shell-script for OnKonto
#
# Package:      OnKonto - Version: 0.11
#
# Creation:     07/03/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
# Last Update:  07/03/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#----------------------------------------------------------------------------
# Changelog:
#
# 07/03/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - initial release
#
# 07/22/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - added 'proxyport'-variable for easy adapting to other
#                  used proxies or other used ports
#                - new parameters: <command> <ip> <user> <pass> <logentry>
#                  for commands: login, logout, online, offline
#
# 07/27/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - dns resolving problem solved :o)
#----------------------------------------------------------------------------

workdir=`cat /etc/onkonto.workdir`
iplist=`cat $workdir/onkonto_iplist`
ok_date=`/bin/date +%s`
ok_netmask=`cat /etc/onkonto.netmask`

proxyport=8118


case $1 in

    check)

        for ip in $iplist
        do
            user=`cat $workdir/onkonto_${ip}`
            if [ ! $user = 0 ]
            then
                online_since=`cat $workdir/onkonto_user_${user}_online`
                remainfile=`cat $workdir/onkonto_user_${user}_amount`
                used_online=`expr ${ok_date} "-" ${online_since}`
                remaining=`expr $remainfile "-" ${used_online}`
                if [ "`expr $remaining \"<\" 0`" = "1" ]
                then
                    /usr/local/bin/onkonto.sh offlinex $ip "Offline by Timeout"
                else
                    if [ "`ping -c 1 $ip | grep \"0 packets received\"`" ]
                    then
                        /usr/local/bin/onkonto.sh logoutx $ip "Logout by Ping Unreachable"
                    fi
                fi
            fi
        done
    ;;

    accum)

        user_count=1
        while [ -e "$workdir/onkonto_user_${user_count}_amount" ]
        do
            maxamount=`cat $workdir/onkonto_user_${user_count}_max`
            if [ -e "$workdir/onkonto_user_${user_count}_online" ]
            then
                online_since=`cat $workdir/onkonto_user_${user_count}_online`
                online_time=`expr $ok_date "-" $online_since`
                maxamount=`expr $maxamount "+" $online_time`
            fi
            amount=`cat $workdir/onkonto_user_${user_count}_amount`
            accum=`cat $workdir/onkonto_user_${user_count}_accum`

            newamount=`expr $amount "+" $accum`
            if [ $newamount -gt $maxamount ]
            then
                newamount=$maxamount
            fi
            echo "$newamount" > $workdir/onkonto_user_${user_count}_amount
            user_count=`expr $user_count "+" 1`
        done
    ;;

    offline)

       # pass=`cat $workdir/onkonto_user_$3_pwd`
        user=`cat $workdir/onkonto_$2`
        if [ -e "$workdir/onkonto_user_$3_ip" ]
        then
            userip=`cat $workdir/onkonto_user_$3_ip`
        else
            userip=""
        fi
        if [ $2 = $userip ]
        then
            if [ $user = $3 ]
            then
               # if [ $pass = $4 ]
               # then
                    if [ -e "$workdir/onkonto_user_$3_online" ]
                    then
                        online_since=`cat $workdir/onkonto_user_$3_online`
                        remainfile=`cat $workdir/onkonto_user_$3_amount`
                        used_online=`expr ${ok_date} "-" ${online_since}`
                        remaining=`expr $remainfile "-" ${used_online}`
                        if [ "`expr $remaining \"<\" 0`" = "1" ]
                        then
                            remaining="0"
                        fi
                        rm $workdir/onkonto_user_$3_online
                        echo "$remaining" > $workdir/onkonto_user_$3_amount
                        /sbin/iptables -I FORWARD 1 -s $2 -d ! $ok_netmask -j REJECT
                        if [ ! -e "$workdir/onkonto_user_$3_proxy" ]
                        then
                           /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport 53 -j REJECT
                           /sbin/iptables -I INPUT 1 -p udp -s $2 --dport 53 -j REJECT
                           /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport $proxyport -j REJECT
                        fi
                        if [ -e "/etc/onkonto.logdir" ]
                        then
                            logdir=`cat /etc/onkonto.logdir`
                            logdate=`date +"%Y-%m-%d - %H:%M:%S"`
                            logname=`cat $workdir/onkonto_user_$3_name`
                            echo "$logdate  -  $logname  -  $2  -  $5" >> $logdir/onkonto_logfile
                        fi
                    fi
               # fi
            fi
        fi
    ;;

    offlinex)

        /sbin/iptables -I FORWARD 1 -s $2 -d ! $ok_netmask -j REJECT
        user=`cat $workdir/onkonto_$2`
        if [ ! -e "$workdir/onkonto_user_${user}_proxy" ]
        then
            /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport 53 -j REJECT
            /sbin/iptables -I INPUT 1 -p udp -s $2 --dport 53 -j REJECT
            /sbin/iptables -D INPUT -p tcp -s $2 --dport $proxyport -j REJECT
        fi
        online_since=`cat $workdir/onkonto_user_${user}_online`
        remainfile=`cat $workdir/onkonto_user_${user}_amount`
        used_online=`expr ${ok_date} "-" ${online_since}`
        remaining=`expr $remainfile "-" ${used_online}`
        if [ "`expr $remaining \"<\" 0`" = "1" ]
        then
            remaining="0"
        fi
        rm $workdir/onkonto_user_${user}_online
        echo "$remaining" > $workdir/onkonto_user_${user}_amount
        if [ -e "/etc/onkonto.logdir" ]
        then
            logdir=`cat /etc/onkonto.logdir`
            logdate=`date +"%Y-%m-%d - %H:%M:%S"`
            logname=`cat $workdir/onkonto_user_${user}_name`
            echo "$logdate  -  $logname  -  $2  -  $3" >> $logdir/onkonto_logfile
        fi
    ;;

    online)

        pass=`cat $workdir/onkonto_user_$3_pwd`
        user=`cat $workdir/onkonto_$2`
        if [ -e "$workdir/onkonto_user_$3_ip" ]
        then
            userip=`cat $workdir/onkonto_user_$3_ip`
        else
            if [ $pass = $4 ]
            then
                /usr/local/bin/onkonto.sh login $2 $user $pass "Login by direct Logout->Online"
                userip=$2
            else
                userip="XXXX"
            fi
        fi
        if [ $2 = $userip ]
        then
            if [ $user = $3 ]
            then
               # if [ $pass = $4 ]
               # then
                    if [ ! -e "$workdir/onkonto_user_$3_online" ]
                    then
                        remaining=`cat $workdir/onkonto_user_$3_amount`
                        if [ $remaining -gt 0 ]
                        then
                            echo "${ok_date}" > $workdir/onkonto_user_$3_online
                            /sbin/iptables -D FORWARD -s $2 -d ! $ok_netmask -j REJECT
                            if [ ! -e "$workdir/onkonto_user_$3_proxy" ]
                            then
                               /sbin/iptables -D INPUT -p tcp -s $2 --dport 53 -j REJECT
                               /sbin/iptables -D INPUT -p udp -s $2 --dport 53 -j REJECT
                               /sbin/iptables -D INPUT -p tcp -s $2 --dport $proxyport -j REJECT
                            fi
                            if [ -e "/etc/onkonto.logdir" ]
                            then
                                logdir=`cat /etc/onkonto.logdir`
                                logdate=`date +"%Y-%m-%d - %H:%M:%S"`
                                logname=`cat $workdir/onkonto_user_$3_name`
                                echo "$logdate  -  $logname  -  $2  -  $5" >> $logdir/onkonto_logfile
                            fi
                        fi
                    fi
               # fi
            fi
        fi
    ;;

    remain)

        #
        # new second parameter, not ip anymore but user id
        #

        remainfile=`cat $workdir/onkonto_user_$2_amount`
        if [ -e "$workdir/onkonto_user_$2_online" ]
        then
            online_since=`cat $workdir/onkonto_user_$2_online`
            used_online=`expr ${ok_date} "-" ${online_since}`
            remaining=`expr $remainfile "-" ${used_online}`
            if [ "`expr $remaining \"<\" 0`" = "1" ]
            then
                remaining="0"
            fi
        else
            remaining=$remainfile
        fi
        echo "$remaining"
    ;;

    logout)

        pass=`cat $workdir/onkonto_user_$3_pwd`
        user=`cat $workdir/onkonto_$2`
        if [ $user = $3 ]
        then
            if [ $pass = $4 ]
            then
                if [ -e "$workdir/onkonto_user_$3_online" ]
                then
                    /usr/local/bin/onkonto.sh offline $2 $user $pass "Offline by direct Online->Logout"
                fi
                if [ -e "$workdir/onkonto_user_$3_ip" ]
                then
                    rm $workdir/onkonto_user_$3_ip
                    echo "0" > $workdir/onkonto_$2
                    if [ -e "$workdir/onkonto_user_$3_proxy" ]
                    then
                        /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport $proxyport -j REJECT
                        /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport 53 -j REJECT
                        /sbin/iptables -I INPUT 1 -p udp -s $2 --dport 53 -j REJECT
                    fi
                    if [ -e "/etc/onkonto.logdir" ]
                    then
                        logdir=`cat /etc/onkonto.logdir`
                        logdate=`date +"%Y-%m-%d - %H:%M:%S"`
                        logname=`cat $workdir/onkonto_user_$3_name`
                        echo "$logdate  -  $logname  -  $2  -  $5" >> $logdir/onkonto_logfile
                    fi
                fi
            fi
        fi
    ;;

    logoutx)

        user=`cat $workdir/onkonto_$2`
        if [ -e "$workdir/onkonto_user_${user}_online" ]
        then
            /usr/local/bin/onkonto.sh offlinex $2 "Offline by Ping Unreachable"
        fi
        rm $workdir/onkonto_user_${user}_ip
        echo "0" > $workdir/onkonto_$2
        if [ -e "$workdir/onkonto_user_${user}_proxy" ]
        then
            /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport $proxyport -j REJECT
            /sbin/iptables -I INPUT 1 -p tcp -s $2 --dport 53 -j REJECT
            /sbin/iptables -I INPUT 1 -p udp -s $2 --dport 53 -j REJECT
        fi
        if [ -e "/etc/onkonto.logdir" ]
        then
            logdir=`cat /etc/onkonto.logdir`
            logdate=`date +"%Y-%m-%d - %H:%M:%S"`
            logname=`cat $workdir/onkonto_user_${user}_name`
            echo "$logdate  -  $logname  -  $2  -  $3" >> $logdir/onkonto_logfile
        fi
    ;;

    login)

        pass=`cat $workdir/onkonto_user_$3_pwd`
        user=`cat $workdir/onkonto_$2`
        if [ $user = 0 ]
        then
            if [ $pass = $4 ]
            then
                if [ ! -e "$workdir/onkonto_user_$3_ip" ]
                then
                    echo "$2" > $workdir/onkonto_user_$3_ip
                    echo "$3" > $workdir/onkonto_$2
                    if [ -e "$workdir/onkonto_user_$3_proxy" ]
                    then
                        /sbin/iptables -D INPUT -p tcp -s $2 --dport $proxyport -j REJECT
                        /sbin/iptables -D INPUT -p tcp -s $2 --dport 53 -j REJECT
                        /sbin/iptables -D INPUT -p udp -s $2 --dport 53 -j REJECT
                    fi
                    if [ -e "/etc/onkonto.logdir" ]
                    then
                        logdir=`cat /etc/onkonto.logdir`
                        logdate=`date +"%Y-%m-%d - %H:%M:%S"`
                        logname=`cat $workdir/onkonto_user_$3_name`
                        echo "$logdate  -  $logname  -  $2  -  $5" >> $logdir/onkonto_logfile
                    fi
                fi
            fi
        fi
    ;;

#    add)
#
#
#
#    ;;

esac

