#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/bin/setup-portfw.sh - setup portforwarding-rules
#
# Creation:     03.11.2002 tg
# Last Update:  $Id: setup-portfw-new.sh,v 1.6 2004/12/02 18:31:58 jw5 Exp $
#----------------------------------------------------------------------------

# setup-portfw up|down static [ip]
# setup-portfw up|down dynamic ip

. $PREFIX/etc/boot.d/base-helper
. $PREFIX/etc/rc.d/fwrules-helper

case $1 in
up)
    cmd=A
    ;;
*)
    cmd=D
    ;;
esac

pf_type=$2
pf_ip=$3

if [ $pf_type = dynamic -a -z "$pf_ip" ]
then 
    logger -s -t setup-portfw-new.sh "usage: $0 dynamic pf_ip"
    exit 1
fi

while read rule
do
    do_rule nat PREROUTING $cmd "$rule" '' exec_portfw_rule
done < $PREFIX/etc/portfw-new.conf
