#!/bin/sh
d_head1='<font face=verdana size=+2>'
d_head2='</font>'
d_thead1='<center><b><font color=ffffff face=verdana>'
d_thead2='</font></b></center>'
d_col_tborder='ffffff'
d_col_theadbg='000000'
d_col_theadbg2='ffffff'
d_col_tdefbg='f0f0f0'
d_col_tgroup1bg='6060ff'
d_col_tgroup2bg='ffff40'
d_col_tgroup3bg='c0c0ff'
d_col_tgroup4bg='ffffc0'
myname=`basename $0`
read wanip < /var/run/cgiconfig2_ip
refresh=300
setup=main_cgiconfig2.cgi
switch=cgiconfig2_switch.cgi
version=v0.97-1a

export SEC_REALM="cgiconfig2"
export SEC_ACTION="view"
./sec-lib.cgi
if [ "$?" != "0" ] ; then exit 1 ; fi

#read local hosts, ips and hostname from /boot/rc.cfg to tempfile
grep -v "localhost" /etc/hosts | grep -v "#" > /tmp/cgiconfig2.hosts

while read line
do
  ip="`echo $line | cut -d" " -f1`"
  name="`echo $line | cut -d" " -f2`"
done < /tmp/cgiconfig2.hosts

leasedir=`cat /tmp/cgiconfig2.dhcpdir`

cat $leasedir/dhcpd.leases | sed 's/\"//g;' > /tmp/cgiconfig2.hosts_dhcp
while read line
do

 if [ "`echo $line | cut -d" " -f1`" = "lease" ]
 then
  ip="`echo $line | cut -d" " -f2`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "client-hostname" ]
 then
  hostname="`echo $line | cut -d" " -f2 | cut -d";" -f1`"
  echo $ip $hostname >> /tmp/cgiconfig2.hosts
 fi

done < /tmp/cgiconfig2.hosts_dhcp

hostname=`cat /tmp/cgiconfig2.rname`

#parse variables...
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
 if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
 eval "param_$var"
done

if [ "$param_action" = "" ] ; then param_action=hosts ; fi

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store"
echo "Pragma: no-cache"
echo "Expires: `date -Ru`"
echo ""
echo "
<html>
<head>
 <title>OPT_CGICONFIG2 $version</title>
 <meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$refresh;url=$setup?action=$param_action&app=$param_app\">
  <style type=\"text/css\"><!--
   a { text-decoration: none }
   a:hover { color: #ff0000; text-decoration: underline}
   body { font-family: verdana}
  --></style>
</head>
<body link=0000a0 vlink=0000a0 alink=808080>
<br>
<center>
 <font face=verdana size=3>
  <table border=0 cellpadding=0 cellspaceing=0>
   <tr>
    <td> <a href=\"$myname?action=hosts\">online hosts</a> |</td>
    <td> <a href=\"$myname?action=inp\">input state</a> |</td>
    <td> <a href=\"$myname?action=fwrd\">portforwarding state</a> |</td>
    <td> <a href=\"cgiconfig2.html\">readme</a></td>
   </tr>
   <tr align=center>
    <td><a href=\"$myname?action=block\">block..</a></td>
    <td><a href=\"$myname?action=inp_new\">new..</a>
    <td><a href=\"$myname?action=fwrd_new\">new..</a></td>
    <td>&nbsp;</td>
   </tr>
  </table>
 </font>
</center>
<br><br>"



#host state
if [ "$param_action" = "hosts" ]
then
 echo "<center>$d_head1 online hosts $d_head2<br><br>

<table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td>$d_thead1 ip $d_thead2</td>
  <td>$d_thead1 host $d_thead2</td>
  <td>$d_thead1 state $d_thead2</td>"

 #read hosts
 while read ip name
 do
  if [ "$ip$name" != "" ]
  then
   echo " <tr>
   <td>$ip</td>
   <td>$name</td>"
   # arp auslesen und nur IP HWADRESS IFACE ausgeben
   /usr/sbin/arp -n | grep "$ip " > /tmp/cgiconfig2.arpout
   adress="" ; hwtype="" ; hwadress="" ; flag="" ; iface=""
   read adress hwtype hwadress flag iface < /tmp/cgiconfig2.arpout


   if [ "$name" = "$hostname" ]
   then
    echo "  <td><center><img src=cgiconfig2_ongreen.gif border=0 alt=\"Router\"></center></td>"
   else
    if [ "$hwadress" = "00:00:00:00:00:00" ] || [ "$hwadress" = "" ] || [ "$flag" != "C" ]
    then
     echo "  <td><center><a href=\"$switch?action=ping&host=$ip\"><img src=cgiconfig2_onred.gif border=0 alt=\"not connected\"></a></center></td>"
    else
     echo "  <td><center><a href=\"$switch?action=ping&host=$ip\"><img src=cgiconfig2_ongreen.gif border=0 alt=$hwadress></a></center></td>"
     fi
    fi
    echo " </tr>"
   fi
 done < /tmp/cgiconfig2.hosts
 echo "</table>
 <form name=ping action=$switch method=get>
 <input type=hidden name=host value=all>
 <input type=submit  name=action value=\"ping all\">
 </form>"
fi

if [ "$param_action" = "block" ]
then
 echo "<center> $d_head1 block clients $d_head2
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 ip $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 host $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 status $d_thead2 </td>
 </tr>"

 while read ip name
 do
  if [ "$ip$name" != "" ]
  then
   echo " <tr>
   <td>$ip</td>
   <td>$name</td>"
   state_host=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "fw-drp-log"`
   state_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "state RELATED,ESTABLISHED"`

   if [ "$state_host" = "" -a "$state_est" = "" ]
   then
     echo "<td><center><img src=cgiconfig2_ongreen.gif border=0>
     <a href=\"$switch?referrer=block&action=block_host&mode=block&host=$ip\"><img src=cgiconfig2_offred.gif border=0></a></center></td>"
   else
     echo "<td><center><a href=\"$switch?referrer=block&action=block_host&mode=unblock&host=$ip\">
     <img src=cgiconfig2_offgreen.gif border=0></a>
     <img src=cgiconfig2_onred.gif border=0></center></td>"
   fi
   echo "</tr>"
  fi
 done < /tmp/cgiconfig2.hosts
 echo "</table></center>"
fi


###############################
#          INPUT              #
###############################

#firewall input
if [ "$param_action" = "inp" ]
then
 echo "<center> $d_head1 firewall input $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 protocol $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 source port $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 destination port $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 delete $d_thead2 </td>
 </tr>"

	# Lese Anzahl der Eintrge in INPUT

	idxt=1
	num_inp=`/sbin/iptables -L INPUT -n --line-numbers | grep "^$idxt "`

	while [ "$num_inp" != "" ]
	do
		state_inp=`/sbin/iptables -L INPUT -n --line-numbers | grep "^$idxt " | grep -v "all" | grep -v "icmp" | grep "ACCEPT" | grep "0.0.0.0/0"`
		if [ "$state_inp" != "" ]
		then
		  i_num="`echo $state_inp | cut -d" " -f1`"
		  i_target="`echo $state_inp | cut -d" " -f2`"
		  i_proto="`echo $state_inp | cut -d" " -f3`"
		  i_source="`echo $state_inp | cut -d" " -f5`"
		  i_dest="`echo $state_inp | cut -d" " -f6`"
		  i_port1="`echo $state_inp | cut -d" " -f8`"
		  i_port2="`echo $state_inp | cut -d" " -f9`"

		  if [ "$i_port2" = "" ]; then i_port2=$i_port1 ; fi
		  echo "<tr><td>$i_proto</td>
		  <td>$i_port1</td>
  		  <td>$i_port2</td>
		  <td><center>
		  <a href=\"$switch?referrer=inp&action=del_inp&inp_rem=$i_num\">
		  <img src=cgiconfig2_del.gif border=0 alt=\"DELETE Rule\"></a></center></td></tr>"
		fi
		idxt=`expr $idxt + 1`
		num_inp=`/sbin/iptables -L INPUT -n --line-numbers | grep "^$idxt "`
	done
	echo "</table>"
fi



# Create new rule in input chain

if [ "$param_action" = "inp_new" ]
then
 echo "<center> $d_head1 create new input rule $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 Protokoll $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Port $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Aktion $d_thead2 </td>
 </tr>"

	# Lese Anzahl der Eintrge in INPUT

	idxn=1
	num_inp=`/sbin/iptables -L INPUT -n --line-numbers | grep "^$idxn "`

	while [ "$num_inp" != "" ]
	do
		idxn=`expr $idxn + 1`
		num_inp=`/sbin/iptables -L INPUT -n --line-numbers | grep "^$idxn "`
	done
	idxn=`expr $idxn - 2`

	echo "<tr><td><form name=create_inp action=$switch method=get>
		  <select name=\"protocol\">
			<option value=\"tcp\">TCP</option>
			<option value=\"udp\">UDP</option>
		  </select></td>
 	      <td><input type=text name=port size=8></td>
   	      <input type=hidden name=idx value=$idxn>
   	      <input type=hidden name=referrer value=inp_new>
		  <td><input type=submit name=action value=\"Create\"></td>
		  </form></tr></table>"
fi


###############################
#          FORWARD            #
###############################

#forward-chain
if [ "$param_action" = "fwrd" ]
then
 echo "<center> $d_head1 port forwarding $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 iface (default=def. route) $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 source port(range) $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 ip $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 destination port(range) $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 protocol $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 action $d_thead2 </td>
 </tr>"

 if [ -f /etc/portfw.conf ]
 then
 	echo "portfw.conf bereits vorhanden"
 else
	touch /etc/portfw.conf
	echo "Kein Portforwarding aktiviert - Datei wurde angelegt..."
 fi
 while read line
 do
	  fw_iface="`echo $line | cut -d" " -f1`"
   	  fw_sourcep="`echo $line | cut -d" " -f2`"
	  fw_ip="`echo $line | cut -d" " -f3`"
	  fw_destp="`echo $line | cut -d" " -f4`"
	  fw_proto="`echo $line | cut -d" " -f5`"
	  echo "<tr><td>$fw_iface</td>
 	  <td>$fw_sourcep</td>
 	  <td>$fw_ip</td>
   	  <td>$fw_destp</td>
 	  <td>$fw_proto</td>
	  <td><center>
	  <a href=\"$switch?referrer=fwrd&action=del_fwrd&sport=$fw_sourcep&ip=$fw_ip&dport=$fw_destp&proto=$fw_proto\">
	  <img src=cgiconfig2_del.gif border=0 alt=\"DELETE Rule\"></a></td></tr>"

done < /etc/portfw.conf
echo "</center></tr></table>"
fi


if [ "$param_action" = "fwrd_new" ]
then
 echo "<center> $d_head1 create new forward rule $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 protocol $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 source port $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 destination port $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 ip $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 action $d_thead2 </td>
 </tr>"

 echo "<tr><td><form name=create_fwrd action=$switch method=get>
	   <select name=\"protocol\">
	   	<option value=\"tcp\">TCP</option>
	   	<option value=\"udp\">UDP</option>
	   </select></td>
 	   <td><input type=text name=sport size=10></td>
  	   <td><input type=text name=dport size=10></td>
  	   <td><input type=text name=ip size=15></td>
  	   <input type=hidden name=referrer value=fwrd_new>
	   <td><input type=submit name=action value=\"ADD\"></td>
	   </form></tr></table>"
fi


if [ "$param_html" != "0" ]
then
 echo "</center>
 <br><br><br><br>
 <p align=right>
 <font face=verdana size=-2>
 Written by <a href=\"mailto:bosborros at web dot de\">Benjamin Hering</a><br>
 $version <a href=\"http://www.fli4l.de\" target=\"_blank\">www.fli4l.de</a></p>
 </body></html>"
fi