# !/bin/sh

#-----------------------------------------------------------------------------------
# /opt/files/usr/local/bin/faxprint.sh - druck und pdfen von gzipten sff dateien
#
# Creation:	30.10.2002 	Initialversion					VER: 0.1
# 	 	 4.11.2002 	Doku- und Kommentarnderungen
#				Debugoptionen implementiert			VER: 0.2
#		 8.11.2002  Druckpositionierung implementiert			VER: 0.4
#		10.11.2002	absolute Pfade fr die .ps Dateien  		VER: 0.5
#		30.05.2003  rem $1.prn im -t Abschnitt eingefgt  		VER: 0.7
#		29.09.2004  Kompletter Neuaufbau fr fli4l Version 2.1.8  	VER: 0.8
#		27.10.2004  Bugfix						VER: 0.81
#-----------------------------------------------------------------------------------



# her mit den Variablen
. /boot/rc.cfg

# und wir brauchen noch ein Dateinamen ohne suffix
FILENAME=`basename $1 | sed -e 's/\.sff\.gz//'`


# falscher Aufruf oder Hilfe?
if [ "$1" = "" ] || [ "$1" = "-h" ]  || [ "$1" = "-?" ]
	then
		echo "usage $0 [filename | -h ]"
		echo "      -h = help"
		exit 0
	fi

# wir packen aus
cat $FILENAME.sff.gz | gzip -d >/tmp/$FILENAME.sff

# wir machen ein  Postscriptfile
sff2misc -p /tmp/$FILENAME.sff /tmp/$FILENAME

# wir machen ein PDF-File wenn es sein soll
if [ "$FAXPRINT_MAKE_PDF" = "yes" ]
	then
		gs -sDEVICE=pdfwrite -sOutputFile=/data/fax/$FILENAME.pdf -dBATCH -dNOPAUSE -q /opt/files/usr/local/bin/margins.ps /tmp/$FILENAME.ps
	fi

# wir machen ein Druckerfile
gs -sDEVICE=$FAXPRINT_PRINTER_TYP -sOutputFile=/tmp/$FILENAME.prn -dBATCH -dNOPAUSE -q /opt/files/usr/local/bin/margins.ps /tmp/$FILENAME.ps

# und ab zum Drucker
lpr -P$FAXPRINT_PRINTER_QUEUE /tmp/$FILENAME.prn

# Muell aufraeumen
rm /tmp/$FILENAME.sff
rm /tmp/$FILENAME.prn
rm /tmp/$FILENAME.ps

