#!/bin/sh
d_head1='<font face=verdana size=+2>'
d_head2='</font>'
d_thead1='<center><b><font color=ffffff face=verdana>'
d_thead2='</font></b></center>'
d_col_tborder='ffffff'
d_col_theadbg='000000'
d_col_theadbg2='ffffff'
d_col_tdefbg='f0f0f0'
d_col_tgroup1bg='6060ff'
d_col_tgroup2bg='ffff40'
d_col_tgroup3bg='c0c0ff'
d_col_tgroup4bg='ffffc0'
myname=`basename $0`
read wanip < /var/run/cgiconfig2_ip
refresh=-1
setup=main_cgiconfig2.cgi
state_fwrd_num=0
state_pfw_num=0
switch=cgiconfig2_switch.cgi
version=v0.9

export SEC_REALM="cgiconfig2"
export SEC_ACTION="set"
./sec-lib.cgi
if [ "$?" != "0" ] ; then exit 1 ; fi

#read client ips and hostnames from rc.cfg to tempfile
grep -v "localhost" /etc/hosts | grep -v "#" > /tmp/cgiconfig2.hosts

while read line
do
  ip="`echo $line | cut -d" " -f1`"
  name="`echo $line | cut -d" " -f2`"
done < /tmp/cgiconfig2.hosts

leasedir=`cat /tmp/cgiconfig2.dhcpdir`

cat $leasedir/dhcpd.leases | sed 's/\"//g;' > /tmp/cgiconfig2.hosts_dhcp
while read line
do

 if [ "`echo $line | cut -d" " -f1`" = "lease" ]
 then
  ip="`echo $line | cut -d" " -f2`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "client-hostname" ]
 then
  hostname="`echo $line | cut -d" " -f2 | cut -d";" -f1`"
  echo $ip $hostname >> /tmp/cgiconfig2.hosts
 fi

done < /tmp/cgiconfig2.hosts_dhcp

hostname=`cat /tmp/cgiconfig2.rname`
FWRD_HOST_WHITE=`cat /tmp/cgiconfig2.white`
nwadress=`cat /tmp/cgiconfig2.nwadr`
idx=`cat /tmp/cgiconfig2.idx`

#read network-adress from where all clients have access to Internet (blacklist only)
state_fwl_all=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$nwadress " | grep "ACCEPT" | grep "0.0.0.0/0" | grep "all"`

#set command line parameters
if [ "$*" != "" ] ; then QUERY_STRING=$* ; fi

#parse variables...
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
 if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
 eval "param_$var"
done

if [ "$param_help" != "" ] ; then refresh=-1 ; fi

if [ "$param_html" != "0" ]
then
 echo "Content-Type: text/html; charset=iso-8859-1
 Cache-control: no-store
 Pragma: no-cache
 Expires: `date -Ru`
 "
 echo "
 <html>
 <head>
  <title>OPT_cgiconfig2 $version</title>
  <meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$refresh;url=$setup?action=$param_referrer&app=$param_app\">
   <style type=\"text/css\"><!--
    a { text-decoration: none }
    a:hover { color: #ff0000; text-decoration: underline}
    body { font-family: verdana}
   --></style>
 </head>

 <body>
 <br>
 <center><b><big>"
fi



############################################
#				HOSTS					   #
############################################
if [ "$param_action" = "ping" ] || [ "$param_action" = "ping+all" ]
then
 if [ "$param_referrer" = "" ] ; then param_referrer=hosts; fi

 if [ "$param_host" = "all" ]
 then
  echo "<table border=\"0\"><tr><td><pre>"
  while read ip
  do
   ping -c 1 $ip &
  done < /tmp/cgiconfig2.hosts
  sleep 10
  echo "</pre></td></tr></table>"
 else
   echo "<pre>"
   ping -c 1 $param_host
   echo "</pre><hr>"
 fi
fi


case $param_mode
in
 block)
	if [ "$param_html" != "0" ]
	then
		echo "  <font color=008000>ip $param_host blocked...</font><br>"
	else
		echo "    ip $param_host blocked..."
	fi

 	state_host=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_host " | grep "FORWARD-reject-log"`
	state_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_host " | grep "state RELATED,ESTABLISHED"`
	if [ "$state_host" = "" -a "$state_est" = "" ]
	then
		/sbin/iptables -I FORWARD 1 -p all -s $param_host -m state --state ESTABLISHED,RELATED -j FORWARD-reject-log
		/sbin/iptables -I FORWARD 1 -p all -s $param_host -j FORWARD-reject-log
	fi
;; 
 unblock)
	if [ "$param_html" != "0" ]
	then
		echo "  <font color=008000>ip $param_host removed from blocklist...</font><br>"
	else
		echo "    ip $param_host removed from blocklist..."
	fi

 	state_host=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_host " | grep -v "state RELATED,ESTABLISHED" | grep "FORWARD-reject-log"`
	state_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_host" | grep "state RELATED,ESTABLISHED"`
	if [ "$state_host" != "" -a "$state_est" != "" ]
	then
		num_fw=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_host " | grep -v "state RELATED,ESTABLISHED" | grep "FORWARD-reject-log" | sed "s/[FORWARD].*//"`
		/sbin/iptables -D FORWARD $num_fw

		num_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_host " | grep "state RELATED,ESTABLISHED" | sed "s/[FORWARD].*//"`
		/sbin/iptables -D FORWARD $num_est
	fi
;;
esac

############################################
#				INPUT					   #
############################################

# del input rule
if [ "$param_action" = "del_inp" ]
then

  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000>input rule no. $param_inp_rem removed...</font><br>"
  else
   echo "    input rule no. $param_inp_rem removed..."
  fi
  /sbin/iptables -D INPUT $param_inp_rem
fi

# create input rule
if [ "$param_action" = "Create" ]
then

  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000>input rule for port $param_port created...</font><br>"
  else
   echo "    input rule for port $param_port created..."
  fi
  /sbin/iptables -I INPUT $param_idx -p $param_protocol --dport $param_port -j ACCEPT

fi


############################################
#				FORWARD					   #
############################################

# create forward rule
if [ "$param_action" = "ADD" ]
then
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000>forward rule: $param_sport -> $param_ip:$param_dport $param_proto created...</font><br>"
  else
   echo "forward rule: $param_sport -> $param_ip:$param_dport $param_proto created..."
  fi
  echo "default $param_sport $param_ip $param_dport $param_protocol" >> /etc/portfw.conf
  setup-portfw.sh
fi


# delete forward rule
if [ "$param_action" = "del_fwrd" ]
then
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000>forward rule: $param_sport -> $param_ip:$param_dport $param_proto removed...</font><br>"
  else
   echo "forward rule: $param_sport -> $param_ip:$param_dport $param_proto removed..."
  fi
  while read line
  do
	state_fwrd=`echo $line | grep "$param_sport" | grep "$param_dport" | grep "$param_ip" | grep "$param_proto"`
	if [ "$state_fwrd" = "" ]
	then
		echo $line >> /tmp/portfw.conf
    fi
  done < /etc/portfw.conf
cp /tmp/portfw.conf /etc/portfw.conf
rm /tmp/portfw.conf
setup-portfw.sh
fi


#setup
if [ "$param_action" = "setup" ]
then
 if [ "$param_referrer" = "" ] ; then param_referrer=setup; fi
fi


if [ "$param_html" != "0" ]
then
 echo "</big></b></center>
 <br><br><br><br>
 <p align=right>done.<br><a href=\"$setup?action=$param_referrer&app=$param_app\">Continue...</a><br><br>
 <font face=verdana size=-2>
 Written by <a href=\"mailto:bosborros at web dot de\">Benjamin Hering</a><br>
 $version <a href=\"http://www.fli4l.de\" target=\"_blank\">www.fli4l.de</a></p>
 </body></html>"
fi

if [ -f /tmp/cgiconfig2.hosts ] ; then rm /tmp/cgiconfig2.hosts ; fi