#!/bin/sh

. /boot/rc.cfg

Datei=$1

Bez=`echo $Datei | cut -d"." -f1 | cut -d"/" -f4`

tail --lines=1 /data/fax/mfax.log > /tmp/fe1

Datum=`cat /tmp/fe1 | cut -d" " -f1`
Uhrzeit=`cat /tmp/fe1 | cut -d" " -f2`
SENDER=`cat /tmp/fe1 | cut -d" " -f3`
PAGES=`cat /tmp/fe1 | cut -d" " -f4`
DATUMKURZ=`/bin/date +"%Y%m%d"`
DATUMLANG=`/bin/date +"%a, %d %b %Y"`
ZEIT=`/bin/date +"%H%M"`
ZEITLANG=`/bin/date +"%H:%M:%S"`

NAME="--"

# SENDER identifizieren
Ausgabe=`grep $SENDER /etc/faxnummer | cut -f 1,2 -d ' ' > /tmp/kennung`	      
VAR_COUNT=`grep -c "" /tmp/kennung`
NAME=""
if [ $VAR_COUNT -gt 0 ]; then
	# Name auslesen und als Kennung speichern, falls Kennung ungleich "--"
	while read nummer name
		do
		if [ $name != "--" ]; then
		NAME=$name
		fi		
	done < /tmp/kennung
	else
	echo "$kennung --" >> /etc/faxnummer
fi


# Faxdatei sichern und entpacken
cp -f $Datei $FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.sff.gz
/usr/local/bin/gzip -d $FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.sff.gz > /dev/null


# Exchange-Notiz vorbereiten
> /tmp/notiz
echo "Hallo," > /tmp/notiz
echo "" >> /tmp/notiz
echo "es wurde ein neues Fax von $SENDER $NAME empfangen!" >> /tmp/notiz
echo "" >> /tmp/notiz
echo "Ihr Exchange-Fax-Connector" >> /tmp/notiz
echo "" >> /tmp/notiz

cat /tmp/notiz > /tmp/mailing

if [ "$FAXXCG_EX_SFF" = yes -a "$FAXXCG_EX" = yes ]
then
	# Fax der Exchange-Notiz hinzufuegen
	/usr/local/bin/uuencode $FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.sff fax.sff >> /tmp/notiz
fi

if [ "$FAXXCG_BK_PDF" = yes -o "$FAXXCG_EX_PDF" = yes ]
then
	# wir machen ein  Postscriptfile
	/usr/local/bin/sff2misc -p $FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.sff /tmp/ps

	# wir machen ein PDF und hngen es an.
	gs -dSAFER -dCompatibilityLevel=1.4 -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.pdf -dSAFER -dCompatibilityLevel=1.4 -c .setpdfwrite -f /tmp/ps.ps
	if [ "$FAXXCG_EX_PDF" = yes ]
	then	
		/usr/local/bin/uuencode $FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.pdf fax.pdf>> /tmp/notiz
	fi
fi

# if [ "$FAXXCG_JPG" = yes ]
# then

# # JPGs erstellen
# /usr/local/bin/sff2misc -j $FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-000.sff /tmp/sff > /dev/null

# # Sichern der JPGS
# start="1"
# while [ $start -le $PAGES ] ; do
# 	if [ $start -le "9" ] ; then
# 		num="00"$start
# 	else
# 		num="0"$start
# 	fi
# 	datei_alt_jpg="/tmp/sff.$num.jpg"
# 	datei_jpg="$FAXXCG_BK_MOUNT/$SENDER-$DATUMKURZ-$ZEIT-$num.jpg"
# 
# 	# JPGs sichern
# 	mv -f $datei_alt_jpg $datei_jpg
# 	
# 	# JPGs der Exchange-Notiz hinzufuegen
# 	/usr/local/bin/uuencode $datei_jpg Seite$num.jpg >> /tmp/notiz
# 	start=`expr $start + 1`
# done
# fi

if [ "$FAXXCG_EX" = yes ]
then
	rnd=`expr $RANDOM + 10999`
	echo "Received: by data.datext.de" > /tmp/exchange
	echo "	      id <01C2AA0A.164$rnd@$data.datext.de>; $DATUMLANG $ZEITLANG +0100" >> /tmp/exchange
	echo "Subject: Fax von $SENDER $NAME" >> /tmp/exchange
	echo "Date: $DATUMLANG $ZEITLANG +0100" >> /tmp/exchange
	echo "From: Exchange-Fax-Connector <$FAXXCG_EX_MAIL>" >> /tmp/exchange
	echo "" >> /tmp/exchange
	
	# Exchange-Notiz kopieren
	cat /tmp/exchange /tmp/notiz > /tmp/$SENDER-$DATUMKURZ-$ZEIT-000.eml
	cp /tmp/$SENDER-$DATUMKURZ-$ZEIT-000.eml $FAXXCG_EX_MOUNT/$SENDER-$DATUMKURZ-$ZEIT.eml
fi

# Windows-Informationsdienst
if [ "$FAXXCG_MES" = yes ]
then
	cat /tmp/mailing | smbclient -M $FAXXCG_MES_PC -U Fax4YOU > /dev/null
fi






