#!/bin/sh
# Change Username and Password for PPPOE-Circuit
# (c) 2004 Helmut Hummel <luigi19@gmx.net>
# Version 0.3, Status: beta
# last change: <!--DATE-->16.02.2005<!--/DATE-->

# remove # in the following lines for debugging
exec 2> /dev/console                          
# set -x

# variablen einlesen
myname=`basename $0`
C=/usr/local/bin/dslctrl.sh
efile=/var/log/dslctrl.error

eval "`proccgi $*`"
if [ -z "$FORM_action" ]
then
  FORM_action="view"
fi

SEC_REALM='pppoe'
SEC_ACTION="$FORM_action"

. ./sec-lib.cgi

cat << OUTPUT
Content-Type: text/html; charset=iso-8859-1
Cache-control: no-store
Pragma: no-cache
Expires: `date -Ru`

<html><head>
<LINK REL=STYLESHEET TYPE="text/css" HREF="dsl_change.css">
<title>DSL-Circuits verwalten</title>
</head><body>

<br>
<table border="0" cellpadding="5" cellspacing="0" width="90%" bgcolor="f0f0f0" bordercolor="ffffff" align="center">
<tr class="heading">
    <td class="heading" colspan="5">
        <div><b>DSL-Circuits:</b><div>
    </td>
</tr>

OUTPUT

case "$FORM_action" in
  circuit)
     if [ -n "$FORM_nr" ]
     then
       name=`$C show | sed 's/\*//' | grep -n "" | grep ^$FORM_nr | cut -d":" -f2`
       $C circuit $name > $efile &
       FORM_action=view
     fi
     ;;
  delete)
     if [ -n "$FORM_name" ]
     then
       $C del $FORM_name > $efile
       FORM_action=view
     fi
     ;;
  add | change)
     if [ -n "$FORM_submit" ]
     then
       if [ -n "$FORM_name" -a -n "$FORM_user" -a -n "$FORM_pass" ]
       then
         # Sind im Circuit-Namen unerlaubte Zeichen?
         if [ -n `echo $FORM_name | grep -ve [^-@_.\\#%/[:alnum:]]` -a \
              -n `echo $FORM_user | grep -ve [^-@_.\\#%/[:alnum:]]` -a \
              -n `echo $FORM_pass | grep -ve [^-@_.\\#%/[:alnum:]]` ]
         then
           $C $FORM_action $FORM_name $FORM_user $FORM_pass > $efile
           # Wenn kein Fehler, dann Circuit bersicht anzeigen
           if ! cat $efile|grep -q ^error
           then
             FORM_action=view
           fi
         else
           echo 'error:Wrong Circuitname, Username or Password! Only numbers, letters and ".-@_\#%/" are allowed.' > $efile
         fi

       else
         echo "error:Circuit, Username and Password required!" > $efile
       fi
     else
       FORM_user=`grep ^\"$FORM_name\" /var/run/pppoe-circuits.conf | cut -d" " -f2 | sed "s/\"//;s/\"//"`
       FORM_pass=`grep ^\"$FORM_user\" /etc/ppp/pap-secrets | cut -d" " -f5 | sed "s/\"//;s/\"//"`
     fi

     if [ "$FORM_action" != "view" ]
     then
       if [ "$FORM_action" = "add" ]
       then
         name="<input name=\"name\" type=\"text\" size=\"60\" maxlength=\"15\" value=\"$FORM_name\">"
       else
         name="$FORM_name<input type=\"hidden\" name=\"name\" value=\"$FORM_name\">"
       fi
       echo "<tr class="content"><td colspan=\"5\"><table>
         <form method=\"GET\">
           <tr>
             <td>Circuit:</td>
             <td>$name</td>
           </tr>
           <tr>
             <td>username:</td>
             <td><input name=\"user\" type=\"text\" size=\"60\" maxlength=\"128\" value=\"$FORM_user\"></td>
           </tr>
           <tr>
             <td>password:</td>
             <td><input name=\"pass\" type=\"password\" size=\"60\" maxlength=\"128\" value=\"$FORM_pass\"></td>
             <td>
             <input type=\"hidden\" name=\"submit\" value=\"yes\">
             <input type=\"submit\" name=\"action\" value=\"$FORM_action\">
             </td>
           </tr>
         </form></table></td></tr>"
       fi
     ;;
esac

case "$FORM_action" in
  view)
    echo '<tr class="content"><td>
          <table>'
    # circuits
    circuits=`$C show | grep -n "" | sed 's/^/<tr><td class="space">\&nbsp;<\/td><td class="inner"><a href="'$myname'?action=circuit\&nr=/; s/:/">/;s/\*//;
      s/$/<\/a><\/td><\/tr>/'`
    circuits="$circuits <tr><td class=\"space\">&nbsp;</td><td class=\"inner\"><a href=\"$myname?action=add\">create&nbsp;new</a></td></tr>"
    aktcirc=`$C show | grep -n ^\* | cut -d":" -f1`
    circuits=`echo "$circuits" | sed '/nr='$aktcirc'/ s/<td/<td id="selected" /'`
    echo $circuits
    echo '</table></td>'
    echo '<td>
          <table width="80%" class="inner">'

    # edit table
    echo `$C show | sed 's/^/<tr><td class="button"><a href="'$myname'?action=change\&name=/; s/\*//;
      s/$/">edit<\/a><\/td><\/tr>/'`
    echo '<tr><td>&nbsp;</td></tr></table></td>'
    echo '<td>
          <table width="80%" class="inner">'

    # delete table
    echo `$C show | sed 's/^/<tr><td class="button"><a href="'$myname'?action=delete\&name=/; s/\*//;
      s/$/">delete<\/a><\/td><\/tr>/'`
    echo '<tr><td>&nbsp;</td></tr></table></td><td width="100%"></td><td></td></tr>'
    ;;
esac

if [ -f $efile ]
then
  error=`cat $efile | cut -d":" -f2`
  ID=`cat $efile | cut -d":" -f1`
  rm $efile
fi

cat << OUTPUT

<tr class="heading">
<td class="heading" id="$ID" colspan="4">&nbsp;$error</td>
<td class="heading" id="author" colspan="1">by Helmut Hummel <a href="mailto:luigi19@gmx.net">&lt;luigi19@gmx.net&gt;</a></td></tr>
</table>
</body></html>

OUTPUT



# End of script