#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/bin/dslctrl.sh
#
# Creation:     17.10.2004
# Last Update:  v 0.3e <!--DATE-->16.02.2005<!--/DATE-->
#----------------------------------------------------------------------------

restart ()
{
  kill `cat /var/run/ppp0.pid` > /dev/nul      # kill pppd
  kill `cat /var/run/imond.pid` > /dev/nul     # kill imond
  sleep 5
  /usr/local/bin/imond-restart.sh > /dev/nul   # restart imond
  port=`cat /var/run/imond.port`
  dialmode=`cat /var/run/pppoe.dialmode`
  if ! /sbin/route -n | grep -q '^0\.0\.0\.0'  # set default route if necessary
  then
  { echo "dialmode $dialmode";  echo "quit"; } | netcat localhost $port > /dev/nul
  fi
}

use ()
{
  DSL_NEWUSER=`grep ^$1 /var/run/pppoe-circuits.conf | cut -d" " -f2`
  DSL_OLDUSER=`grep ^user /etc/ppp/peers/circuit.pppoe | sed 'suser '`
  if [ "$DSL_NEWUSER" != "$DSL_OLDUSER" ]
  then
    if ! grep -q ^$DSL_NEWUSER /etc/ppp/pap-secrets
    then
      echo "error:no password found for user: $DSL_NEWUSER"
      unlock
      exit 1
    fi
    sed "s$DSL_OLDUSER$$DSL_NEWUSER" /etc/ppp/peers/circuit.pppoe > /tmp/tmp.ppp
    mv /tmp/tmp.ppp /etc/ppp/peers/circuit.pppoe
    OLD_CIRCUIT=`grep $DSL_OLDUSER$ /var/run/pppoe-circuits.conf | cut -d" " -f1 | sed 's";s"'`
    NEW_CIRCUIT=`echo $1 | sed 's";s"'`
    sed "s$OLD_CIRCUIT$NEW_CIRCUIT" /etc/imond.conf > /tmp/tmp.imond
    mv /tmp/tmp.imond /etc/imond.conf
    echo "info:circuit changed to $1"
    restart
  else
    echo "info:nothing changed"
    unlock
    exit 1
  fi
}

change ()
{
  DSL_NEWUSER=$2
  DSL_NEWPASS=$3
  DSL_OLDUSER=`grep ^$1 /var/run/pppoe-circuits.conf | cut -d" " -f2`
  DSL_ACTIVEUSER=`grep ^user /etc/ppp/peers/circuit.pppoe | sed 'suser '`
  sed "s$1 $DSL_OLDUSER$1 $DSL_NEWUSER" /var/run/pppoe-circuits.conf > /tmp/tmp.circ
  mv /tmp/tmp.circ /var/run/pppoe-circuits.conf
  if grep -q ^$DSL_OLDUSER /etc/ppp/pap-secrets
  then
    DSL_OLDPASS=`grep ^$DSL_OLDUSER /etc/ppp/pap-secrets | cut -d" " -f5`
    sed "s$DSL_OLDUSER  \*  $DSL_OLDPASS$DSL_NEWUSER  *  $DSL_NEWPASS" /etc/ppp/pap-secrets > /tmp/tmp.pap
    mv /tmp/tmp.pap /etc/ppp/pap-secrets
  else                                   # wenn nicht in secrets, erzeuge Eintrag
    echo "$DSL_NEWUSER  *  $DSL_NEWPASS  *" >> /etc/ppp/pap-secrets
  fi
  if [ "$DSL_OLDUSER" = "$DSL_ACTIVEUSER" ]
  then
    sed "s$DSL_OLDUSER$DSL_NEWUSER" /etc/ppp/peers/circuit.pppoe > /tmp/tmp.ppp
    mv /tmp/tmp.ppp /etc/ppp/peers/circuit.pppoe
    echo "info:username and password of $1 changed"
    restart
  else
    echo "info:username and password of $1 changed"
  fi
}

lock ()
{
  echo $$ > /var/lock/dsl.lck
}
unlock ()
{
  [ -f /var/lock/dsl.lck ] && rm /var/lock/dsl.lck
}

testlock ()
{
  # check if lockfile is stale...
  [ -f /var/lock/dsl.lck ] && {
    ps|grep -v "grep"|grep -q `cat "/var/lock/dsl.lck"` || {
      logger -p user.warning -t dslctrl Stale lockfile found and removed
      rm -f "/var/lock/dsl.lck"
    }
  }
  count=0
  while [ -f /var/lock/dsl.lck ]  # wait for other instance to remove lock
  do
    sleep 1
    count=`expr $count + 1`
      [ "$count" -ge "20" ] && {
        echo "error:Other instance running or stale lockfile"
        exit 1
      }
done
}

# Start Skript

#set -x

# Sind reservierte Zeichen benutzt worden?
for tv in $*
do
  if echo $tv | grep -qe [^-@_.\\#%/[:alnum:]]
  then
    echo 'error:Wrong Circuitname, Username or Password! Only numbers, letters and ".-@_\#%/" are allowed.'
    unlock
    exit 1
  fi
done

case "$1" in
  show | del | circuit | change)
    # sind Circuits konfiguriert?
    if [ ! -f /var/run/pppoe-circuits.conf ]
    then
      echo "error:No configured circuits found, try \"dslctrl.sh add ... \""
      unlock
      exit 1
    fi
    ;;
esac

case "$1" in
  change | del | circuit)
    # gibt es diesen circuit?
    if ! grep -q ^\"$2\" /var/run/pppoe-circuits.conf
    then
      echo "error:No circuit named \"$2\" found"
      unlock
      exit 1
    fi
    ;;
esac

case "$1" in
  change | add)
    # alle Parameter angegeben?
    if [ -z "$4" ]
    then
      echo "error:You have to specify circuit, username and password"
      unlock
      exit 1
    fi
    # Existiert der username in den secrets und es ist nicht der, der ge&auml;ndert werden soll?
    if [ -n "`grep ^\\"$3\\" /etc/ppp/pap-secrets`" -a \
       -z "`grep ^\\"$2\\" /var/run/pppoe-circuits.conf | grep \\"$3\\"`" ]
    then
      echo "error:Username already exists"
      unlock
      exit 1
    fi
    ;;
esac

case "$1" in                                         # was soll ich tun?
  show)
    testlock                        # another instance running?
    lock                            # lock this instance
    active=`grep ^user /etc/ppp/peers/circuit.pppoe | sed 'suser '`
    active=`grep $active /var/run/pppoe-circuits.conf | cut -d" " -f1`
    cat /var/run/pppoe-circuits.conf | cut -d" " -f1 | sed "s$active*$active;s\";s\""
    #cat /etc/ppp/pap-secrets | grep -v '#'
    #cat /etc/ppp/peers/circuit.pppoe|grep ^user
    ;;
  del)
    testlock                        # another instance running?
    lock                            # lock this instance
    active=`grep ^user /etc/ppp/peers/circuit.pppoe | sed 'suser '`
    active=`grep $active /var/run/pppoe-circuits.conf | cut -d" " -f1`
    if [ $active = \"$2\" ]
    then
      echo "error:Can't delete active circuit"
    else
      DSL_OLDUSER=`grep ^\"$2\" /var/run/pppoe-circuits.conf | cut -d" " -f2`
      grep -v ^\"$2\" /var/run/pppoe-circuits.conf > /tmp/tmp.circ
      grep -v ^$DSL_OLDUSER /etc/ppp/pap-secrets > /tmp/tmp.pap
      mv /tmp/tmp.circ /var/run/pppoe-circuits.conf
      mv /tmp/tmp.pap /etc/ppp/pap-secrets
      echo "info:circuit \"$2\" deleted"
    fi
    ;;
  circuit)
    testlock                        # another instance running?
    lock                            # lock this instance
    use \"$2\"
    ;;
  add)
    testlock                        # another instance running?
    lock                            # lock this instance
    if [ -n "`grep ^\\"$2\\" /var/run/pppoe-circuits.conf`" ]
    then
      echo "error:Circuit already exists"
      unlock
      exit 1
    else
      echo "\"$2\" \"$3\"" >> /var/run/pppoe-circuits.conf   # circuit eintragen
      echo "\"$3\"  *  \"$4\"  *" >> /etc/ppp/pap-secrets    # secrets eintragen
      echo "info:circuit \"$2\" added"
    fi
    ;;
  change)
    testlock                        # another instance running?
    lock                            # lock this instance
    change \"$2\" \"$3\" \"$4\"
    ;;
  *)
    echo "Usage: `basename $0` {show | circuit NAME | add,change NAME USERNAME PASSWORD | del NAME}"
    ;;
esac

unlock