#!/bin/sh
#-----------------------------------------------------------------------------
# /bin/cgiconfig2_counter.sh - countdown for online-time
#
# Creation:     04.08.2004  benjamin h. <bosborros at web dot de>
# Last Update:  05.04.2004  benjamin h. <bosborros at web dot de>
#-----------------------------------------------------------------------------
set -x
set `ls /tmp/*.time | sed "s/\/tmp\///" | sed "s/.time//"`
ip_count=$#
count=1
while [ $count -le $ip_count ]
do
 tmpv="\$1"
 ipname=`eval "echo $tmpv"`
 ip=`echo $ipname | sed "s/_/\//"`
 timeleft=`cat /tmp/$ipname.time`
 timeleft=`expr $timeleft - 1`
 echo $timeleft > /tmp/$ipname.time
 if [ $timeleft -le 0 ]
 then
  if [ -f /tmp/$ipname.time ] ; then rm -f /tmp/$ipname.time ; fi
  iptest=`echo $ip | grep "/"`
  if [ "$iptest" = "" ]
  then
    FWRD_HOST_WHITE=`cat /tmp/cgiconfig2.white`
    nwadress=`cat /tmp/cgiconfig2.nwadr`
   if [ "$FWRD_HOST_WHITE" = "yes" ]
   then
     state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "white" | grep "0.0.0.0/0" | grep "all"`
     fwl_target="white"
   else
     state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
     fwl_target="ACCEPT"
   fi

   state_inp_fwrd=`/sbin/iptables -L INPUT -n --line-numbers | grep "$ip " | grep "fdrop" | grep -v "state RELATED,ESTABLISHED" | grep "0.0.0.0/0" | grep "all"`
   state_fwl=0
   if [ "$state_fwl_fwrd" != "" ] && [ "$FWRD_HOST_WHITE" = "yes" ] ; then state_fwl=1 ; fi
   if [ "$state_fwl_all" != "" ] && [ "$FWRD_HOST_WHITE" = "no" ] && [ "$state_fwl_fwrd" = "" ] ; then state_fwl=1 ; fi

   if [ "$state_fwl" = "1" ] 
   then
     if [ "$fwl_target" = "white" ]
     then
       fwl_fwrd_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "$fwl_target" | grep "0.0.0.0/0" | grep "all" | sed "s/[white].*//"`
       /sbin/iptables -R FORWARD $fwl_fwrd_num -s $ip -d 0.0.0.0/0 -p all -j fdrop
     else
       fwl_ins_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$nwadress " | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | sed "s/[ACCEPT].*//"`   
       /sbin/iptables -I FORWARD $fwl_ins_num -p all -s $ip -d 0.0.0.0/0 -j fdrop
     fi
   fi
   
   num_fw_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
   num_inp_est=`/sbin/iptables -L INPUT -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
   state_ins_estfw=`/sbin/iptables -L FORWARD -n --line-numbers | grep "fdrop" | grep "$ip " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
   state_ins_estinp=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep "$ip " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 
   if [ "$state_ins_estfw" = "" ]
   then
     /sbin/iptables -I FORWARD $num_fw_est -p all -s $ip -d 0.0.0.0/0 -m state --state ESTABLISHED,RELATED -j fdrop
   fi
   if [ "$state_ins_estinp" = "" ]
   then
     /sbin/iptables -I INPUT $num_inp_est -p all -s $ip -d 0.0.0.0/0 -m state --state ESTABLISHED,RELATED -j fdrop
   fi

   if [ "$state_inp_fwrd" = "" ]
   then
     fwl_inp_del=`/sbin/iptables -L INPUT -n --line-numbers | grep "ACCEPT" | grep "$nwadress " |grep "0.0.0.0/0" | grep "all" | sed "s/[ACCEPT].*//"`
     /sbin/iptables -I INPUT $fwl_inp_del -p all -s $ip -d 0.0.0.0/0 -j fdrop
   fi
 
else
    state_grp_inp=`/sbin/iptables -L INPUT -n --line-numbers| grep "all" | grep "0.0.0.0/0" | grep "$ip " | grep "ACCEPT" | sed "s/[ACCEPT].*//"`
    state_grp_forw=`/sbin/iptables -L FORWARD -n --line-numbers | grep "all" | grep "0.0.0.0/0" | grep "$ip " | grep "ACCEPT" | sed "s/[ACCEPT].*//"`
  
    if [ "$state_grp_inp" != "" ]
    then
      /sbin/iptables -D INPUT $state_grp_inp
    fi
  
    if [ "$state_grp_forw" != "" ]
    then
      /sbin/iptables -D FORWARD $state_grp_forw
    fi
   fi  
fi
count=`expr $count + 1`
shift 1
done
set +x
