#!/bin/sh
d_head1='<font face=verdana size=+2>'
d_head2='</font>'
d_thead1='<center><b><font color=ffffff face=verdana>'
d_thead2='</font></b></center>'
d_col_tborder='ffffff'
d_col_theadbg='000000'
d_col_theadbg2='ffffff'
d_col_tdefbg='f0f0f0'
d_col_tgroup1bg='6060ff'
d_col_tgroup2bg='ffff40'
d_col_tgroup3bg='c0c0ff'
d_col_tgroup4bg='ffffc0'
myname=`basename $0`
read wanip < /var/run/cgiconfig2_ip
refresh=-1
setup=main_cgiconfig2.cgi
state_fwrd_num=0
state_pfw_num=0
switch=cgiconfig2_switch.cgi
version=v0.9

export SEC_REALM="cgiconfig2"
export SEC_ACTION="set"
./sec-lib.cgi
if [ "$?" != "0" ] ; then exit 1 ; fi

#read client ips and hostnames from rc.cfg to tempfile
grep -v "localhost" /etc/hosts | grep -v "#" > /tmp/cgiconfig2.hosts

while read line
do
  ip="`echo $line | cut -d" " -f1`"
  name="`echo $line | cut -d" " -f2`"
done < /tmp/cgiconfig2.hosts

leasedir=`cat /tmp/cgiconfig2.dhcpdir`

cat $leasedir/dhcpd.leases | sed 's/\"//g;' > /tmp/cgiconfig2.hosts_dhcp
while read line
do

 if [ "`echo $line | cut -d" " -f1`" = "lease" ]
 then
  ip="`echo $line | cut -d" " -f2`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "client-hostname" ]
 then
  hostname="`echo $line | cut -d" " -f2 | cut -d";" -f1`"
  echo $ip $hostname >> /tmp/cgiconfig2.hosts
 fi

done < /tmp/cgiconfig2.hosts_dhcp

hostname=`cat /tmp/cgiconfig2.rname`
FWRD_HOST_WHITE=`cat /tmp/cgiconfig2.white`
nwadress=`cat /tmp/cgiconfig2.nwadr`
idx=`cat /tmp/cgiconfig2.idx`

#read network-adress from where all clients have access to Internet (blacklist only)
state_fwl_all=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$nwadress " | grep "ACCEPT" | grep "0.0.0.0/0" | grep "all"`

#set command line parameters
if [ "$*" != "" ] ; then QUERY_STRING=$* ; fi

#parse variables...
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
 if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
 eval "param_$var"
done

if [ "$param_help" != "" ] ; then refresh=-1 ; fi

if [ "$param_html" != "0" ]
then
 echo "Content-Type: text/html; charset=iso-8859-1
 Cache-control: no-store
 Pragma: no-cache
 Expires: `date -Ru`
 "
 echo "
 <html>
 <head>
  <title>OPT_cgiconfig2 $version</title>
  <meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$refresh;url=$setup?action=$param_referrer&app=$param_app\">
   <style type=\"text/css\"><!--
    a { text-decoration: none }
    a:hover { color: #ff0000; text-decoration: underline}
    body { font-family: verdana}
   --></style>
 </head>

 <body>
 <br>
 <center><b><big>"
fi



#hosts
if [ "$param_action" = "ping" ] || [ "$param_action" = "ping+all" ]
then
 if [ "$param_referrer" = "" ] ; then param_referrer=hosts; fi

 if [ "$param_host" = "all" ]
 then
  echo "<table border=\"0\"><tr><td><pre>"
  while read ip
  do
   ping -c 1 $ip &
  done < /tmp/cgiconfig2.hosts
  sleep 10
  echo "</pre></td></tr></table>"
 else
   echo "<pre>"
   ping -c 1 $param_host
   echo "</pre><hr>"
 fi
fi



#fwl

case $param_fwl_mode
in
 0)
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000>forwarding granted & router access granted for $param_fwl_host...</font><br>"
  else
   echo "    forwarding granted & router access granted for $param_fwl_host..."
  fi

 if [ "$FWRD_HOST_WHITE" = "yes" ]
 then
  state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "white" | grep "0.0.0.0/0" | grep "all"`
  fwl_target="white"
 else
  state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
  fwl_target="ACCEPT"
 fi

 state_inp_fwrd=`/sbin/iptables -L INPUT -n --line-numbers | grep "$param_fwl_host " | grep "fdrop" | grep -v "state RELATED,ESTABLISHED" | grep "0.0.0.0/0" | grep "all"`
 state_fwl=0
 if [ "$state_fwl_fwrd" = "" ] && [ "$FWRD_HOST_WHITE" = "yes" ] ; then state_fwl=1 ; fi
 if [ "$state_fwl_all" != "" ] && [ "$FWRD_HOST_WHITE" = "no" ] && [ "$state_fwl_fwrd" != "" ] ; then state_fwl=1 ; fi
  
 if [ "$state_fwl" = "1" ]
 then
  if [ "$fwl_target" = "white" ]
  then
   fwl_ins_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "fdrop" | grep -v "state RELATED,ESTABLISHED" | grep "$param_fwl_host " | grep "0.0.0.0/0" | grep "all" | sed "s/[fdrop].*//"`
   /sbin/iptables -R FORWARD $fwl_ins_num -p all -s $param_fwl_host -d 0.0.0.0/0 -j white
  else
   fwl_fwrd_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep -v "state RELATED,ESTABLISHED" | grep "fdrop" | grep "0.0.0.0/0" | grep "all" | sed "s/[fdrop].*//"`
   /sbin/iptables -D FORWARD $fwl_fwrd_num
  fi
 fi
 
 num_fw_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
 num_inp_est=`/sbin/iptables -L INPUT -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
 state_ins_estfw=`/sbin/iptables -L FORWARD -n --line-numbers | grep "fdrop" | grep "$param_fwl_host " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 state_ins_estinp=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep "$param_fwl_host " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 if [ "$state_ins_estfw" != "" ]
 then
  num_fw_estd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "fdrop" | grep "all" | grep "$param_fwl_host " | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
  /sbin/iptables -D FORWARD $num_fw_estd
 fi
 if [ "$state_ins_estinp" != "" ]
 then
  num_inp_estd=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep "all" | grep "$param_fwl_host " | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
  /sbin/iptables -D INPUT $num_inp_estd
 fi

 if [ "$state_inp_fwrd" != "" ]
 then
  fwl_inp_del=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep -v "state RELATED,ESTABLISHED" | grep "$param_fwl_host " | grep "0.0.0.0/0" | grep "all" | sed "s/[fdrop].*//"`
  /sbin/iptables -D INPUT $fwl_inp_del
 fi
 ;;
 1)
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=ffde00>forwarding denied & router access granted for $param_fwl_host...</font><br>"
  else
   echo "    forwarding denied & router access granted for $param_fwl_host..."
  fi

 if [ "$FWRD_HOST_WHITE" = "yes" ]
 then
  state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "white" | grep "0.0.0.0/0" | grep "all"`
  fwl_target="white"
 else
  state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
  fwl_target="ACCEPT"
 fi

 state_inp_fwrd=`/sbin/iptables -L INPUT -n --line-numbers | grep "$param_fwl_host " | grep -v "state RELATED,ESTABLISHED" |grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
 state_fwl=0
 if [ "$state_fwl_fwrd" != "" ] && [ "$FWRD_HOST_WHITE" = "yes" ] ; then state_fwl=1 ; fi
 if [ "$state_fwl_all" != "" ] && [ "$FWRD_HOST_WHITE" = "no" ] && [ "$state_fwl_fwrd" = "" ] ; then state_fwl=1 ; fi

 if [ "$state_fwl" = "1" ] 
 then
  if [ "$fwl_target" = "white" ]
  then
   fwl_fwrd_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "$fwl_target" | grep "0.0.0.0/0" | grep "all" | sed "s/[white].*//"`
   /sbin/iptables -R FORWARD $fwl_fwrd_num -s $param_fwl_host -d 0.0.0.0/0 -p all -j fdrop
  else
   fwl_ins_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$nwadress " | grep -v "state RELATED,ESTABLISHED" | grep "ACCEPT" | grep "all" | sed "s/[ACCEPT].*//"`
   /sbin/iptables -I FORWARD $fwl_ins_num -p all -s $param_fwl_host -d 0.0.0.0/0 -j fdrop
  fi
 fi
 
 num_fw_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
 num_inp_est=`/sbin/iptables -L INPUT -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
 state_ins_estfw=`/sbin/iptables -L FORWARD -n --line-numbers | grep "fdrop" | grep "$param_fwl_host " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 state_ins_estinp=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep "$param_fwl_host " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 
 if [ "$state_ins_estfw" = "" ]
 then
  /sbin/iptables -I FORWARD $num_fw_est -p all -s $param_fwl_host -d 0.0.0.0/0 -m state --state ESTABLISHED,RELATED -j fdrop
 fi
 if [ "$state_ins_estinp" != "" ]
 then
  num_inp_estd=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep "all" | grep "$param_fwl_host " | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
  /sbin/iptables -D INPUT $num_inp_estd
 fi

 if [ "$state_inp_fwrd" != "" ]
 then
  fwl_inp_del=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop"| grep -v "state RELATED,ESTABLISHED" | grep "$param_fwl_host " |grep "0.0.0.0/0" | grep "all" | sed "s/[fdrop].*//"`
  /sbin/iptables -D INPUT $fwl_inp_del
 fi
 ;;
 2)
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=ffde00>forwarding denied & router access denied for $param_fwl_host...</font><br>"
  else
   echo "    forwarding denied & router access denied for $param_fwl_host..."
  fi

 if [ "$FWRD_HOST_WHITE" = "yes" ]
 then
  state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "white" | grep "0.0.0.0/0" | grep "all"`
  fwl_target="white"
 else
  state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
  fwl_target="ACCEPT"
 fi

 state_inp_fwrd=`/sbin/iptables -L INPUT -n --line-numbers | grep "$param_fwl_host " | grep "fdrop" | grep -v "state RELATED,ESTABLISHED" | grep "0.0.0.0/0" | grep "all"`
 state_fwl=0
 if [ "$state_fwl_fwrd" != "" ] && [ "$FWRD_HOST_WHITE" = "yes" ] ; then state_fwl=1 ; fi
 if [ "$state_fwl_all" != "" ] && [ "$FWRD_HOST_WHITE" = "no" ] && [ "$state_fwl_fwrd" = "" ] ; then state_fwl=1 ; fi

 if [ "$state_fwl" = "1" ] 
 then
  if [ "$fwl_target" = "white" ]
  then
   fwl_fwrd_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_fwl_host " | grep "$fwl_target" | grep "0.0.0.0/0" | grep "all" | sed "s/[white].*//"`
   /sbin/iptables -R FORWARD $fwl_fwrd_num -s $param_fwl_host -d 0.0.0.0/0 -p all -j fdrop
  else
   fwl_ins_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$nwadress " | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | sed "s/[ACCEPT].*//"`   
   /sbin/iptables -I FORWARD $fwl_ins_num -p all -s $param_fwl_host -d 0.0.0.0/0 -j fdrop
  fi
 fi

 num_fw_est=`/sbin/iptables -L FORWARD -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
 num_inp_est=`/sbin/iptables -L INPUT -n --line-numbers | grep "ACCEPT" | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[ACCEPT].*//"`
 state_ins_estfw=`/sbin/iptables -L FORWARD -n --line-numbers | grep "fdrop" | grep "$param_fwl_host " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 state_ins_estinp=`/sbin/iptables -L INPUT -n --line-numbers | grep "fdrop" | grep "$param_fwl_host " | grep "all" | grep "0.0.0.0/0" | grep "state RELATED,ESTABLISHED" | sed "s/[fdrop].*//"`
 
 if [ "$state_ins_estfw" = "" ]
 then
  /sbin/iptables -I FORWARD $num_fw_est -p all -s $param_fwl_host -d 0.0.0.0/0 -m state --state ESTABLISHED,RELATED -j fdrop
 fi
 if [ "$state_ins_estinp" = "" ]
 then
  /sbin/iptables -I INPUT $num_inp_est -p all -s $param_fwl_host -d 0.0.0.0/0 -m state --state ESTABLISHED,RELATED -j fdrop
 fi

 if [ "$state_inp_fwrd" = "" ]
 then
  fwl_inp_del=`/sbin/iptables -L INPUT -n --line-numbers | grep "ACCEPT" | grep "$nwadress " |grep "0.0.0.0/0" | grep "all" | sed "s/[ACCEPT].*//"`
  /sbin/iptables -I INPUT $fwl_inp_del -p all -s $param_fwl_host -d 0.0.0.0/0 -j fdrop
 fi
 ;;
esac


#PORTFORWARDINGS from base.txt
case $param_fwrd_mode
in
 0)
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000><B>forwarding-rule </B><br><br>
           Port: $param_port_fwrd <br>
           Protocol: $param_prot_fwrd <br>
           IP: $param_ip_fwrd <br><br>
           
           <B> DISBALED... </B></font><br>"
  else
   echo "    forwarding-rule: $param_port_fwrd $param_ip_fwrd $param_prot_fwrd disabled..."
  fi

state_pfw_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_prot_fwrd" | grep "$param_ip_fwrd" | grep "ACCEPT" | grep "0.0.0.0/0" | grep "$param_port_fwrd" | sed "s/[ACCEPT].*//"`
state_pre_n=`/sbin/iptables -t nat -L PREROUTING -n --line-numbers | grep "$param_prot_fwrd" | grep "$param_ip_fwrd" | grep "DNAT" | grep "0.0.0.0/0" | grep "$param_port_fwrd" | sed "s/[DNAT].*//"`

 if [ "$state_pfw_num" != "" ]
 then
  /sbin/iptables -R FORWARD $state_pfw_num -p $param_prot_fwrd -s 0.0.0.0/0 -d $param_ip_fwrd --destination-port $param_port_fwrd -j fdrop 
 fi
 if [ "$state_pre_n" != "" ]
 then
  /sbin/iptables -t nat -D PREROUTING $state_pre_n
 fi
 
 ;;
 1)
  if [ "$param_html" != "0" ]
  then
   echo "  <font color=008000><B>forwarding-rule</B><br><br>
           Port: $param_port_fwrd <br>
           Protocol: $param_prot_fwrd <br>
           IP: $param_ip_fwrd <br><br>
           
           <B> ENABLED... </B></font><br>"
  else
   echo "    forwarding-rule: $param_port_fwrd $param_ip_fwrd $param_prot_fwrd enabled..."
  fi

state_pfw_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$param_prot_fwrd" | grep "$param_ip_fwrd" | grep "fdrop" | grep "0.0.0.0/0" | grep "$param_port_fwrd" | sed "s/[fdrop].*//"`
state_pre_n=`/sbin/iptables -t nat -L PREROUTING -n --line-numbers | grep "$param_prot_fwrd" | grep "$param_ip_fwrd" | grep "DNAT" | grep "0.0.0.0/0" | grep "$param_port_fwrd" | sed "s/[DNAT].*//"`

 if [ "$state_pfw_num" != "" ]
 then
  /sbin/iptables -R FORWARD $state_pfw_num -p $param_prot_fwrd -s 0.0.0.0/0 -d $param_ip_fwrd --destination-port $param_port_fwrd -j ACCEPT
 fi
 
 if [ "$state_pre_n" = "" ]
 then
  tmp_v=`echo $param_ip_fwrd:$param_port_fwrd`
  /sbin/iptables -t nat -A PREROUTING -p $param_prot_fwrd -d $wanip --destination-port $param_port_fwrd -j DNAT --to $tmp_v
 fi 
 ;;
esac


if [ "$param_action" = "ADD" ]
then
 tmp_var=`echo $param_fwrd_port | grep "%3A"`
 if [ "$tmp_var" != "" ]
 then
  tmp_port=`echo $param_fwrd_port | sed "s/%3A/:/"`
  /sbin/iptables -I FORWARD $param_pfw_add -p $param_fwrd_prot -s 0.0.0.0/0 -d $param_fwrd_host --destination-port $tmp_port -j ACCEPT
  /sbin/iptables -t nat -A PREROUTING -p $param_fwrd_prot -d $wanip --dport $tmp_port -j DNAT --to $param_fwrd_host
 else
  /sbin/iptables -I FORWARD $param_pfw_add -p $param_fwrd_prot -s 0.0.0.0/0 -d $param_fwrd_host --destination-port $param_fwrd_port -j ACCEPT
  /sbin/iptables -t nat -A PREROUTING -p $param_fwrd_prot -d $wanip --dport $param_fwrd_port -j DNAT --to $param_fwrd_host:$param_fwrd_port
 fi
 if [ "$param_html" != "0" ]
 then
  echo "  <br><font color=008000><B>forwarding-rule added for IP: $param_fwrd_host</B><br>"
 else
  echo "    forwarding-rule added for IP: $param_fwrd_host"
 fi
fi


if [ "$param_action" = "del_rule" ]
then
 if [ "$param_html" != "0" ]
 then
  echo "  <br><font color=008000><B>forwarding-rule no. $param_fwrd_rem has been removed...</B><br>"
 else
  echo "    forwarding-rule no. $param_fwrd_rem has been removed..."
 fi
 /sbin/iptables -D FORWARD $param_fwrd_rem
 /sbin/iptables -t nat -D PREROUTING $param_pre_rem
fi

if [ "$param_action" = "save" ]
then
 if [ "$param_state" = "yes" ]
 then
   if [ "$param_html" != "0" ]
   then
     echo "  <br><font color=008000><B>forwarding-rules saved</B><br>"
   else
     echo "    forwarding-rules saved"
   fi
   if [ -f /tmp/cgiconfig2.save ] ; then rm /tmp/cgiconfig2.save ; fi
   while read line
   do
     echo $line >> /tmp/cgiconfig2.save
   done < /tmp/cgiconfig2.fwrd
   
 else
   if [ "$param_html" != "0" ]
   then
     echo "  <br><font color=008000><B>save-file removed... modified rules will discarded after reboot</B><br>"
   else
     echo "    save-file removed... modified rules will discarded after reboot"
   fi
   rm -f /tmp/cgiconfig2.save
 fi
fi


#setup
if [ "$param_action" = "setup" ]
then
 if [ "$param_referrer" = "" ] ; then param_referrer=setup; fi
fi


if [ "$param_html" != "0" ]
then
 echo "</big></b></center>
 <br><br><br><br>
 <p align=right>done.<br><a href=\"$setup?action=$param_referrer&app=$param_app\">Continue...</a><br><br>
 <font face=verdana size=-2>
 Written by <a href=\"mailto:bosborros at gmx dot net\">Benjamin Hering</a><br>
 $version <a href=\"http://www.fli4l.de\" target=\"_blank\">www.fli4l.de</a></p>
 </body></html>"
fi

if [ -f /tmp/cgiconfig2.hosts ] ; then rm /tmp/cgiconfig2.hosts ; fi