#!/bin/sh
#----------------------------------------------------------------------------
# /usr/local/htdocs/main_onkonto.sh - main cgi-script for administration
#
# Package:      OnKonto - Version: 0.11
#
# Creation:     07/03/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
# Last Update:  07/22/2004  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#----------------------------------------------------------------------------
# Changelog:
#
# 07/03/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - initial release
#
# 07/03/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - edited the output
#
# 07/22/2004  -  Dennis Kellerer <Dennis.Kellerer@gmx.net>
#                - now onkonto is user-based
#----------------------------------------------------------------------------

SEC_REALM='onkonto'
SEC_ACTION='edit'
#. ./sec-lib.cgi
eval "`proccgi $*`"

workdir=`cat /etc/onkonto.workdir`
iplist=`cat $workdir/onkonto_iplist`
datum=`date +"%d.%m.%Y - %H:%M:%S"`

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo '<html><head>'
echo '<title>Linux-Router - Internetfreigabe-Verwaltung</title>'
echo '</head><body bgcolor="#FFFFFF" text="#000000"><center>'

echo "<table width=300><tr><td>Datum</td><td>$datum</td></tr><br><br>"

idx=1
while [ -e "$workdir/onkonto_user_${idx}_amount" ]
do

    username=`cat $workdir/onkonto_user_${idx}_name`
    remaining=`/usr/local/bin/onkonto.sh remain ${idx}`

    STUNDEN=`expr $remaining "/" 3600`
    STDDIFF=`expr $remaining "%" 3600`
    MINUTEN=`expr $STDDIFF "/" 60`
    SEKUNDEN=`expr $STDDIFF "%" 60`
  
    if [ $STUNDEN -lt 10 ]; then
        STUNDEN=0$STUNDEN
    fi
    if [ $MINUTEN -lt 10 ]; then
        MINUTEN=0$MINUTEN
    fi
    if [ $SEKUNDEN -lt 10 ]; then
        SEKUNDEN=0$SEKUNDEN
    fi

    if [ -e "$workdir/onkonto_user_${idx}_ip" ]
    then
        ip=`cat $workdir/onkonto_user_${idx}_ip`
        if [ -e "$workdir/onkonto_user_${idx}_online" ]
        then
            #
            # Online
            #
            STATUS=online
            COLOR=00C000
        else
            #
            # Logged in, but offline
            #
            STATUS=offline
            COLOR=C0C000
        fi
    else
        ip="-"
        #
        # Logged Out
        #
        STATUS="logged out"
        COLOR=C00000
    fi

    echo "<table width=300><tr><td>User</td><td>$username</td></tr>"
    echo "<tr><td>IP:</td><td>$ip</td></tr>"
    echo "<tr><td>Status</td><td><font color=\"#$COLOR\">$STATUS</font>"
    echo "</td></tr><tr><td>Restguthaben</td><td>$STUNDEN:$MINUTEN:$SEKUNDEN</td></tr></table>"
    echo "<br><br>"

    idx=`/usr/bin/expr $idx + 1`
done
echo "</center></body></html>"



exit 0
